/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.config.AzurePredicatesModule;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCard;
import org.jclouds.azurecompute.arm.domain.NetworkProfile;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroup;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityGroupProperties;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRuleProperties;
import org.jclouds.azurecompute.arm.domain.ResourceGroup;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.features.NetworkSecurityGroupApi;
import org.jclouds.azurecompute.arm.features.NetworkSecurityRuleApi;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class AzureComputeSecurityGroupExtension
implements SecurityGroupExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final Function<NetworkSecurityGroup, SecurityGroup> securityGroupConverter;
    private final AzurePredicatesModule.SecurityGroupAvailablePredicateFactory securityGroupAvailable;
    private final AzurePredicatesModule.SecurityGroupRuleAvailablePredicateFactory securityGroupRuleAvailable;
    private final Predicate<URI> resourceDeleted;
    private final LoadingCache<String, ResourceGroup> defaultResourceGroup;
    private final Supplier<Set<String>> regionIds;

    @Inject
    AzureComputeSecurityGroupExtension(AzureComputeApi api, Function<NetworkSecurityGroup, SecurityGroup> groupConverter, AzurePredicatesModule.SecurityGroupAvailablePredicateFactory securityGroupAvailable, AzurePredicatesModule.SecurityGroupRuleAvailablePredicateFactory securityGroupRuleAvailable, @Named(value="jclouds.azurecompute.arm.timeout.resourcedeleted") Predicate<URI> resourceDeleted, LoadingCache<String, ResourceGroup> defaultResourceGroup, @Region Supplier<Set<String>> regionIds) {
        this.api = api;
        this.securityGroupConverter = groupConverter;
        this.securityGroupAvailable = securityGroupAvailable;
        this.securityGroupRuleAvailable = securityGroupRuleAvailable;
        this.resourceDeleted = resourceDeleted;
        this.defaultResourceGroup = defaultResourceGroup;
        this.regionIds = regionIds;
    }

    @Override
    public Set<SecurityGroup> listSecurityGroupsInLocation(Location location) {
        return this.securityGroupsInLocations(ImmutableSet.of(location.getId()));
    }

    @Override
    public Set<SecurityGroup> listSecurityGroups() {
        return this.securityGroupsInLocations(this.regionIds.get());
    }

    private Set<SecurityGroup> securityGroupsInLocations(final Set<String> locations) {
        ImmutableSet<SecurityGroup> allSecurityGroups = ImmutableSet.copyOf(Iterables.transform(Iterables.filter(this.api.getNetworkSecurityGroupApi(null).listAll(), Predicates.notNull()), this.securityGroupConverter));
        return ImmutableSet.copyOf(Iterables.filter(allSecurityGroups, new Predicate<SecurityGroup>(){

            @Override
            public boolean apply(SecurityGroup input) {
                return input.getLocation() != null && locations.contains(input.getLocation().getId());
            }
        }));
    }

    @Override
    public Set<SecurityGroup> listSecurityGroupsForNode(String nodeId) {
        this.logger.debug(">> getting security groups for node %s...", nodeId);
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(nodeId);
        VirtualMachine vm = this.api.getVirtualMachineApi(resourceGroupAndName.resourceGroup()).get(resourceGroupAndName.name());
        if (vm == null) {
            throw new IllegalArgumentException("Node " + nodeId + " was not found");
        }
        List<NetworkProfile.NetworkInterface> networkInterfaces = vm.properties().networkProfile().networkInterfaces();
        ArrayList<NetworkSecurityGroup> networkGroups = new ArrayList<NetworkSecurityGroup>();
        for (NetworkProfile.NetworkInterface networkInterfaceCardIdReference : networkInterfaces) {
            String nicName = IdReference.extractName(networkInterfaceCardIdReference.id());
            String nicResourceGroup = IdReference.extractResourceGroup(networkInterfaceCardIdReference.id());
            NetworkInterfaceCard card = this.api.getNetworkInterfaceCardApi(nicResourceGroup).get(nicName);
            if (card == null || card.properties().networkSecurityGroup() == null) continue;
            String secGroupName = card.properties().networkSecurityGroup().name();
            String sgResourceGroup = card.properties().networkSecurityGroup().resourceGroup();
            NetworkSecurityGroup group = this.api.getNetworkSecurityGroupApi(sgResourceGroup).get(secGroupName);
            networkGroups.add(group);
        }
        return ImmutableSet.copyOf(Iterables.transform(Iterables.filter(networkGroups, Predicates.notNull()), this.securityGroupConverter));
    }

    @Override
    public SecurityGroup getSecurityGroupById(String id) {
        this.logger.debug(">> getting security group %s...", id);
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        NetworkSecurityGroup securityGroup = this.api.getNetworkSecurityGroupApi(resourceGroupAndName.resourceGroup()).get(resourceGroupAndName.name());
        return securityGroup == null ? null : this.securityGroupConverter.apply(securityGroup);
    }

    @Override
    public SecurityGroup createSecurityGroup(String name, Location location) {
        ResourceGroup resourceGroup = this.defaultResourceGroup.getUnchecked(location.getId());
        this.logger.debug(">> creating security group %s in %s...", name, location);
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.name(name);
        builder.location(location);
        NetworkSecurityGroup sg = this.api.getNetworkSecurityGroupApi(resourceGroup.name()).createOrUpdate(name, location.getId(), null, NetworkSecurityGroupProperties.builder().build());
        Preconditions.checkState(this.securityGroupAvailable.create(resourceGroup.name()).apply(name), "Security group was not created in the configured timeout");
        return this.securityGroupConverter.apply(sg);
    }

    @Override
    public boolean removeSecurityGroup(String id) {
        this.logger.debug(">> deleting security group %s...", id);
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(id);
        URI uri = this.api.getNetworkSecurityGroupApi(resourceGroupAndName.resourceGroup()).delete(resourceGroupAndName.name());
        if (uri != null) {
            return this.resourceDeleted.apply(uri);
        }
        return false;
    }

    @Override
    public SecurityGroup addIpPermission(IpPermission ipPermission, SecurityGroup group) {
        return this.addIpPermission(ipPermission.getIpProtocol(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getTenantIdGroupNamePairs(), ipPermission.getCidrBlocks(), ipPermission.getGroupIds(), group);
    }

    @Override
    public SecurityGroup removeIpPermission(IpPermission ipPermission, SecurityGroup group) {
        return this.removeIpPermission(ipPermission.getIpProtocol(), ipPermission.getFromPort(), ipPermission.getToPort(), ipPermission.getTenantIdGroupNamePairs(), ipPermission.getCidrBlocks(), ipPermission.getGroupIds(), group);
    }

    @Override
    public SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        String portRange = startPort + "-" + endPort;
        String ruleName = "ingress-" + protocol.name().toLowerCase() + "-" + portRange;
        this.logger.debug(">> adding ip permission [%s] to %s...", ruleName, group.getName());
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(group.getId());
        NetworkSecurityGroupApi groupApi = this.api.getNetworkSecurityGroupApi(resourceGroupAndName.resourceGroup());
        NetworkSecurityGroup networkSecurityGroup = groupApi.get(resourceGroupAndName.name());
        if (networkSecurityGroup == null) {
            throw new IllegalArgumentException("Security group " + group.getName() + " was not found");
        }
        NetworkSecurityRuleApi ruleApi = this.api.getNetworkSecurityRuleApi(resourceGroupAndName.resourceGroup(), networkSecurityGroup.name());
        int nextPriority = this.getRuleStartingPriority(networkSecurityGroup);
        for (String ipRange : ipRanges) {
            NetworkSecurityRuleProperties properties = NetworkSecurityRuleProperties.builder().protocol(NetworkSecurityRuleProperties.Protocol.fromValue(protocol.name())).sourceAddressPrefix(ipRange).sourcePortRange("*").destinationAddressPrefix("*").destinationPortRange(portRange).direction(NetworkSecurityRuleProperties.Direction.Inbound).access(NetworkSecurityRuleProperties.Access.Allow).priority(nextPriority++).build();
            this.logger.debug(">> creating network security rule %s for %s...", ruleName, ipRange);
            ruleApi.createOrUpdate(ruleName, properties);
            Preconditions.checkState(this.securityGroupRuleAvailable.create(resourceGroupAndName.resourceGroup(), networkSecurityGroup.name()).apply(ruleName), "Security group was not updated in the configured timeout");
        }
        return this.getSecurityGroupById(group.getId());
    }

    @Override
    public SecurityGroup removeIpPermission(final IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, final Iterable<String> ipRanges, Iterable<String> groupIds, SecurityGroup group) {
        final String portRange = startPort + "-" + endPort;
        String ruleName = "ingress-" + protocol.name().toLowerCase() + "-" + portRange;
        this.logger.debug(">> deleting ip permissions matching [%s] from %s...", ruleName, group.getName());
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(group.getId());
        NetworkSecurityGroupApi groupApi = this.api.getNetworkSecurityGroupApi(resourceGroupAndName.resourceGroup());
        NetworkSecurityGroup networkSecurityGroup = groupApi.get(resourceGroupAndName.name());
        if (networkSecurityGroup == null) {
            throw new IllegalArgumentException("Security group " + group.getName() + " was not found");
        }
        NetworkSecurityRuleApi ruleApi = this.api.getNetworkSecurityRuleApi(resourceGroupAndName.resourceGroup(), networkSecurityGroup.name());
        Iterable<NetworkSecurityRule> rules = Iterables.filter(ruleApi.list(), new Predicate<NetworkSecurityRule>(){

            @Override
            public boolean apply(NetworkSecurityRule input) {
                NetworkSecurityRuleProperties props = input.properties();
                return Objects.equal(portRange, props.destinationPortRange()) && Objects.equal((Object)NetworkSecurityRuleProperties.Protocol.fromValue(protocol.name()), (Object)props.protocol()) && Objects.equal((Object)NetworkSecurityRuleProperties.Direction.Inbound, (Object)props.direction()) && Objects.equal((Object)NetworkSecurityRuleProperties.Access.Allow, (Object)props.access()) && Iterables.any(ipRanges, Predicates.equalTo(props.sourceAddressPrefix().replace("*", "0.0.0.0/0")));
            }
        });
        for (NetworkSecurityRule matchingRule : rules) {
            this.logger.debug(">> deleting network security rule %s from %s...", matchingRule.name(), group.getName());
            URI uri = ruleApi.delete(matchingRule.name());
            if (uri == null) continue;
            Preconditions.checkState(this.resourceDeleted.apply(uri), "Rule %s could not be deleted in the configured timeout", matchingRule.id());
        }
        return this.getSecurityGroupById(group.getId());
    }

    @Override
    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    @Override
    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    @Override
    public boolean supportsGroupIds() {
        return false;
    }

    @Override
    public boolean supportsPortRangesForGroups() {
        return false;
    }

    @Override
    public boolean supportsExclusionCidrBlocks() {
        return false;
    }

    private int getRuleStartingPriority(NetworkSecurityGroup securityGroup) {
        List<NetworkSecurityRule> existingRules = securityGroup.properties().securityRules();
        return existingRules.isEmpty() ? 100 : AzureComputeSecurityGroupExtension.rulesByPriority().max(existingRules).properties().priority() + 1;
    }

    private static Ordering<NetworkSecurityRule> rulesByPriority() {
        return new Ordering<NetworkSecurityRule>(){

            @Override
            public int compare(NetworkSecurityRule left, NetworkSecurityRule right) {
                return left.properties().priority() - right.properties().priority();
            }
        };
    }
}

