/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.InternetGateway;
import org.jclouds.aws.ec2.domain.InternetGatewayAttachment;
import org.jclouds.aws.ec2.xml.InternetGatewayAttachmentSetHandler;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class InternetGatewayHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<InternetGateway> {
    private StringBuilder currentText = new StringBuilder();
    private InternetGateway.Builder builder = InternetGateway.builder();
    private final TagSetHandler tagSetHandler;
    private final InternetGatewayAttachmentSetHandler attachmentSetHandler;
    private boolean inTagSet;
    private boolean inAttachmentSet;

    @Inject
    InternetGatewayHandler(TagSetHandler tagSetHandler, InternetGatewayAttachmentSetHandler attachmentHandler) {
        this.tagSetHandler = tagSetHandler;
        this.attachmentSetHandler = attachmentHandler;
    }

    @Override
    public InternetGateway getResult() {
        try {
            InternetGateway internetGateway = this.builder.build();
            return internetGateway;
        }
        finally {
            this.builder = InternetGateway.builder();
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        this.currentText.setLength(0);
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
        if (SaxUtils.equalsOrSuffix(qName, "attachmentSet")) {
            this.inAttachmentSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        } else if (this.inAttachmentSet) {
            this.attachmentSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (SaxUtils.equalsOrSuffix(qName, "attachmentSet")) {
            this.inAttachmentSet = false;
            this.builder.attachmentSet((List<InternetGatewayAttachment>)this.attachmentSetHandler.getResult());
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        } else if (this.inAttachmentSet) {
            this.attachmentSetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "internetGatewayId")) {
            this.builder.id(SaxUtils.currentOrNull(this.currentText));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else if (this.inAttachmentSet) {
            this.attachmentSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

