/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.springboot.repository;

import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OldOfficeBackupPolicy;
import com.parablu.pcbd.domain.OldUser;
import com.parablu.pcbd.domain.User;
import com.parablu.springboot.repository.OfficeBackupPolicyRepository;
import java.util.List;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class OfficeBackupPolicyRepositoryImpl
implements OfficeBackupPolicyRepository {
    public MongoDatabaseFactory mongoDbFactory(String mongoMainIP, String mongoMainPort) {
        return new SimpleMongoClientDatabaseFactory("mongodb://neil:parablu@" + mongoMainIP + ":" + mongoMainPort + "/parablu001");
    }

    public MongoTemplate mongoTemplate(String mongoMainIP, String mongoMainPort) {
        return new MongoTemplate(this.mongoDbFactory(mongoMainIP, mongoMainPort));
    }

    public List<OldOfficeBackupPolicy> loadAll(String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        return mongoTemplate.findAll(OldOfficeBackupPolicy.class);
    }

    public OfficeBackupPolicy getNewPolicy(String policyName, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    public List<OldUser> getAllUsersForPolicyName(String policyName, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), OldUser.class);
    }

    public void saveUser(User user, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        mongoTemplate.save((Object)user);
    }

    public void saveNewPolicy(OfficeBackupPolicy newPolicy, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        mongoTemplate.save((Object)newPolicy);
    }

    public DeviceBackupOverView getDeviceBkpOverview(String policyName, String name, String userName, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)name), Criteria.where((String)"odbPolicyName").is((Object)policyName), Criteria.where((String)"userName").is((Object)userName)});
        return (DeviceBackupOverView)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeviceBackupOverView.class);
    }

    public void saveOverView(DeviceBackupOverView backupOverView, String mongoMainIP, String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainIP, mongoMainPort);
        mongoTemplate.save((Object)backupOverView);
    }
}

