/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.backupmigrateutility;

import com.parablu.backupmigrateutility.service.MigrationService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;

@SpringBootApplication
public class BackupMigrateUtilityApplication {
    private static final Logger logger = LoggerFactory.getLogger(BackupMigrateUtilityApplication.class);
    private static final String START = "start";
    private static final String RESTART = "restart";

    public static void main(String[] args) {
        try {
            ConfigurableApplicationContext context = SpringApplication.run(BackupMigrateUtilityApplication.class, (String[])args);
            MigrationService migrationService = (MigrationService)context.getBean(MigrationService.class);
            File file = null;
            String action = null;
            String threads = null;
            String documents = null;
            if (args != null && args.length == 1) {
                logger.info("getting the file path = " + args[0]);
                file = new File(args[0]);
                if (!file.exists()) {
                    logger.info("File path is invalid.");
                    return;
                }
            } else {
                logger.info("There is error in arguments passed... please pass valid arguments!!");
                return;
            }
            logger.info("File path is valid.");
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                logger.info("Reading the file line to get the action");
                while ((line = reader.readLine()) != null) {
                    if (line.contains("action") && line.contains("=")) {
                        action = line.split("=")[1].trim();
                        action = action.trim();
                        logger.info("the action given in the file is = " + action);
                    }
                    if (line.contains("threads") && line.contains("=")) {
                        threads = line.split("=")[1].trim();
                        threads = threads.trim();
                        logger.info("the threads given in the file is = " + threads);
                    }
                    if (!line.contains("documents") || !line.contains("=")) continue;
                    documents = line.split("=")[1].trim();
                    documents = documents.trim();
                    logger.info("the documents given in the file is = " + documents);
                }
            }
            if (null == action) {
                logger.info("action is not present in the file");
                return;
            }
            if (null == threads) {
                logger.info("threads is not mentioned in the file");
                return;
            }
            if (null == documents) {
                logger.info("documents is not mentioned in the file");
                return;
            }
            if (START.equals(action.toLowerCase())) {
                migrationService.startMigration(Integer.parseInt(threads), Integer.parseInt(documents));
            } else if (RESTART.equals(action.toLowerCase())) {
                migrationService.restartMigration(Integer.parseInt(threads), Integer.parseInt(documents));
            }
        }
        catch (Exception e) {
            logger.error("There is an error while running the utility e= " + e);
        }
    }
}

