/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.springboot.repository;

import com.parablu.pcbd.domain.DeltaPath;
import com.parablu.pcbd.domain.DeviceBackupOverView;
import com.parablu.pcbd.domain.ODBBackupBatch;
import com.parablu.pcbd.domain.OfficeBackupPolicy;
import com.parablu.pcbd.domain.OldOfficeBackupPolicy;
import com.parablu.pcbd.domain.OldUser;
import com.parablu.pcbd.domain.User;
import com.parablu.springboot.repository.ParaBluMsgRepository;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ParaBluMsgRepositoryImpl
implements ParaBluMsgRepository {
    public MongoDatabaseFactory mongoDbFactory(String mongoMainIP, String mongoMainPort) {
        return new SimpleMongoClientDatabaseFactory("mongodb://neil:parablu@" + mongoMainIP + ":" + mongoMainPort + "/parablumsg");
    }

    public MongoTemplate mongoTemplate(String mongoMainIP, String mongoMainPort) {
        return new MongoTemplate(this.mongoDbFactory(mongoMainIP, mongoMainPort));
    }

    public MongoDatabaseFactory mongoDbFactory(String mongoMainPort) {
        return new SimpleMongoClientDatabaseFactory("mongodb://neil:parablu@localhost:" + mongoMainPort + "/parablumsg");
    }

    public MongoDatabaseFactory mongoDbFactory() {
        return new SimpleMongoClientDatabaseFactory("mongodb://neil:parablu@localhost:48765/parablumsg");
    }

    public MongoTemplate mongoTemplate(String mongoMainPort) {
        return new MongoTemplate(this.mongoDbFactory(mongoMainPort));
    }

    public MongoTemplate mongoTemplate() {
        return new MongoTemplate(this.mongoDbFactory());
    }

    public List<OldOfficeBackupPolicy> loadAll() {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        Set collectionNames = mongoTemplate.getCollectionNames();
        return mongoTemplate.findAll(OldOfficeBackupPolicy.class);
    }

    public Set<String> loadAllCollectionNames(MongoTemplate mongoTemplate) {
        Set collectionNames = mongoTemplate.getCollectionNames();
        return collectionNames;
    }

    public MongoTemplate getTemplateForPort(String mongoMainPort) {
        MongoTemplate mongoTemplate = this.mongoTemplate(mongoMainPort);
        return mongoTemplate;
    }

    public OfficeBackupPolicy getNewPolicy(String policyName) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"policyName").is((Object)policyName)});
        return (OfficeBackupPolicy)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), OfficeBackupPolicy.class);
    }

    public List<OldUser> getAllUsersForPolicyName(String policyName) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        return mongoTemplate.find(new Query((CriteriaDefinition)criteria), OldUser.class);
    }

    public void saveUser(User user) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        mongoTemplate.save((Object)user);
    }

    public void saveNewPolicy(OfficeBackupPolicy newPolicy) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        mongoTemplate.save((Object)newPolicy);
    }

    public DeviceBackupOverView getDeviceBkpOverview(String policyName, String name) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"deviceType").is((Object)name), Criteria.where((String)"odbPolicyName").is((Object)policyName)});
        return (DeviceBackupOverView)mongoTemplate.findOne(new Query((CriteriaDefinition)criteria), DeviceBackupOverView.class);
    }

    public void saveOverView(DeviceBackupOverView backupOverView) {
        MongoTemplate mongoTemplate = this.mongoTemplate();
        mongoTemplate.save((Object)backupOverView);
    }

    public List<ODBBackupBatch> loadAll(String batchdb, MongoTemplate mongoTemplate) {
        Query query = new Query();
        return mongoTemplate.find(query, ODBBackupBatch.class, batchdb);
    }

    public void removeBatch(ODBBackupBatch backupBatch, String oldDbName, MongoTemplate mongoTemplate) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)backupBatch.getId())});
        Query query = new Query((CriteriaDefinition)criteria);
        mongoTemplate.findAndRemove(query, ODBBackupBatch.class, oldDbName);
    }

    public void updateAllDeltaPath(MongoTemplate mainMongoTemplate, MongoTemplate localmongoTemplate) {
        List deltaPaths = localmongoTemplate.findAll(DeltaPath.class);
        if (!CollectionUtils.isEmpty((Collection)deltaPaths)) {
            for (DeltaPath deltaPath : deltaPaths) {
                mainMongoTemplate.save((Object)deltaPath);
                Criteria criteria = new Criteria();
                criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)deltaPath.getId())});
                Query query = new Query((CriteriaDefinition)criteria);
                mainMongoTemplate.findAndRemove(query, DeltaPath.class);
            }
        }
    }
}

