/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.Cloud;
import com.pg.controller.BaseController;
import com.pg.domain.FileInfo;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UploadService;
import com.pg.service.UtilService;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class RestoreFailedFilesJob
extends QuartzJobBean
implements Job {
    private static Logger logger = LogManager.getLogger(RestoreFailedFilesJob.class);
    public static final String ENCRYPTED = "/encrypted/";
    public static final String CHUNK = "/chunk/";
    private static List<FileInfo> fileInfoList = null;
    private TimerTask backupTimerTask = null;
    private Timer backupTimer = null;
    private UploadService uploadService;
    private UtilService utilService;

    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    protected void executeInternal(JobExecutionContext arg0) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"restoreFailedLatestJobTrigger")) {
            logger.debug("RestoreFailedFilesJob ............ disabled");
            return;
        }
        logger.debug("@@@@RestoreFailedFilesJob started ..... " + PCHelperConstant.getODBCallFrequency());
        ExecutorService executor = null;
        try {
            Cloud cloud = this.utilService.getCloud(1);
            boolean threadSizeVal = true;
            executor = Executors.newFixedThreadPool(1);
            fileInfoList = this.uploadService.getFaileFilesForReUpload(cloud.getCloudName());
            ExecutorCompletionService<String> pool = new ExecutorCompletionService<String>(executor);
            this.checkThreadStatusAndStartUpload(cloud, executor, pool);
            for (int i = 0; i < 1; ++i) {
                logger.debug("Creating thread for first time>>>>>>>>> i value::" + i);
                this.callUploadFiles(cloud, executor, pool);
            }
            logger.debug(" exit upload part..........");
        }
        catch (Exception e) {
            logger.error(" exception in backup upload job......." + e.getMessage());
            logger.trace("exception in backup upload job ......." + e);
        }
    }

    private void callUploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        BaseController.printLogs((String)"Files to backup ............... :", (boolean)PCHelperConstant.isBrevityLogging());
        Runnable uploadJob = () -> this.uploadFiles(cloud, executor, pool);
        pool.submit(uploadJob, "");
    }

    private void uploadFiles(Cloud cloud, ExecutorService executor, CompletionService<String> pool) {
        try {
            List<FileInfo> filesList = this.getListToProcess(cloud);
            if (!CollectionUtils.isEmpty(filesList)) {
                logger.debug("message list......................................." + filesList.size());
                int i = 0;
                for (FileInfo fileInfo : filesList) {
                    this.processMessage(fileInfo, cloud);
                    logger.error(i + "..files processing ..." + fileInfo.getId() + " %%%%%%% completed file name ...." + fileInfo.getFileName());
                    ++i;
                }
                logger.debug(" session commited.......with 2 sec delay.....");
                try {
                    Thread.sleep(Long.valueOf(PCHelperConstant.getMoveFileFromBkpToLocalInterval()));
                }
                catch (InterruptedException e) {
                    logger.error("Exception..........." + e.getMessage());
                }
            } else {
                BaseController.printLogs((String)"no files to upload so wait and then retry>>>>", (boolean)PCHelperConstant.isBrevityLogging());
                try {
                    Thread.sleep(Long.valueOf(PCHelperConstant.getMoveFileFromBkpToLocalInterval()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callUploadFiles(cloud, executor, pool);
            }
            BaseController.printLogs((String)"message upload completed for restore bkp queue..... ", (boolean)PCHelperConstant.isBrevityLogging());
        }
        catch (Exception e) {
            logger.error(PCHelperConstant.getMoveFileFromBkpToLocalInterval() + " pvnnn exception inside RestoreFailedFilesJob .... ", (Throwable)e);
            logger.trace(PCHelperConstant.getMoveFileFromBkpToLocalInterval() + " exception inside RestoreFailedFilesJob ....", (Throwable)e);
        }
    }

    private synchronized List<FileInfo> getListToProcess(Cloud cloud) {
        ArrayList<Object> list;
        int limitValue = 5000;
        boolean lastRecords = false;
        logger.debug("..... getListToProcess..... " + fileInfoList.size());
        if (fileInfoList.size() >= limitValue) {
            list = new ArrayList(fileInfoList.stream().limit(limitValue).collect(Collectors.toList()));
        } else {
            list = new ArrayList<FileInfo>(fileInfoList);
            lastRecords = true;
        }
        fileInfoList.removeAll(list);
        if (lastRecords && CollectionUtils.isEmpty(fileInfoList)) {
            fileInfoList = this.getMessagesToProcess(cloud);
        }
        return list;
    }

    private List<FileInfo> getMessagesToProcess(Cloud cloud) {
        List latestList = this.uploadService.getFaileFilesForReUpload(cloud.getCloudName());
        logger.debug("..... getmessageToProcess..... " + latestList.size());
        fileInfoList = latestList;
        return fileInfoList;
    }

    public void checkThreadStatusAndStartUpload(final Cloud cloud, final ExecutorService executor, final CompletionService<String> pool) {
        if (this.backupTimer == null) {
            this.backupTimer = new Timer();
        }
        if (this.backupTimerTask == null) {
            this.backupTimerTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BaseController.printLogs((String)"Check the task is completed>>>>>>>>", (boolean)PCHelperConstant.isBrevityLogging());
                        Future future = pool.take();
                        if (future.isDone()) {
                            BaseController.printLogs((String)"Thread is completed so assign new task>>>>>>>>>>>", (boolean)PCHelperConstant.isBrevityLogging());
                            RestoreFailedFilesJob.this.callUploadFiles(cloud, executor, pool);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error in checkThreadStatusAndStartUpload", (Throwable)e);
                        logger.trace("" + e);
                    }
                }
            };
            this.backupTimer.schedule(this.backupTimerTask, 1000L, 1000L);
        }
    }

    private boolean uploadFile(FileInfo fileInfo, Cloud cloud) {
        boolean isFileUploaded = true;
        try {
            this.uploadService.restoreFailedFiles(fileInfo, cloud);
        }
        catch (Exception e) {
            logger.debug("" + e);
            logger.error(fileInfo.getFileName() + "#####FILE NOT UPLOADED SUCCESSFULLY .. " + e.getMessage());
        }
        return isFileUploaded;
    }

    public void processMessage(FileInfo fileInfo, Cloud cloud) {
        try {
            logger.debug("Processing " + fileInfo.getFileName());
            boolean isFileUploaded = this.uploadFile(fileInfo, cloud);
            logger.debug(" message status.............. " + isFileUploaded);
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error("Exception inside RestoreFailedFilesJob Processor PooledConnectionFactory !" + e.getMessage());
        }
    }
}

