/*
 * Decompiled with CFR 0.152.
 */
package com.pg.timer;

import com.parablu.pcbd.domain.BackUpImage;
import com.parablu.pcbd.domain.ChunkDetail;
import com.parablu.pcbd.domain.ChunkFile;
import com.parablu.pcbd.domain.Cloud;
import com.parablu.pcbd.domain.CloudCustomisableDetails;
import com.parablu.pcbd.domain.SyncPolicy;
import com.parablu.pcbd.domain.User;
import com.pg.domain.FileInfo;
import com.pg.helper.constant.GeneralHelperConstant;
import com.pg.helper.constant.PCHelperConstant;
import com.pg.service.UtilService;
import com.pg.sync.service.SyncCloudUploadService;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bson.types.ObjectId;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class BlukryptDeleteExpiredSyncFilesJob
extends QuartzJobBean {
    private static final String GATEWAY_NAME = PCHelperConstant.getComponentName();
    private static final String ERROR_TRYING_TO_DELETE = " error trying to delete ..... ";
    private static final long DAY_IN_MS = 86400000L;
    private static final String ERROR_TRYING_TO_DELETE_FILES_FROM_PG = " error trying to delete files from pg .......";
    private static Logger logger = LogManager.getLogger(BlukryptDeleteExpiredSyncFilesJob.class);
    private UtilService utilService;
    private SyncCloudUploadService syncCloudUploadService;

    public void setUtilService(UtilService utilService) {
        this.utilService = utilService;
    }

    public void setSyncCloudUploadService(SyncCloudUploadService syncCloudUploadService) {
        this.syncCloudUploadService = syncCloudUploadService;
    }

    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (!PCHelperConstant.isJobEnabled((String)"blukryptDeleteExpiredSyncFilesTrigger")) {
            logger.debug("BlukryptDeleteExpiredSyncFilesJob ............. disabled");
            return;
        }
        logger.debug("Start of BlukryptDeleteExpiredSyncFilesJob ...................");
        int cloudId = 1;
        int noOfDays = 0;
        Cloud cloud = this.utilService.getCloud(cloudId);
        String cloudName = cloud.getCloudName();
        boolean isExpiredFileDeleteEnabled = true;
        if (isExpiredFileDeleteEnabled) {
            List users = this.utilService.getAllUser(cloudId);
            for (User user : users) {
                SyncPolicy syncPolicy;
                if (StringUtils.isEmpty((Object)user.getSyncPolicyName()) || (syncPolicy = this.utilService.getSyncpolicyByName(cloudId, user.getSyncPolicyName())) == null || (noOfDays = syncPolicy.getNoOfDaysToPurgeFile()) <= 0) continue;
                long filesExpiredDate = System.currentTimeMillis() - (long)noOfDays * 86400000L;
                String path = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
                List files = this.utilService.getAllSyncFilesToBeDeletedByUserName(cloudId, filesExpiredDate, user.getUserName(), user);
                if (!CollectionUtils.isEmpty((Collection)files)) {
                    for (BackUpImage backUpImage : files) {
                        if (backUpImage == null) continue;
                        this.deleteFilesFromPGOrCloud(cloud, backUpImage.getId());
                        this.deleteFileEntryIfFileShared(backUpImage);
                        this.deleteFilesFromDb(cloud, backUpImage, user);
                        this.utilService.removeBackupFromTempDb(cloud, backUpImage.getId(), true);
                        this.updateDailySyncOverView(cloudId, filesExpiredDate, backUpImage.getSize());
                    }
                    this.deleteFiles(path, noOfDays);
                }
                logger.error("@@@@End of BlukryptDeleteExpiredSyncFilesJob ..... ");
            }
        }
    }

    private void updateDailySyncOverView(int cloudId, long filesExpiredDate, double size) {
        try {
            filesExpiredDate = this.convertDateWithTimeStampToDate(filesExpiredDate);
            this.utilService.updateDailySyncOverView(cloudId, filesExpiredDate, size);
        }
        catch (Exception e) {
            logger.error("Exception:" + e);
            logger.trace("Exception" + e.getMessage());
        }
    }

    private long convertDateWithTimeStampToDate(long filesExpiredDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.00.00.00");
        Date resultdate = new Date(filesExpiredDate);
        String a = sdf.format(resultdate);
        Date date = sdf.parse(a);
        long milliseconds = date.getTime();
        return milliseconds;
    }

    private void deleteFilesFromDb(Cloud cloud, BackUpImage backUpImage, User user) {
        try {
            logger.debug(backUpImage.getLastServerModifiedTime() + " deleteFilesFromDb............. " + backUpImage.getFileName() + " ... user name ...." + backUpImage.getUserName());
            try {
                if (!backUpImage.getStatus().equalsIgnoreCase("DELETED") || !backUpImage.getStatus().equalsIgnoreCase("RESTORED")) {
                    int cloudId = cloud.getCloudId();
                    List chunkFiles = backUpImage.getChunkFiles();
                    if (chunkFiles != null && !CollectionUtils.isEmpty((Collection)chunkFiles)) {
                        this.reduceRefCountinChunkDetail(cloudId, chunkFiles, backUpImage.getUserName());
                    }
                    this.utilService.updateUserSyncOverview(backUpImage.getUserName(), (double)backUpImage.getSize());
                    this.utilService.updateSyncOverview((double)backUpImage.getSize());
                }
                this.utilService.deleteSyncBackUpImage(cloud.getCloudId(), backUpImage, user, null);
            }
            catch (Exception e) {
                logger.debug(ERROR_TRYING_TO_DELETE + e);
                logger.error(ERROR_TRYING_TO_DELETE + e.getMessage());
            }
        }
        catch (Exception e) {
            logger.debug(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e);
            logger.error(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e.getMessage());
        }
    }

    private void reduceRefCountinChunkDetail(int cloudId, List<ChunkFile> chunkFiles, String userName) {
        String dedupVal = this.getDedupValue(userName);
        for (ChunkFile chunkFile : chunkFiles) {
            ChunkDetail chunkDetail = this.utilService.getChunkDetailForMd5ForRestore(1, chunkFile.getMd5(), dedupVal, userName, true, false);
            logger.debug("Chunk detail md5 is " + chunkDetail.getMd5());
            if (chunkDetail.getRefCount() <= 0) continue;
            int refCount = chunkDetail.getRefCount() - 1;
            chunkDetail.setRefCount(refCount);
            this.utilService.updateChunkDetail(cloudId, chunkDetail);
        }
    }

    private String getDedupValue(String userName) {
        String dedupVal = null;
        User user = this.utilService.getUserInfoByName(1, userName);
        if (user != null) {
            SyncPolicy syncPolicy = this.utilService.getSyncPolicyByPolicyName(1, user.getSyncPolicyName());
            dedupVal = syncPolicy.getDedup();
        }
        return dedupVal;
    }

    private void deleteFilesFromPGOrCloud(Cloud cloud, ObjectId backUpImageId) {
        try {
            String cloudName = cloud.getCloudName();
            FileInfo fileInfo = this.syncCloudUploadService.getFileFromPG(cloudName, backUpImageId.toString(), false);
            logger.debug("file received from pg ......" + fileInfo);
            if (fileInfo != null) {
                String deviceTempPath = PCHelperConstant.getPropertyFileValueDefaultUploadPath((String)cloudName) + fileInfo.getDeviceUUID();
                String chunkFilePath = deviceTempPath + GeneralHelperConstant.CLOUD_PATH_SEPARATOR + "chunk";
                for (String fileName : fileInfo.getChunkFiles()) {
                    try {
                        logger.debug("Cloud upload  FILE started ..... " + fileName);
                        File file = new File(chunkFilePath + "/" + fileName);
                        if (!file.exists()) continue;
                        logger.debug(" file exists............." + file.getPath() + "......." + file.getName());
                        logger.debug(fileInfo.getUploadedTimestamp() + " files to be deleted ............. " + fileInfo.getFileName() + " ... user name ...." + fileInfo.getUserName());
                        try {
                            this.syncCloudUploadService.deleteUploadedFiles(fileInfo, cloudName, GATEWAY_NAME);
                        }
                        catch (Exception e) {
                            logger.debug(ERROR_TRYING_TO_DELETE + e);
                            logger.error(ERROR_TRYING_TO_DELETE + e.getMessage());
                        }
                        file.delete();
                        int dedupCount = 1;
                        String destPath = file.getPath() + "_" + dedupCount;
                        String path = file.getPath();
                        while (new File(destPath).exists()) {
                            File dedupFile = new File(destPath);
                            if (!dedupFile.exists()) continue;
                            if (dedupCount >= 2) {
                                file = new File(path + "_" + (dedupCount - 1));
                            }
                            FileUtils.copyFile((File)dedupFile, (File)file);
                            dedupFile.delete();
                            destPath = path + "_" + ++dedupCount;
                        }
                    }
                    catch (Exception e) {
                        logger.debug(" error trying to delete local file ......." + e);
                        logger.error(" error trying to delete local file ......." + e.getMessage());
                    }
                }
            }
            logger.debug(" after deleting  files from pg ... ");
        }
        catch (Exception e) {
            logger.debug(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e);
            logger.error(ERROR_TRYING_TO_DELETE_FILES_FROM_PG + e.getMessage());
        }
    }

    private boolean isExpiredFileDeleteEnabledForCloud(Cloud cl) {
        boolean isExpiredFileDeleteEnabled = false;
        List list = cl.getCloudCustomisableDetails();
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudCustomisableDetails cloudPluginDetails : list) {
                if (cloudPluginDetails == null || StringUtils.isEmpty((Object)cloudPluginDetails.getName()) || !"Expired Files Delete Enabled".equalsIgnoreCase(cloudPluginDetails.getName())) continue;
                isExpiredFileDeleteEnabled = true;
                break;
            }
        }
        return isExpiredFileDeleteEnabled;
    }

    private void deleteFileEntryIfFileShared(BackUpImage backUpImage) {
        this.utilService.deleteSharedFileImage(backUpImage.getDevicePath(), backUpImage.getFileName(), backUpImage.getUserName());
    }

    private void deleteFiles(String path, int noOfDays) {
        Date oldestAllowedFileDate = DateUtils.addDays((Date)new Date(), (int)noOfDays);
        File targetDir = new File(path);
        logger.debug(" Target Directory path to delete old files ........." + path);
        if (targetDir.isDirectory()) {
            Iterator filesToDelete = FileUtils.iterateFiles((File)targetDir, (IOFileFilter)new AgeFileFilter(oldestAllowedFileDate), (IOFileFilter)TrueFileFilter.INSTANCE);
            while (filesToDelete.hasNext()) {
                File fileToDelete = (File)filesToDelete.next();
                FileUtils.deleteQuietly((File)fileToDelete);
            }
        }
    }
}

