<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ServerController">
    <span class="hide currentPage"><?='devices'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4>
                        <?=$data['crumb1']?>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
<!--                            <a class="btn btn-success btn-small pull-right" href="--><?//=Url::basePath('server/new')?><!--">Add New Server</a>-->
                        <?php } ?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <form ng-submit="searchDevice(search.serverName)">
                                <input name="serverName"
                                       type="text"
                                       class="pull-right form-control"
                                       ng-model="search.serverName"
                                       placeholder="Enter a 'Server Name' or 'all (for all servers)' and hit enter to search"
                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                       data-content="Entered Server Name was not found!!! "
                                    />
                            </form>
                        </div>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <table class="table table-bordered table-striped deviceListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>
                                <th><?=Language::show('serverName', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devices track by $index">
                                <td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td class="text-center" ng-if="value.blocked == 'false'" ng-cloak>Active</td>
                                <td class="text-center" ng-if="value.blocked == 'true'" ng-cloak>De-Activated</td>
                                <td>
<!--                                    <a ng-if="value.blocked == 'false'" ng-click="sendMeTo('--><?//=Url::basePath('server/restore/')?><!--'+value.deviceUUID+'/'+value.deviceName)" class="btn btn-small btn-primary">Initiate Restore</a>-->
<!--                                    <a ng-if="value.blocked == 'false'" ng-bootbox-title="Backup Options"-->
<!--                                       ng-bootbox-custom-dialog="What type of backup do you want to run?"-->
<!--                                       ng-bootbox-buttons="backupOptions"-->
<!--                                       class="btn btn-small btn-primary"-->
<!--                                       ng-click="markAsSelectedServerForAction(value.deviceName)">Initiate Backup</a>-->
<!--                                    <a ng-if="value.blocked == 'false'" ng-click="refreshPolicy(value.deviceName)" class="btn btn-small btn-primary">Refresh Policy</a>-->
                                    <a ng-click="sendMeTo('<?=Url::basePath('server/attachContainer/')?>'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-small btn-success" ng-if="value.blocked == 'false'"><i class="fa fa-gears"></i> <?=Language::show('manageContainer', 'keywords');?></a>
                                    <a ng-click="blockUnBlockDevice(value.deviceUUID, false, $index)" class="btn btn-small btn-success" ng-if="value.blocked == 'true'"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
                                    <a ng-click="blockUnBlockDevice(value.deviceUUID, true, $index)" class="btn btn-small btn-danger" ng-if="value.blocked == 'false'"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMoreDevices(skipValue)">Load More ...</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade deviceDetails">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Device Details</h4>
                </div>
                <div class="modal-body">
                    <p><b>Created At</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.createdTimeStamp }}</span></p>
                    <p><b>Name</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.deviceName }}</span></p>
                    <p><b>Os Type</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.osType }}</span></p>
                    <p ng-if="selectedDevice.decoupled == 'true'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">Yes</span></p>
                    <p ng-if="selectedDevice.decoupled == 'false'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">No</span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ServerController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
