<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/sync/policies')?>"><?=$data['crumb1']?></a></li>
                <li><span><?=$data['crumb2']?></span></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncPmsController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('create_new_policy', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="hide currentPage"><?='createPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreate()',
                        'data-parsley-validate' => true
                    ));
                    ?>
                    <div>
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group hide">
                                    <div class="checkbox check-primary">
                                        <input id="legalHold" name="legalHold" type="checkbox" value="enabled">
                                        <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>
                                        <span class="systemFolders" style="display: none;">
                                            <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled">
                                            <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                        </span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                    <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs" role="tablist">
                            <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                            <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                        </ul>

                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div role="tabpanel" class="tab-pane active" id="general">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <br/>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('sync_information', 'keywords')?></legend>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group syncEnableAutomatic">
                                            <label for="syncEnableAutomatic"><?=Language::show('syncEnableAutomatic', 'keywords');?></label>
                                            <select class="form-control syncEnableAutomatic" name="syncEnableAutomatic" id="syncEnableAutomatic" required="" title='Select <?=Language::show('syncEnableAutomatic', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="syncInterval"><?=Language::show('syncInterval', 'keywords');?> (In Minutes)</label>
                                            <input type="text" class="form-control" name="syncInterval" id="syncInterval" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('syncInterval', 'keywords');?>" required autocomplete="off" value="5" data-parsley-type="integer" data-parsley-min="5" data-parsley-max="60" />
                                        </div>
                                        <div class="form-group contentIndexEnabled hide">
                                            <label for="contentIndexEnabled"><?=Language::show('contentIndexEnabled', 'keywords');?></label>
                                            <select class="form-control contentIndexEnabled" name="contentIndexEnabled" id="contentIndexEnabled" required="" title='Select <?=Language::show('contentIndexEnabled', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group deDuplicationEnabled hide">
                                            <label for="deDuplicationEnabled"><?=Language::show('deDuplicationEnabled', 'keywords');?></label>
                                            <select class="form-control deDuplicationEnabled" name="deDuplicationEnabled" id="deDuplicationEnabled" required="" title='Select <?=Language::show('deDuplicationEnabled', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="3" data-parsley-type="integer" data-parsley-min="1" />
                                        </div>
                                        <div class="form-group">
                                            <label for="maxFileSize"><?=Language::show('maxFileSize', 'keywords');?> (In MB)</label>
                                            <input type="text" class="form-control" name="maxFileSize" id="maxFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxFileSize', 'keywords');?>" required autocomplete="off" value="1024" data-parsley-type="integer"  data-parsley-min="1" />
                                        </div>
                                        <div class="form-group">
                                            <label for="userSizeAllowed"><?=Language::show('User Storage Quota', 'keywords');?> (In GB)</label>
                                            <input type="text" class="form-control" name="userSizeAllowed" id="userSizeAllowed" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userSizeAllowed', 'keywords');?>" required autocomplete="off" value="10" data-parsley-type="integer" data-parsley-min="1" />
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                            <select class="form-control shareEnabled" name="shareEnabled" id="shareEnabled" required="" title='Select <?=Language::show('share', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group highSecureShareEnabled">
                                            <label for="highSecureShareEnabled"><?=Language::show('highSecureShareEnabled', 'keywords');?></label>
                                            <select class="form-control highSecureShareEnabled" name="highSecureShareEnabled" id="highSecureShareEnabled" required="" title='Select <?=Language::show('highSecureShareEnabled', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-1 subimage" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                            <div class="col-lg-11">
                                                <div class="form-group complexPasswordRequired">
                                                    <label for="complexPasswordRequired"><?=Language::show('complexPasswordRequired', 'keywords');?></label>
                                                    <select class="form-control complexPasswordRequired" name="complexPasswordRequired" id="complexPasswordRequired" required="" title='Select <?=Language::show('complexPasswordRequired', 'keywords')?>'>
                                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                        <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-1 subimage" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                            <div class="col-lg-11">
                                                <div class="form-group preventDownloadEnabled">
                                                    <label for="preventDownloadEnabled"><?=Language::show('preventDownloadEnabled', 'keywords');?></label>
                                                    <select class="form-control preventDownloadEnabled" name="preventDownloadEnabled" id="preventDownloadEnabled" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                        <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-1 subimage" style="margin-top: 35px;text-align: center;"><i class="fa fa-caret-square-o-right"></i></div>
                                            <div class="col-lg-11">
                                                <div class="form-group expiredDate">
                                                    <label for="expiredDate"><?=Language::show('expiredDate', 'keywords');?></label>
                                                    <select class="form-control expiredDate" name="expiredDate" id="expiredDate" required="" title='Select <?=Language::show('expiredDate', 'keywords')?>'>
                                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                        <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                        <div class="form-group">
                                            <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                            <select class="form-control selectOsTypePicker" name="osType" id="osType" required="" title='Select OS Type'>
                                                <option value="windows">Windows</option>
                                                <option value="mac">Mac</option>
                                            </select>
                                        </div>
                                        <div class="form-group hide">
                                            <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                            <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="128" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                        </div>
                                        <div class="form-group hide">
                                            <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                            <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="80" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                        </div>
                                        <div class="form-group hide">
                                            <label for="cacheUsedData"><?=Language::show('cacheUsedData', 'keywords');?></label>
                                            <select class="form-control cacheUsedData" name="cacheUsedData" id="cacheUsedData" required="" title='Select <?=Language::show('cacheUsedData', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble" ng-click="addNewFilter()">Create New Filter</a></label>
                                            <select class="form-control selectFilterPicker" ng-model="filter" name="filters" id="filters" required title='Select Filters'>
                                                <?php if(!empty($data['filters'])){ ?>
                                                    <?php foreach($data['filters'] as $key => $value){ ?>
                                                        <option value="<?=$value['filterName']?>"><?=$value['filterName']?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-5">
                                        <div class="row allFilters" ng-if="defaultFilter != undefined">
                                            <div class="col-lg-12">
                                                <div class="panel panel-default">
                                                    <div class="panel-heading">
                                                        <h5> <i class="fa fa-filter"></i> Filters</h5>
                                                    </div>
                                                    <div class="panel-body">
                                                        <?=Language::show('filterName', 'keywords');?>: {{ defaultFilter.filterName }}
                                                        <br/>
                                                        <?=Language::show('Filter Type', 'keywords');?>: {{ defaultFilter.filterType }}
                                                        <br/>
                                                        <?=Language::show('filters', 'keywords');?>: <b style="word-wrap: break-word">{{ defaultFilter.filters }}</b>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div role="tabpanel" class="tab-pane" id="advanced">

                                <div class="row">
                                    <div class="col-lg-12">
                                        <br/>
                                        <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group">
                                            <label for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                            <select class="form-control incrementalFileTransfer" name="incrementalFileTransfer" id="incrementalFileTransfer" required="" title='Select <?=Language::show('incrementalFileTransfer', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                            <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="5" data-parsley-type="integer" data-parsley-min="1" />
                                        </div>
                                        <div class="form-group">
                                            <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                            <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                        </div>
                                        <div class="form-group">
                                            <label for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                        </div>
                                        <div class="form-group hide">
                                            <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                            <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                        </div>
                                        <?php if(STORAGE_TYPE == "GOOGLE_DRIVE" || STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                            <div class="form-group">
                                                <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                                <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                    <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                    <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                                </select>
                                            </div>
                                        <?php } else { ?>
                                            <div class="form-group">
                                                <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                                <select class="form-control dedup" name="dedup" id="dedup" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                    <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                    <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                    <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                                </select>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="form-group hide">
                                            <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                            <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group hide">
                                            <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                            <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                                <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                            <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" value="2">
                                        </div>
                                        <div class="form-group">
                                            <label for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                            <select class="form-control compEnabled" name="compEnabled" id="compEnabled" required="" title='Select <?=Language::show('compEnabled', 'keywords')?>'>
                                                <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                                <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                            </select>
                                        </div>
                                        <div class="form-group">

                                            <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>

                                            <?php if(!empty($data['pgs'])){ ?>
                                                <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                    <?php foreach($data['pgs'] as $key => $value){ ?>
                                                        <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                    <?php } ?>
                                                </select>
                                            <?php } ?>


                                        </div>
                                        <div class="form-group searchAlgoForPg">
                                            <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                            <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                                <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                                <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div><br/>
                    <div class="row">
                        <div class="col-lg-6">
                            <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createSchedule">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit Schedule</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                        <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                        <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                    </div>
                    <div class="form-group">
                        <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime">
                    </div>
                    <div class="form-group">
                        <label for="days"><?=Language::show('days', 'keywords');?></label>
                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                        <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                            <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                            <option value="2"><?=Language::show('monday', 'keywords')?></option>
                            <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                            <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                            <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                            <option value="6"><?=Language::show('friday', 'keywords')?></option>
                            <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createCcS">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?= Form::open(array(
                    'ng-submit' => 'saveCloudCredentials(true)',
                    'class' => 'cloudCredentials',
                    'csrf' => $data['csrf_token'],
                    'autocomplete' => 'off',
                    'data-parsley-validate' => true
                )); ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create a new CcS</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="form-group col-lg-12">
                            <label for="cloudType">Cloud Type</label>
                            <select class="form-control" name="cloudType" id="cloudType">
                                <option value="azureBlob">Azure Blob</option>
                                <option value="ibmCloud">IBM Cloud</option>
                                <option value="amazon">Amazon s3 Services</option>
                            </select>
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="identity">Identity</label>
                            <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="Enter your cloud identity" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-6">
                            <label for="accessKey">Access key</label>
                            <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="Enter your access key" required autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 epaUrl" style="display: none;">
                            <label for="epaUrl">End Point Url</label>
                            <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="Enter your End Point Agent URL" autocomplete="off">
                        </div>
                        <div class="form-group col-lg-12 containerName" style="display: none;">
                            <label for="containerName">Amazon Container Name</label>
                            <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="Enter your Amazon Container Name" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createFilter">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Edit Filter</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label><br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.dedup').selectpicker('render');
    $('.filterType').selectpicker('render');
    $('.syncEnableAutomatic').selectpicker('render');
    $('.shareEnabled').selectpicker('render').on('change', function(){
        if($('#shareEnabled').val() == 'true'){
            $('.complexPasswordRequired').show();
            $('.highSecureShareEnabled').show();
            $('.preventDownloadEnabled').show();
            $('.expiredDate').show();
			$('.subimage').show();
        }else{
            $('.complexPasswordRequired').hide();
            $('.highSecureShareEnabled').hide();
            $('.preventDownloadEnabled').hide();
            $('.expiredDate').hide();
			$('.subimage').hide();
        }
    });
    $('#sortAlgoForPg').on('change', function(){
        var option = $('#sortAlgoForPg').val();
        if(option == 'PRIORITY'){
            $('#Blukryptipaddress').attr('required', 'required');
        }else{
            $('#Blukryptipaddress').removeAttr('required', 'required');
        }
    });
    $('.highSecureShareEnabled').selectpicker('render').on('change', function(){
        if($('#highSecureShareEnabled').val() == 'true'){
            $('.complexPasswordRequired').attr("disabled", true);
            $('.preventDownloadEnabled').attr("disabled", true);
            $('.expiredDate').attr("disabled", true);

            $('.expiredDate').find('option[value="true"]').prop("selected",true);
            $('.complexPasswordRequired').find('option[value="true"]').prop("selected",true);
            $('.preventDownloadEnabled').find('option[value="false"]').prop("selected",true);

            $('.complexPasswordRequired').selectpicker('refresh');
            $('.preventDownloadEnabled').selectpicker('refresh');
            $('.expiredDate').selectpicker('refresh');
        }else{
            $('.complexPasswordRequired').attr("disabled", false);
            $('.preventDownloadEnabled').attr("disabled", false);
            $('.expiredDate').attr("disabled", false);

            $('.expiredDate').find('option[value="false"]').prop("selected",true);
            $('.complexPasswordRequired').find('option[value="false"]').prop("selected",true);
            $('.preventDownloadEnabled').find('option[value="true"]').prop("selected",true);

            $('.complexPasswordRequired').selectpicker('refresh');
            $('.preventDownloadEnabled').selectpicker('refresh');
            $('.expiredDate').selectpicker('refresh');
        }
    });

    $('.complexPasswordRequired').selectpicker('render').on('change', function(){
        if($('#complexPasswordRequired').val() == "true" && $('#preventDownloadEnabled').val() == "true" && $('#expiredDate').val() == "true"){
            $('#highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }else{
            $('#highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }
    });

    $('.preventDownloadEnabled').selectpicker('render').on('change', function(){
        if($('#complexPasswordRequired').val() == "true" && $('#preventDownloadEnabled').val() == "true" && $('#expiredDate').val() == "true"){
            $('#highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }else{
            $('#highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }
    });
    $('.expiredDate').selectpicker('render').on('change', function(){
        if($('#complexPasswordRequired').val() == "true" && $('#preventDownloadEnabled').val() == "true" && $('#expiredDate').val() == "true"){
            $('#highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }else{
            $('#highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }
    });

    $('.contentIndexEnabled').selectpicker('render');
    $('.deDuplicationEnabled').selectpicker('render');
    $('.cacheUsedData').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.selectCcSPicker').selectpicker('render');


    $('.compEnabled').selectpicker('render');
    $('.selectSchedulePicker').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $('.incrementalFileTransfer').selectpicker('render')
        .on("change", function(event){
            if($('.incrementalFileTransfer').val() == 'false'){
                $('#partialFileSize').attr('disabled', 'disabled')
                $('#fileChunkableSize').attr('disabled', 'disabled')
            }else{
                $('#partialFileSize').removeAttr('disabled', 'disabled')
                $('#fileChunkableSize').removeAttr('disabled', 'disabled')
            }
        });
    $('.networkThrottling').selectpicker('render');
    $('.selectFilterPicker').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncPmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker();
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.containerName').show();
            $('[name="containerName"').attr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.epaUrl').show();
            $('[name="epaUrl"').attr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }else{
            $('.epaUrl').hide();
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
        }
    });
</script>
<script type="text/javascript">
    $(".blukryptIPAdress").select2();

    $(".blukryptIPAdress").on("select2:select", function (evt) {
        var element = evt.params.data.element;
        var $element = $(element);

        $element.detach();
        $(this).append($element);
        $(this).trigger("change");
       // $('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
    });
</script>
