<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('pms/filters')?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                </ol>
            </div>
            <div class="col-lg-6">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('create_new_filter', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                        <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'filterForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'filterCreate(false)',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="form-group">
                            <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                            <input type="text" class="form-control" name="filterName" id="filterName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group">
                            <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                            <select class="form-control filterType" name="filterType" id="filterType" required>
                                <option value="inclusion">Inclusion Filter</option>
                                <option value="exclusion">Exclusion Filter</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="filters"><?=Language::show('filters', 'keywords');?></label><br/>
                            <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control" name="filters[]" id="filters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                        </div>
                        <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        <?=
                            Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.filterType').selectpicker('render');
</script>