<?php
use \Core\View;
use Helpers\Auth;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>

<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="HistoryController">
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide currentPage"><?='backupActivityHistory'?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('activity_history', 'keywords')?>
                        <?php if(Auth::checkUserPermission('admin')){ ?>
                            <a class="btn btn-default btn-small pull-right" data-toggle="modal" data-target="#assignUsers">Export Activity History To Excel</a>
                        <?php } ?>
                    </h4>
                </div>
                <div class="panel-body" style="padding: 0px 10px 10px 10px;">
                    <div class="table-responsive" style="padding: 20px 10px 20px 40px;">
                        <div class="h4 loading text-center">Loading.....</div>
                        <ul class="mini-timeline">
                            <li ng-repeat="value in audits track by $index" class="mini-timeline-{{value.color}}">
                                <div class="timeline-icon"></div>
                                <div class="timeline-body">
                                    <div class="timeline-content">
                                        <a href="javascript:;" ng-click="updateBackupActivityDetails(100, value.actionByUser, '', 0)" class="name" ng-cloak>{{ value.actionByUser }}</a> {{ value.action }} <span class="text-primary" ng-cloak>{{ value.actionOnObject }}</span> <span ng-if="value.actionUsingObject.length > 0"> <a ng-if="value.additionalInfo.length > 1" class="name" href="javascript:;" ng-cloak>{{ value.additionalInfo }}</a> using <a ng-click="updateBackupActivityDetails(100, '', value.actionUsingObject, 0)" class="name" href="javascript:;" ng-cloak>{{ value.actionUsingObject }}</a></span>
                                        <span class="time" ng-cloak>{{ value.time }}</span>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
    <div class="modal fade" id="assignUsers" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog">
            <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'selectUsersForActivityHistory',
                    'autocomplete' => 'off',
                    'ng-submit' => 'exportActivityHistory()',
                    'data-parsley-validate' => true
                ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Select Users and date range to Export</h4>
                </div>
                <div class="modal-body">
                    <div class="col-lg-6">
                        <div class="checkbox check-primary">
                            <input id="allAdmins" name="allAdmins" type="checkbox" value="admins">
                            <label for="allAdmins"><?=Language::show('Get History for all admins', 'keywords');?></label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="assignUsers" name="userNames" style="width: 100%;" id="selectAssignUsers" multiple="multiple"></select>
                    </div>
                    <div class="input-group input-daterange">
                        <input type="text" id="from" name="from" class="form-control" value="{{ search.from }}">
                        <span class="input-group-addon">to</span>
                        <input type="text" id="to" name="to" class="form-control" value="{{ search.to }}">
                    </div>
                    <br/>
                    <p style="text-align: right">Note:- Duration should not exceed 15 days</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary exportExcelGenerate">Export to Excel</button>
                </div>
            </div>
            <?=
                Form::close();
            ?>
        </div>
    </div>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/HistoryController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>

    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-3m',
        endDate: '-1d',
        todayHighlight: true
    });

    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+0d',
        todayHighlight: true
    });

    $("#allAdmins").on('change', function(){
        if($("#allAdmins").prop('checked')){
            $(".assignUsers").attr('disabled', 'disabled');
        }else{
            $(".assignUsers").removeAttr('disabled', 'disabled');
        }
    });

    $(".assignUsers").select2({
        maximumSelectionLength: 1,
        ajax: {
            url: "<?=DIR?>"+"user/searchUserName",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.changeOwnerSaveBtn').removeAttr('disabled', 'disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select a User'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }

    $('#assignUsers').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });

</script>