<?php
    use Helpers\Url;
    use Helpers\Auth;
?>
<nav class="navbar navbar-blue navbar-fixed-top">
    <div class="container">
        <div class="navbar-header">
            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar" aria-expanded="false" aria-controls="navbar">
                <span class="sr-only">Toggle navigation</span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </button>
            <a class="navbar-brand" href="<?=URL::basePath()?>"><?=HEADER_NAME?></a>
        </div>
        <div id="navbar" class="collapse navbar-collapse">
            <ul class="nav navbar-nav pull-right">
                <li class="dropdown top-drop">
                    <a class="dropdown-toggle" data-toggle="dropdown" data-placement="left" title="settings" href="javascript:;"><i class="fa fa-cogs"></i> <b class="caret"></b></a>
                    <ul class="dropdown-menu">
                        <li><a href="<?=Url::basePath('myAccount')?>">My Account</a></li>
                        <li><a href="<?=Url::basePath('activityHistory')?>">Activity History</a></li>
                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                            <li><a href="<?=Url::basePath('share/activityHistory')?>">Share Activity History</a></li>
                            <li><a href="<?=Url::basePath('trash')?>">Trash</a></li>
                        <?php } ?>
                        <?php if(Auth::checkUserPermission('admin')){ ?>
                            <?php if(Auth::checkCloudPermission('sync')){ ?>
                                <li class="hide"><a href="<?=Url::basePath('cloudInfo')?>">Cloud Information</a></li>
                            <?php } ?>
                        <?php } ?>
                        <li class="divider"></li>
                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                            <li><a href="<?=Url::basePath('miniClouds')?>">MiniClouds</a></li>
                        <?php } ?>
                        <li><a href="<?=Url::basePath('download');?>">Download Agent</a></li>
                        <?php if(REQUEST_SUPPORT_PAGE == true){ ?>
                            <li><a href="javascript:;">Request Support</a></li>
                        <?php } ?>
                        <?php if(HELP_PAGE == true){ ?>
                            <li><a href="javascript:;">Help</a></li>
                        <?php } ?>
                    </ul>
                </li>
                <?php if(Auth::checkCloudPermission('sync') || Auth::checkCloudPermission('backup')){ ?>
                <li><a href="<?=Url::basePath('share/myShares')?>" class="toolTip" data-toggle="tooltip" data-placement="bottom" title="My Shares"><i class="fa fa-share-alt"></i></a></li>
                    <?php if(SHARE_WITHIN_ORG == true){ ?>
                        <li><a href="<?=Url::basePath('share/filesSharedWithMe')?>" class="toolTip" data-toggle="tooltip" data-placement="bottom" title="Files Shared With Me"><i class="fa fa-user"></i><i style="font-size: 80%;"  class="fa fa-share-alt"></i></a></li>
                    <?php } ?>
                <?php } ?>
                <li><a class="toolTip" data-toggle="tooltip" data-placement="right" title="logout" href="<?=URL::basePath('logout')?>"><i class="fa fa-sign-out"></i></a></li>
            </ul>
        </div><!--/.nav-collapse -->
    </div>
</nav>