<?php
namespace Models;

use Core\Model;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Sync extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Sync Model was called', 'info');
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFiles($headers){
        $url = $this->api->getUrl('syncFiles');
        $this->log('Url: '.$url, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $this->log('Headers: '. json_encode($headers), 'info');
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $miniCloudName
     * @return array
     */
    public function createMiniCloud($headers, $miniCloudName){
        $url = $this->api->getUrl('createMiniCloud');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $miniCloudName);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Creates a folder
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function cancelUpload($headers){
        $url = $this->api->getUrl('cancelUpload');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Creates a folder
     *
     * Token should be sent in header
     * @param $headers
     * @param $folderName
     * @return array
     */
    public function createFolder($headers, $folderName){
        $url = $this->api->getUrl('createFolder');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $folderName);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $username
     * @return array
     */
    public function getUserData($headers, $username){
        $url = $this->api->getUrl('userDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url.DS.$username.DS);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $content
     * @return array
     */
    public function upload($headers, $content){
        $url = $this->api->getUrl('upload');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $content);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 448) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function download($headers)
    {
        $pms = new Pms();
        $blukrypts = $pms->getAllBlukrypts(array('Content-Type' => 'application/json', 'token' => $_SESSION['token']));
        if(!empty($headers['blukryptIp'])){
            $blukryptIP = $headers['blukryptIp'];
        }else if(!empty($blukrypts['body']->{'privacyGatewayElementList'})){
            $blukryptIP = $blukrypts['body']->{'privacyGatewayElementList'}[0]->{"gatewayName"};
        }else{
            $blukryptIP = BLUKRYPT_IP;
        }
        $url = PROTOCOL.$blukryptIP.BLUKRPT_URL_WITHOUT_IP.$_SESSION['cloudName'].DS.'sync'.DS.'portal'.DS.'view'.DS.'file'.DS;
        $this->log("url: ".$url, "info");
        $this->log("url: ".$this->api->getUrl("download"), "info");
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileInfo($headers){
        $url = $this->api->getUrl('fileInfo');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFileVersions($headers){
        $url = $this->api->getUrl('syncFileVersions');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveFileRevisionComments($headers){
        $url = $this->api->getUrl('saveFileRevisionComments');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function saveRename($headers){
        $url = $this->api->getUrl('syncFileRename');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function deleteFilesFolders($headers){
        $url = $this->api->getUrl('deleteFilesFolders');
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function deleteMiniCloud($headers, $xml){
        $url = $this->api->getUrl('deleteMiniCloud');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFile($headers, $elements){
        $url = $this->api->getUrl('syncFileShare');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function shareFileWith($headers, $elements){
        $url = $this->api->getUrl('syncFileShareWith');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $elements
     * @return array
     */
    public function updateSharePolicy($headers, $elements){
        $url = $this->api->getUrl('updateSharePolicy');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $elements);
        $result = array(
            'status' => ($this->curl->http_status_code == 201 || $this->curl->http_status_code == 302) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $fileName
     * @return array
     */
    public function checkForMiniCloud($headers, $fileName){
        $url = $this->api->getUrl('checkForMiniCloud', array('fileName', $fileName));
        $this->log('URL: '.$url, 'info');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function isSharedOrNot($headers){
        $url = $this->api->getUrl('isSharedOrNot');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $xml
     * @return array
     */
    public function unShare($headers, $xml){
        $url = $this->api->getUrl('unShare');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $xml);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @param $selectedFiles
     * @param $action
     * @return array
     */
    public function cutCopy($headers, $selectedFiles, $action){
        $url = $this->api->getUrl('cutCopy');
        $this->curl->setHeaders($headers);
        $this->curl->post($url.'/'.$action, $selectedFiles);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSharedFiles($headers){
        $url = $this->api->getUrl('sharedFiles');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getFilesSharedWithMe($headers){
        $url = $this->api->getUrl('filesSharedWithMe');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function getDeletedFiles($headers){
        $url = $this->api->getUrl('deletedFiles');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function purgeFile($headers){
        $url = $this->api->getUrl('purgeFile');
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            '$url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function purgeAll($headers){
        $url = $this->api->getUrl('purgeAll');
        $this->curl->setHeaders($headers);
        $this->curl->delete($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            '$url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function restoreFile($headers){
        $url = $this->api->getUrl('restoreFile');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            '$url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function restoreAll($headers){
        $url = $this->api->getUrl('restoreAll');
        $this->log('Url: '. $url);
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Sends an email
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function sendShareEmail($headers){
        $url = $this->api->getUrl('sendEmail');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Sends an auditHistory
     *
     * Token should be sent in header
     * @param $headers
     * @return array
     */
    public function auditHistory($headers){
        $url = $this->api->getUrl('auditHistory');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @param $searchType
     * @return array
     */
    public function getSearchResults($headers, $searchType){
        $url = $this->api->getUrl($searchType);
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getAllMiniClouds($headers){
        $url = $this->api->getUrl('miniCloud');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function changeOwner($headers){
        $url = $this->api->getUrl('changeOwner');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'url' => $url,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getSyncRevisionId($headers){
        $url = $this->api->getUrl('syncRevisionId');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'url' => $url,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method Blocks the user Profile
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function assignUsers($headers){
        $url = $this->api->getUrl('assignUsers');
        $this->curl->setHeaders($headers);
        $this->curl->post($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below Method gets all filters
     *
     * token should be sent in header
     * @param $headers
     * @return array
     */
    public function getUserSyncPolicy($headers){
        $url = $this->api->getUrl('getUserSyncPolicy');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'url' => $url,
            'header' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }
}