<?php
namespace Core;

use Helpers\Session;

/**
 * Configurations for Portal Goes Down Here
 * Do not Mess this up until you know what you are doing
 * I mean it
 */
class Config
{
    public function __construct()
    {
        /**
         * Start of Application Supporting constants
         */

        ob_start();
        define('DS', DIRECTORY_SEPARATOR);

        define('PARACLOUD_IP', 'blucloudv22.parablu.com');
        define('BLUKRYPT_IP', 'blucloudv22.parablu.com');

        $protocol = empty($_SERVER['HTTPS']) ? 'http'.':'.DS.DS : 'https'.':'.DS.DS;
        $paraCloudUrl = (ENVIRONMENT == 'development') ? $protocol.PARACLOUD_IP.DS : $protocol.$_SERVER['SERVER_NAME'].DS;
        $bluKryptUrl = $protocol.BLUKRYPT_IP.DS;
        $curlSSLEnabled = empty($_SERVER['HTTPS']) ? false : true;

        define('DIRECTORY_PATH', dirname(dirname(__FILE__))); //site address
        define('PARAVIEW_TMP_PATH', DIRECTORY_PATH.'/templates/default/documents/'); //site address
        define('BASE_FOLDER', 'portal'); //site address
        define('DIR', $protocol.$_SERVER['SERVER_NAME'].DS.BASE_FOLDER.DS); //site address
        define('DEFAULT_CONTROLLER', 'welcome'); //Used to load a default controller
        define('DEFAULT_METHOD', 'subPage'); //Used to call a default method
        define('TEMPLATE', 'default'); //set the default template
        define('LANGUAGE_CODE', 'en'); //set a default language
        define('SITETITLE', 'Portal - Parablu Inc.'); //option all create a constant for the name of the site
        define('SITEEMAIL', 'support@parablu.com'); //option all set a site email address
        set_exception_handler('Core\Logger::ExceptionHandler'); //Exception handling class
        set_error_handler('Core\Logger::ErrorHandler'); //Error handling class
        date_default_timezone_set('Asia/Kolkata'); //set timezone
        define('MEMCACHE_HOST', 'localhost'); //Memcached Host Name
        define('MEMCACHE_PORT', '13582'); //Memcached Host Port

        /**
         * End of Application Supporting constants
         */

include_once('GoogleConfig.php');

        /**
         * User Defined constants
         */

        define('PROTOCOL', $protocol);
        define('BLUKRPT_URL_WITHOUT_IP', DS.'BluKryptBuilder'.DS.'cloud'.DS);
        define('SHARE_PATH', DIR.'share'.DS);
        define('CLOUD_CREATE_URL', $paraCloudUrl.'CloudAPI/');
        define('PARACLOUD_DNS_URL', 'https://dns.parablu.com/DnsAPI/');
        define('PARA_URL', $paraCloudUrl.'paracloud'.DS);
        define('PARACLOUD_URL', $paraCloudUrl.'paracloud'.DS.'cloud'.DS);
        define('BLUKRYPT_URL', $bluKryptUrl.'BluKryptBuilder'.DS.'cloud'.DS);
        define('SUPPORT_URL', $paraCloudUrl.'support'.DS);
        define('API_APP_URL', 'http://api-app.parablu.com/call.php');
        define('BASE_PARACLOUD_PATH','/mnt/');
        define('SUPPORT_BASE_DIR','support/bslogs/');
        define('CLOUD_NAME', 'testv22');

        define('CURL_SSL_ENABLED', false);
        define('LDAP_ENABLED', false);
        define('APP_SECRET_KEY', 'thisismykeynooneshouldusethis');
        define('PATH_CLIENT_DOWNLOAD','/var/lib/parablusys/clients');
        define('WINDOWS_CLIENT_FILENAME','Parablu_EPA.exe');
        define('MAC_CLIENT_FILENAME','Parablu_EPA.dmg');
        define('CURL_TIME_LIMIT', 360);
        define('OVERVIEW_REPORT_PATH', '/mnt/bkpOverview/');
        define('OVERVIEW_REPORT_NAME', 'Backup_OverviewStatus.xlsx');
        define('SYNC_OVERVIEW_REPORT_NAME', 'Sync_User_OverviewStatus.xlsx');
        define('OVERVIEW_REPORT_NAME_SYNC', 'Sync_OverviewStatus.xlsx');
        define('OVERVIEW_DAILY_USERBACKUP_OVERVIEW', 'Daily_User_Backup_OverviewStatus.xls');
        define('LOCAL_ODB_REDIRECT_URI','https://api-app.parablu.com/');

        define('COMPLEX_PASSWORD', false);
        define('HELP_PAGE', false);
        define('REQUEST_SUPPORT_PAGE', false);
        define('EMAIL_ONLY_ADMIN', false);
        define('CLOUD_SETTINGS', true);
        define('BLUKRYPT_PAGE', true);
        define('AMAZON_CHECK', true);
        define('SHARE_LOGIN_CHECK', false);
        define('SHARE_WITHIN_ORG', false);

        /**
         * enter comma separated values like this 'msi, exe'
         */
        define('FILE_INCLUDE_EXTENSIONS', '');
        define('FILE_EXCLUDE_EXTENSIONS', '');

        /**
         * Any(For rest of the cloud Storage) = ANY
         * Azure Blob = AZURE
         * One Drive = ONE_DRIVE
         */
        define('STORAGE_TYPE', 'ONE_DRIVE');

        define('ANDROID_APP', false);
        define('WINDOWS_APP', false);
        define('IOS_APP', false);
        define('RESTORE_FROM_PORTAL', false);

        define('MAC_APP', true);
        define('WINDOWSPC_APP', true);
        define('PROXY_URL', '');
        define('PROXY_USERNAME', '');
        define('PROXY_PASSWORD', '');

        define('ENABLE_EPA', true);
        define('WINDOWS_EPA', true);
        define('MAC_EPA', true);
        define('ENABLE_MOBILE_APPS', false);
        define('ENABLE_ANDROID_APP', true);
        define('ENABLE_WINDOWS_PHONE_APP', true);
        define('ENABLE_IOS_APP', true);
        define('VERSIONS_NUMBER', 'v2.0');

        /**
         * END User Defined constants
         */

        /**
         * Client Specific changes
         */

        define('CONTAINER_TYPES', 'Mongodb, Sql, MsSql, Oracle, Flat Files');
        /**
         * Please use only the below mentioned keywords
         * Mongodb, Sql, MsSql, Flat Files for the above parameters
         */

        define('LOGIN_REDIRECT_FILES_PAGE', false);
        define('USER_ID', false);
        define('D_CLOUD_NAME', true);
        define('D_PROFILE_PIC', true);
        define('SHARE_DEFAULT_7_DAYS', false);
        define('CUSTOM_SYNC_NAME', '');
        define('WORKFLOW_IMAGE', false);
        define('SHARE_GET_EMAIL', false);
        define('COPYRIGHT_NAME', 'Parablu Inc');
        define('DISCLAIMER', false);
        define('PARABLU_LOGO', true);
        define('NEIL_IMG_NAME', 'logo_new.png');
        define('HEADER_NAME', 'Parablu');
        define('SYNC_SEARCH_MESSAGE', 'Type anywhere to search for Files, Users, Devices');
        define('BACKUP_SEARCH_MESSAGE', 'Type anywhere to search for Users, Devices');
        define('DISABLE_CUT_COPY', false);
        define('DISABLE_SHOW_PG_ICON', true);
        define('CUSTOM_UPLOAD_MESSAGE', ''); //Use "|" symbol to put multiple messages

        /**
         * End of client Specific changes
         */

        include_once('/var/lib/parablusys/conf/mail.config.php');
//        include_once('/var/lib/parablusys/conf/odb.config.php');
        include_once('/var/lib/parablusys/conf/google.config.php');
        include_once('/var/lib/parablusys/conf/odc.config.php');


        /* start sessions */
        $session = new Session();
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }

        $session->put('language', LANGUAGE_CODE);

    }
}
