<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Migration;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class MigrationController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->auth->tokenCheck();
        $this->language->load('migration');
        $this->_model = new Migration();
        $this->verifyAndCleanItUp();
        Auth::allowOnly('admin');
    }

    /**
     * Define Index page title and load template files
     */
    public function migration()
    {
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'migration',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('migration/migration', $data);
        View::renderTemplate('footer', $data);
    }

    public function getMigrationDetails(){

        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json'
            );

            $result = $this->_model->getMigrationDetails($headers);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'details' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    /**
     * Define Index page title and load template files
     */
    public function importUsers(){
        $result = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));
        $policies = [];
        if(!empty((array)$result['body']->{'backupPolicyElementList'})){
            foreach((array)$result['body']->{'backupPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $policies = array_merge(array($policy), $policies);
            }
        }

        $syncResult = $this->_model->getAllSyncPolicies(array('token'=>$this->session->get('token')));
        $syncPolicies = [];

        if(!empty((array)$syncResult['body']->{'syncPolicyElementList'})){
            foreach((array)$syncResult['body']->{'syncPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $syncPolicies = array_merge(array($policy), $syncPolicies);
            }
        }
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('importUsers'),
            'active' => 'migration',
            'policies' => $policies,
            'syncPolicies' => $syncPolicies,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('migration/importUsers', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUsers(){
        if(!empty($_POST['userList'])){

            $headers = array(
                'Content-Type' => 'application/json'
            );

            $result = $this->_model->getUsersForMigration($headers, json_encode(array('ldapUserNames' => $_POST['userList'])));
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $users = [];
                    if(!empty($result['body']->{'ldapUserElementList'})){
                        foreach($result['body']->{'ldapUserElementList'} as $value){
                            $user = array(
                                'userName' => $value->{'userName'},
                                'emailId' => $value->{'emailId'},
                                'organizationUnit' => $value->{'organizationUnit'},
                                'defaultPolicy' => !empty($_POST['policyName']) ? $_POST['policyName'] : 'NA',
                                'defaultSyncPolicy' => !empty($_POST['syncPolicy']) ? $_POST['syncPolicy'] : 'NA',
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'groupName' => $result['header']->{'container'},
                        'policy' => $_POST['policyName'],
                        'syncPolicy' => $_POST['syncPolicy'],
                        'userList' => $users
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    public function migrateUsers(){
        if(!empty($_POST['userList'])){

            $headers = array(
                'Content-Type' => 'application/json',
                'groupName' => $_POST['groupName'],
                'adminName' => $this->session->get('userName')
            );
            if($_POST['migrationType'] == 'sync' || $_POST['migrationType'] == 'both'){
                $headers['syncEnabled'] = 'true';
            }else{
                $headers['syncEnabled'] = 'false';
            }
            if($_POST['migrationType'] == 'backup' || $_POST['migrationType'] == 'both'){
                $headers['backupEnabled'] = 'true';
            }else{
                $headers['backupEnabled'] = 'false';
            }

            $result = $this->_model->migrateUsers($headers, json_encode(array('ldapUserElements' => $_POST['userList'])));

            switch (200) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('migratedUsers')
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
}
