/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class FloatingIP
implements Comparable<FloatingIP> {
    private final String id;
    private final String ip;
    @Named(value="fixed_ip")
    private final String fixedIp;
    @Named(value="instance_id")
    private final String instanceId;
    private final String pool;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromFloatingIP(this);
    }

    @ConstructorProperties(value={"id", "ip", "fixed_ip", "instance_id", "pool"})
    protected FloatingIP(String id, String ip, @Nullable String fixedIp, @Nullable String instanceId, @Nullable String pool) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.ip = (String)Preconditions.checkNotNull((Object)ip, (Object)"ip");
        this.fixedIp = fixedIp;
        this.instanceId = instanceId;
        this.pool = pool;
    }

    public String getId() {
        return this.id;
    }

    public String getIp() {
        return this.ip;
    }

    @Nullable
    public String getFixedIp() {
        return this.fixedIp;
    }

    @Nullable
    public String getInstanceId() {
        return this.instanceId;
    }

    @Nullable
    public String getPool() {
        return this.pool;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.ip, this.fixedIp, this.instanceId, this.pool});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FloatingIP that = (FloatingIP)FloatingIP.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.ip, (Object)that.ip) && Objects.equal((Object)this.fixedIp, (Object)that.fixedIp) && Objects.equal((Object)this.instanceId, (Object)that.instanceId) && Objects.equal((Object)this.pool, (Object)that.pool);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("ip", (Object)this.ip).add("fixedIp", (Object)this.fixedIp).add("instanceId", (Object)this.instanceId).add("pool", (Object)this.pool);
    }

    public String toString() {
        return this.string().toString();
    }

    @Override
    public int compareTo(FloatingIP o) {
        return this.id.compareTo(o.getId());
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String ip;
        protected String fixedIp;
        protected String instanceId;
        protected String pool;

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T ip(String ip) {
            this.ip = ip;
            return this.self();
        }

        public T fixedIp(String fixedIp) {
            this.fixedIp = fixedIp;
            return this.self();
        }

        public T instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this.self();
        }

        public T pool(String pool) {
            this.pool = pool;
            return this.self();
        }

        public FloatingIP build() {
            return new FloatingIP(this.id, this.ip, this.fixedIp, this.instanceId, this.pool);
        }

        public T fromFloatingIP(FloatingIP in) {
            return ((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).ip(in.getIp())).fixedIp(in.getFixedIp())).instanceId(in.getInstanceId())).pool(in.getPool());
        }
    }
}

