/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.chef.config.Validator;
import org.jclouds.chef.domain.BootstrapConfig;
import org.jclouds.chef.domain.Client;
import org.jclouds.chef.functions.BootstrapConfigForGroup;
import org.jclouds.chef.functions.ClientForGroup;
import org.jclouds.chef.handlers.ChefApiErrorRetryHandler;
import org.jclouds.chef.handlers.ChefErrorHandler;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Provider;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public abstract class BaseChefHttpApiModule<S>
extends HttpApiModule<S> {
    @Provides
    @TimeStamp
    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.iso8601SecondsDateFormat();
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    public Supplier<PrivateKey> supplyKey(final LoadingCache<Credentials, PrivateKey> keyCache, @Provider Supplier<Credentials> creds) {
        return Suppliers.compose((Function)new Function<Credentials, PrivateKey>(){

            public PrivateKey apply(Credentials in) {
                return (PrivateKey)keyCache.getUnchecked((Object)in);
            }
        }, creds);
    }

    @Provides
    @Singleton
    LoadingCache<Credentials, PrivateKey> privateKeyCache(PrivateKeyForCredentials loader) {
        return CacheBuilder.newBuilder().maximumSize(2L).build((CacheLoader)loader);
    }

    @Provides
    @Singleton
    @Validator
    public Optional<String> provideValidatorName(Injector injector) {
        Key key = Key.get(String.class, (Annotation)Names.named((String)"chef.validator-name"));
        try {
            return Optional.of((Object)injector.getInstance(key));
        }
        catch (ConfigurationException ex) {
            return Optional.absent();
        }
    }

    @Provides
    @Singleton
    @Validator
    public Optional<PrivateKey> provideValidatorCredential(Crypto crypto, Injector injector) throws InvalidKeySpecException, IOException {
        Key key = Key.get(String.class, (Annotation)Names.named((String)"chef.validator-credential"));
        try {
            String validatorCredential = (String)injector.getInstance(key);
            PrivateKey validatorKey = crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((ByteSource)ByteSource.wrap((byte[])validatorCredential.getBytes(Charsets.UTF_8))));
            return Optional.of((Object)validatorKey);
        }
        catch (ConfigurationException ex) {
            return Optional.absent();
        }
    }

    @Provides
    @Singleton
    CacheLoader<String, BootstrapConfig> bootstrapConfigForGroup(BootstrapConfigForGroup bootstrapConfigForGroup) {
        return CacheLoader.from((Function)bootstrapConfigForGroup);
    }

    @Provides
    @Singleton
    CacheLoader<String, Client> groupToClient(ClientForGroup clientForGroup) {
        return CacheLoader.from((Function)clientForGroup);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ChefErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ChefErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ChefErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(ChefApiErrorRetryHandler.class);
    }

    @Singleton
    @VisibleForTesting
    private static class PrivateKeyForCredentials
    extends CacheLoader<Credentials, PrivateKey> {
        private final Crypto crypto;

        @Inject
        private PrivateKeyForCredentials(Crypto crypto) {
            this.crypto = crypto;
        }

        public PrivateKey load(Credentials in) {
            try {
                return this.crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec((ByteSource)ByteSource.wrap((byte[])in.credential.getBytes(Charsets.UTF_8))));
            }
            catch (InvalidKeySpecException e) {
                throw Throwables.propagate((Throwable)e);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

