/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.domain;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class DirectionalPoolRecord {
    private final String type;
    private final int ttl;
    private final boolean noResponseRecord;
    private final List<String> infoValues;

    private DirectionalPoolRecord(String type, int ttl, boolean noResponseRecord, List<String> infoValues) {
        this.type = (String)Preconditions.checkNotNull((Object)type, (Object)"type");
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0, (Object)"ttl must be >= 0");
        this.ttl = ttl;
        this.noResponseRecord = noResponseRecord;
        this.infoValues = (List)Preconditions.checkNotNull(infoValues, (Object)"infoValues");
    }

    public String getType() {
        return this.type;
    }

    public int getTTL() {
        return this.ttl;
    }

    public boolean isNoResponseRecord() {
        return this.noResponseRecord;
    }

    public List<String> getRData() {
        return this.infoValues;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.noResponseRecord, this.type, this.ttl, this.infoValues});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DirectionalPoolRecord that = (DirectionalPoolRecord)DirectionalPoolRecord.class.cast(obj);
        return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.noResponseRecord, (Object)that.noResponseRecord) && Objects.equal(this.infoValues, that.infoValues);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("ttl", this.ttl).add("noResponseRecord", this.noResponseRecord).add("infoValues", this.infoValues).toString();
    }

    public static Builder drBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DirectionalPoolRecord.drBuilder().from(this);
    }

    public static final class Builder {
        private String type;
        private int ttl = -1;
        private boolean noResponseRecord;
        private ImmutableList.Builder<String> infoValues = ImmutableList.builder();

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder noResponseRecord(boolean noResponseRecord) {
            this.noResponseRecord = noResponseRecord;
            return this;
        }

        public Builder infoValue(Object infoValue) {
            this.infoValues.add((Object)infoValue.toString());
            return this;
        }

        public Builder rdata(Object infoValue) {
            this.infoValues = ImmutableList.builder().add((Object)infoValue.toString());
            return this;
        }

        public Builder rdata(Iterable<?> infoValues) {
            this.infoValues = ImmutableList.builder().addAll(Iterables.transform(infoValues, (Function)Functions.toStringFunction()));
            return this;
        }

        public DirectionalPoolRecord build() {
            return new DirectionalPoolRecord(this.type, this.ttl, this.noResponseRecord, (List)this.infoValues.build());
        }

        public Builder from(DirectionalPoolRecord in) {
            return this.type(in.type).ttl(in.ttl).noResponseRecord(in.noResponseRecord).rdata(in.infoValues);
        }
    }
}

