/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;

public class AppendFile
implements Statement {
    public static final String DELIMITER = "END_OF_JCLOUDS_FILE";
    protected final String path;
    protected final Iterable<String> lines;
    protected final String delimiter;
    protected final boolean expandVariables;

    public static Builder builder() {
        return new Builder();
    }

    protected AppendFile(String path, Iterable<String> lines, String delimiter, boolean expandVariables) {
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"PATH");
        this.lines = (Iterable)Preconditions.checkNotNull(lines, (Object)"lines");
        this.delimiter = (String)Preconditions.checkNotNull((Object)delimiter, (Object)"delimiter");
        Preconditions.checkState((!Iterables.isEmpty(lines) ? 1 : 0) != 0, (Object)"you must pass something to execute");
        this.expandVariables = expandVariables;
    }

    public static String escapeVarTokens(String toEscape, OsFamily family) {
        HashMap inputToEscape = Maps.newHashMap();
        for (ShellToken token : ImmutableList.of((Object)((Object)ShellToken.VARL), (Object)((Object)ShellToken.VARR))) {
            if (token.to(family).equals("")) continue;
            String tokenS = "{" + token.toString().toLowerCase() + "}";
            inputToEscape.put(tokenS, "{escvar}" + tokenS);
        }
        for (Map.Entry entry : inputToEscape.entrySet()) {
            toEscape = toEscape.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return toEscape;
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    @Override
    public String render(OsFamily family) {
        if (family == OsFamily.UNIX) {
            return Statements.interpret(this.hereFile()).render(family);
        }
        return Statements.interpret(this.appendToWindowsFile()).render(family);
    }

    protected String appendToWindowsFile() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.lines) {
            builder.append(this.appendLineToWindowsFile(line, this.path));
        }
        return builder.toString();
    }

    protected String hereFile() {
        StringBuilder hereFile = this.startHereFile();
        for (String line : this.lines) {
            hereFile.append('\t').append(line).append("\n");
        }
        hereFile.append(this.delimiter).append("\n");
        return hereFile.toString();
    }

    public StringBuilder startHereFile() {
        StringBuilder hereFile = new StringBuilder().append("cat >> ").append(this.path);
        if (this.expandVariables) {
            return hereFile.append(" <<-").append(this.delimiter).append("\n");
        }
        return hereFile.append(" <<-'").append(this.delimiter).append("'\n");
    }

    protected String appendLineToWindowsFile(String line, String path) {
        String quote = "";
        if (!ShellToken.VQ.to(OsFamily.WINDOWS).equals("")) {
            quote = "'";
        } else {
            line = AppendFile.escapeVarTokens(line, OsFamily.WINDOWS);
        }
        return String.format("echo %s%s%s >>%s{lf}", quote, line, quote, path);
    }

    public static class Builder {
        protected String path;
        protected Iterable<String> lines = ImmutableSet.of();
        protected String delimiter = "END_OF_JCLOUDS_FILE";
        protected boolean expandVariables;

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder lines(Iterable<String> lines) {
            this.lines = ImmutableList.copyOf(lines);
            return this;
        }

        public Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder expandVariables(boolean expandVariables) {
            this.expandVariables = expandVariables;
            return this;
        }

        public AppendFile build() {
            return new AppendFile(this.path, this.lines, this.delimiter, this.expandVariables);
        }
    }
}

