/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.UUID;
import org.jclouds.openstack.swift.extensions.TemporaryUrlKeyApi;

@Singleton
public class ReturnOrFetchTemporaryUrlKey
implements Supplier<String> {
    private TemporaryUrlKeyApi client;

    @Inject
    public ReturnOrFetchTemporaryUrlKey(TemporaryUrlKeyApi client) {
        this.client = (TemporaryUrlKeyApi)Preconditions.checkNotNull((Object)client, (Object)"client");
    }

    public String get() {
        String key = this.client.getTemporaryUrlKey();
        if (key == null) {
            this.client.setTemporaryUrlKey(UUID.randomUUID().toString());
            return this.client.getTemporaryUrlKey();
        }
        return key;
    }
}

