/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3.blobstore.options;

import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.options.PutObjectOptions;

public class AWSS3PutObjectOptions
extends PutObjectOptions {
    private ObjectMetadata.StorageClass storageClass = ObjectMetadata.StorageClass.STANDARD;

    public AWSS3PutObjectOptions storageClass(ObjectMetadata.StorageClass storageClass) {
        this.storageClass = storageClass;
        if (storageClass != ObjectMetadata.StorageClass.STANDARD) {
            this.replaceHeader("x-amz-storage-class", this.storageClass.toString());
        }
        return this;
    }

    public ObjectMetadata.StorageClass getStorageClass() {
        return this.storageClass;
    }

    public AWSS3PutObjectOptions withAcl(CannedAccessPolicy acl) {
        return (AWSS3PutObjectOptions)super.withAcl(acl);
    }

    public static class Builder {
        public static AWSS3PutObjectOptions storageClass(ObjectMetadata.StorageClass storageClass) {
            AWSS3PutObjectOptions options = new AWSS3PutObjectOptions();
            return options.storageClass(storageClass);
        }

        public static AWSS3PutObjectOptions withAcl(CannedAccessPolicy acl) {
            AWSS3PutObjectOptions options = new AWSS3PutObjectOptions();
            return options.withAcl(acl);
        }
    }
}

