/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.config;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.LocalStorageStrategy;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.domain.internal.StorageMetadataImpl;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.ContentMetadataCodec;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.Payload;
import org.jclouds.logging.Logger;
import org.jclouds.util.Closeables2;

@Singleton
public final class LocalBlobStore
implements BlobStore {
    @Resource
    private Logger logger = Logger.NULL;
    private final BlobStoreContext context;
    private final BlobUtils blobUtils;
    private final Supplier<Set<? extends Location>> locations;
    private final ContentMetadataCodec contentMetadataCodec;
    private final Blob.Factory blobFactory;
    private final LocalStorageStrategy storageStrategy;

    @Inject
    LocalBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Memoized Supplier<Set<? extends Location>> locations, ContentMetadataCodec contentMetadataCodec, Blob.Factory blobFactory, LocalStorageStrategy storageStrategy) {
        this.context = (BlobStoreContext)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.blobUtils = (BlobUtils)Preconditions.checkNotNull((Object)blobUtils, (Object)"blobUtils");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.blobFactory = blobFactory;
        this.contentMetadataCodec = contentMetadataCodec;
        this.storageStrategy = storageStrategy;
    }

    @Override
    public BlobStoreContext getContext() {
        return this.context;
    }

    @Override
    public BlobBuilder blobBuilder(String name) {
        return this.blobUtils.blobBuilder().name(name);
    }

    @Override
    public PageSet<? extends StorageMetadata> list(String containerName) {
        return this.list(containerName, ListContainerOptions.NONE);
    }

    @Override
    public long countBlobs(String containerName) {
        return this.countBlobs(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public long countBlobs(String containerName, ListContainerOptions options) {
        return this.blobUtils.countBlobs(containerName, options);
    }

    @Override
    public void clearContainer(String containerName) {
        this.clearContainer(containerName, ListContainerOptions.Builder.recursive());
    }

    @Override
    public void clearContainer(String containerName, ListContainerOptions options) {
        this.blobUtils.clearContainer(containerName, options);
    }

    @Override
    public void deleteDirectory(String containerName, String directory) {
        this.blobUtils.deleteDirectory(containerName, directory);
    }

    @Override
    public boolean directoryExists(String containerName, String directory) {
        return this.blobUtils.directoryExists(containerName, directory);
    }

    @Override
    public void createDirectory(String containerName, String directory) {
        if (!this.blobUtils.directoryExists(containerName, directory)) {
            this.blobUtils.createDirectory(containerName, directory);
        }
    }

    @Override
    public Blob getBlob(String containerName, String key) {
        return this.getBlob(containerName, key, GetOptions.NONE);
    }

    @Override
    public void deleteContainer(String containerName) {
        this.deleteAndVerifyContainerGone(containerName);
    }

    @Override
    public Set<? extends Location> listAssignableLocations() {
        return (Set)this.locations.get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PageSet<? extends StorageMetadata> list(final String containerName, ListContainerOptions options) {
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        Iterable<String> blobBelongingToContainer = null;
        try {
            blobBelongingToContainer = this.storageStrategy.getBlobKeysInsideContainer(containerName);
        }
        catch (IOException e) {
            this.logger.error((Throwable)e, "An error occurred loading blobs contained into container %s", new Object[]{containerName});
            Throwables.propagate((Throwable)e);
        }
        SortedSet<Object> contents = Sets.newTreeSet((Iterable)Iterables.transform(blobBelongingToContainer, (Function)new Function<String, StorageMetadata>(){

            public StorageMetadata apply(String key) {
                if (!LocalBlobStore.this.storageStrategy.blobExists(containerName, key)) {
                    return new StorageMetadataImpl(StorageType.FOLDER, null, key, null, null, null, null, null, (Map<String, String>)ImmutableMap.of());
                }
                Blob oldBlob = LocalBlobStore.this.loadBlob(containerName, key);
                Preconditions.checkState((oldBlob != null ? 1 : 0) != 0, (Object)("blob " + key + " is not present although it was in the list of " + containerName));
                Preconditions.checkState((oldBlob.getMetadata() != null ? 1 : 0) != 0, (Object)("blob " + containerName + "/" + key + " has no metadata"));
                MutableBlobMetadata md = BlobStoreUtils.copy(oldBlob.getMetadata());
                md.setSize(oldBlob.getMetadata().getSize());
                return md;
            }
        }));
        String marker = null;
        if (options != null) {
            int maxResults;
            String prefix = options.getDir();
            if (prefix != null && !prefix.isEmpty()) {
                final String dirPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
                contents = Sets.newTreeSet((Iterable)Sets.filter((SortedSet)contents, (Predicate)new Predicate<StorageMetadata>(){

                    public boolean apply(StorageMetadata o) {
                        return o != null && o.getName().replace(File.separatorChar, '/').startsWith(dirPrefix) && !o.getName().replace(File.separatorChar, '/').equals(dirPrefix);
                    }
                }));
            }
            if (!options.isRecursive()) {
                String delimiter = this.storageStrategy.getSeparator();
                TreeSet commonPrefixes = Sets.newTreeSet((Iterable)Iterables.transform((Iterable)contents, (Function)new CommonPrefixes(prefix, delimiter)));
                commonPrefixes.remove("NO_PREFIX");
                contents = Sets.newTreeSet((Iterable)Sets.filter((SortedSet)contents, (Predicate)new DelimiterFilter(prefix, delimiter)));
                for (String o : commonPrefixes) {
                    MutableStorageMetadataImpl md = new MutableStorageMetadataImpl();
                    md.setType(StorageType.RELATIVE_PATH);
                    if (prefix != null && !prefix.isEmpty()) {
                        o = !prefix.endsWith(delimiter) ? prefix + delimiter + o : prefix + o;
                    }
                    md.setName(o);
                    contents.add(md);
                }
            }
            if (options.getMarker() != null) {
                void var9_14;
                String delimiter;
                final String finalMarker = options.getMarker();
                if (finalMarker.endsWith(delimiter = this.storageStrategy.getSeparator())) {
                    Optional optional = Iterables.tryFind((Iterable)contents, (Predicate)new Predicate<StorageMetadata>(){

                        public boolean apply(StorageMetadata metadata) {
                            int length = finalMarker.length() - 1;
                            return metadata.getName().substring(0, length).compareTo(finalMarker.substring(0, length)) > 0;
                        }
                    });
                } else {
                    Optional optional = Iterables.tryFind((Iterable)contents, (Predicate)new Predicate<StorageMetadata>(){

                        public boolean apply(StorageMetadata metadata) {
                            return metadata.getName().compareTo(finalMarker) > 0;
                        }
                    });
                }
                if (var9_14.isPresent()) {
                    contents = contents.tailSet(var9_14.get());
                } else {
                    contents.clear();
                }
            }
            int n = maxResults = options.getMaxResults() != null ? options.getMaxResults() : 1000;
            if (!contents.isEmpty()) {
                StorageMetadata lastElement = (StorageMetadata)contents.last();
                contents = Sets.newTreeSet((Iterable)Iterables.limit((Iterable)contents, (int)maxResults));
                if (maxResults != 0 && !contents.contains(lastElement)) {
                    lastElement = (StorageMetadata)contents.last();
                    marker = lastElement.getName();
                    if (lastElement.getType() == StorageType.RELATIVE_PATH) {
                        marker = marker + "/";
                    }
                }
            }
            if (!options.isDetailed()) {
                for (StorageMetadata storageMetadata : contents) {
                    storageMetadata.getUserMetadata().clear();
                }
            }
        }
        return new PageSetImpl(contents, marker);
    }

    private ContainerNotFoundException cnfe(String name) {
        return new ContainerNotFoundException(name, String.format("container %s not in %s", name, this.storageStrategy.getAllContainerNames()));
    }

    @Override
    public void removeBlob(String containerName, String key) {
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        this.storageStrategy.removeBlob(containerName, key);
    }

    @Override
    public void removeBlobs(String container, Iterable<String> names) {
        for (String name : names) {
            this.removeBlob(container, name);
        }
    }

    @Override
    public BlobAccess getBlobAccess(String container, String name) {
        return this.storageStrategy.getBlobAccess(container, name);
    }

    @Override
    public void setBlobAccess(String container, String name, BlobAccess access) {
        this.storageStrategy.setBlobAccess(container, name, access);
    }

    @Override
    public boolean deleteContainerIfEmpty(String containerName) {
        boolean returnVal = true;
        if (this.storageStrategy.containerExists(containerName)) {
            try {
                if (Iterables.isEmpty(this.storageStrategy.getBlobKeysInsideContainer(containerName))) {
                    this.storageStrategy.deleteContainer(containerName);
                } else {
                    returnVal = false;
                }
            }
            catch (IOException e) {
                this.logger.error((Throwable)e, "An error occurred loading blobs contained into container %s", new Object[]{containerName});
                throw Throwables.propagate((Throwable)e);
            }
        }
        return returnVal;
    }

    @Override
    public boolean containerExists(String containerName) {
        return this.storageStrategy.containerExists(containerName);
    }

    @Override
    public PageSet<? extends StorageMetadata> list() {
        Iterable<String> containers = this.storageStrategy.getAllContainerNames();
        return new PageSetImpl(Iterables.transform(containers, (Function)new Function<String, StorageMetadata>(){

            public StorageMetadata apply(String name) {
                return LocalBlobStore.this.storageStrategy.getContainerMetadata(name);
            }
        }), null);
    }

    @Override
    public boolean createContainerInLocation(Location location, String name) {
        return this.storageStrategy.createContainerInLocation(name, location, CreateContainerOptions.NONE);
    }

    @Override
    public ContainerAccess getContainerAccess(String container) {
        return this.storageStrategy.getContainerAccess(container);
    }

    @Override
    public void setContainerAccess(String container, ContainerAccess access) {
        this.storageStrategy.setContainerAccess(container, access);
    }

    private Blob loadBlob(String container, String key) {
        this.logger.debug("Opening blob in container: %s - %s", new Object[]{container, key});
        return this.storageStrategy.getBlob(container, key);
    }

    private static HttpResponseException returnResponseException(int code) {
        HttpResponse response = HttpResponse.builder().statusCode(code).build();
        return new HttpResponseException(new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://stub").build()), response);
    }

    @Override
    public String putBlob(String containerName, Blob blob) {
        Preconditions.checkNotNull((Object)containerName, (Object)"containerName must be set");
        Preconditions.checkNotNull((Object)blob, (Object)"blob must be set");
        String blobKey = blob.getMetadata().getName();
        this.logger.debug("Put blob with key [%s] to container [%s]", new Object[]{blobKey, containerName});
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        try {
            return this.storageStrategy.putBlob(containerName, blob);
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("MD5 hash code mismatch")) {
                HttpResponseException exception = LocalBlobStore.returnResponseException(400);
                exception.initCause((Throwable)e);
                throw exception;
            }
            this.logger.error((Throwable)e, "An error occurred storing the new blob with name [%s] to container [%s].", new Object[]{blobKey, containerName});
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
        Blob blob = this.getBlob(fromContainer, fromName);
        if (blob == null) {
            throw new KeyNotFoundException(fromContainer, fromName, "while copying");
        }
        InputStream is = null;
        try {
            is = blob.getPayload().openStream();
            MutableContentMetadata metadata = blob.getMetadata().getContentMetadata();
            BlobBuilder.PayloadBlobBuilder builder = this.blobBuilder(toName).payload(is);
            Long contentLength = metadata.getContentLength();
            if (contentLength != null) {
                builder.contentLength(contentLength);
            }
            if (options.getContentMetadata().isPresent()) {
                String contentType;
                String contentLanguage;
                String contentEncoding;
                ContentMetadata contentMetadata = (ContentMetadata)options.getContentMetadata().get();
                String contentDisposition = contentMetadata.getContentDisposition();
                if (contentDisposition != null) {
                    builder.contentDisposition(contentDisposition);
                }
                if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
                    builder.contentEncoding(contentEncoding);
                }
                if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
                    builder.contentLanguage(contentLanguage);
                }
                if ((contentType = contentMetadata.getContentType()) != null) {
                    builder.contentType(contentType);
                }
            } else {
                builder.contentDisposition(metadata.getContentDisposition()).contentEncoding(metadata.getContentEncoding()).contentLanguage(metadata.getContentLanguage()).contentType(metadata.getContentType());
            }
            Optional<Map<String, String>> userMetadata = options.getUserMetadata();
            if (userMetadata.isPresent()) {
                builder.userMetadata((Map)userMetadata.get());
            } else {
                builder.userMetadata(blob.getMetadata().getUserMetadata());
            }
            String string = this.putBlob(toContainer, builder.build());
            return string;
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        finally {
            Closeables2.closeQuietly((Closeable)is);
        }
    }

    private void copyPayloadHeadersToBlob(Payload payload, Blob blob) {
        blob.getAllHeaders().putAll(this.contentMetadataCodec.toHeaders((ContentMetadata)payload.getContentMetadata()));
    }

    @Override
    public boolean blobExists(String containerName, String key) {
        if (!this.storageStrategy.containerExists(containerName)) {
            throw this.cnfe(containerName);
        }
        return this.storageStrategy.blobExists(containerName, key);
    }

    @Override
    public Blob getBlob(String containerName, String key, GetOptions options) {
        this.logger.debug("Retrieving blob with key %s from container %s", new Object[]{key, containerName});
        if (!this.storageStrategy.containerExists(containerName)) {
            this.logger.debug("Container %s does not exist", new Object[]{containerName});
            throw this.cnfe(containerName);
        }
        if (!this.storageStrategy.blobExists(containerName, key)) {
            this.logger.debug("Item %s does not exist in container %s", new Object[]{key, containerName});
            return null;
        }
        Blob blob = this.loadBlob(containerName, key);
        if (options != null) {
            if (options.getIfMatch() != null && !blob.getMetadata().getETag().equals(options.getIfMatch())) {
                throw LocalBlobStore.returnResponseException(412);
            }
            if (options.getIfNoneMatch() != null && blob.getMetadata().getETag().equals(options.getIfNoneMatch())) {
                throw LocalBlobStore.returnResponseException(304);
            }
            if (options.getIfModifiedSince() != null) {
                Date modifiedSince = options.getIfModifiedSince();
                if (blob.getMetadata().getLastModified().before(modifiedSince)) {
                    HttpResponse response = HttpResponse.builder().statusCode(304).build();
                    throw new HttpResponseException(String.format("%1$s is before %2$s", blob.getMetadata().getLastModified(), modifiedSince), null, response);
                }
            }
            if (options.getIfUnmodifiedSince() != null) {
                Date unmodifiedSince = options.getIfUnmodifiedSince();
                if (blob.getMetadata().getLastModified().after(unmodifiedSince)) {
                    HttpResponse response = HttpResponse.builder().statusCode(412).build();
                    throw new HttpResponseException(String.format("%1$s is after %2$s", blob.getMetadata().getLastModified(), unmodifiedSince), null, response);
                }
            }
            blob = this.copyBlob(blob);
            if (options.getRanges() != null && !options.getRanges().isEmpty()) {
                byte[] data;
                try {
                    data = ByteStreams2.toByteArrayAndClose((InputStream)blob.getPayload().openStream());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                for (String s : options.getRanges()) {
                    int offset = 0;
                    int last = data.length - 1;
                    if (s.startsWith("-")) {
                        offset = last - Integer.parseInt(s.substring(1)) + 1;
                    } else if (s.endsWith("-")) {
                        offset = Integer.parseInt(s.substring(0, s.length() - 1));
                    } else if (s.contains("-")) {
                        String[] firstLast = s.split("\\-");
                        offset = Integer.parseInt(firstLast[0]);
                        last = Integer.parseInt(firstLast[1]);
                    } else {
                        throw new IllegalArgumentException("illegal range: " + s);
                    }
                    if (offset > last) {
                        throw new IllegalArgumentException("illegal range: " + s);
                    }
                    if (last + 1 > data.length) {
                        last = data.length - 1;
                    }
                    out.write(data, offset, last - offset + 1);
                }
                MutableContentMetadata cmd = blob.getPayload().getContentMetadata();
                byte[] byteArray = out.toByteArray();
                blob.setPayload(byteArray);
                HttpUtils.copy((ContentMetadata)cmd, (MutableContentMetadata)blob.getPayload().getContentMetadata());
                blob.getPayload().getContentMetadata().setContentLength(Long.valueOf(byteArray.length));
            }
        }
        Preconditions.checkNotNull((Object)blob.getPayload(), (Object)("payload " + blob));
        return blob;
    }

    @Override
    public BlobMetadata blobMetadata(String containerName, String key) {
        try {
            Blob blob = this.getBlob(containerName, key);
            return blob != null ? BlobStoreUtils.copy(blob.getMetadata()) : null;
        }
        catch (RuntimeException e) {
            if (Iterables.size((Iterable)Iterables.filter((Iterable)Throwables.getCausalChain((Throwable)e), KeyNotFoundException.class)) >= 1) {
                return null;
            }
            throw e;
        }
    }

    private Blob copyBlob(Blob blob) {
        Blob returnVal = this.blobFactory.create(BlobStoreUtils.copy(blob.getMetadata()));
        returnVal.setPayload(blob.getPayload());
        this.copyPayloadHeadersToBlob(blob.getPayload(), returnVal);
        return returnVal;
    }

    private boolean deleteAndVerifyContainerGone(String container) {
        this.storageStrategy.deleteContainer(container);
        return this.storageStrategy.containerExists(container);
    }

    @Override
    public String putBlob(String containerName, Blob blob, PutOptions options) {
        return this.putBlob(containerName, blob);
    }

    @Override
    public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        return this.storageStrategy.createContainerInLocation(container, location, options);
    }

    private static class CommonPrefixes
    implements Function<StorageMetadata, String> {
        private final String prefix;
        private final String delimiter;
        public static final String NO_PREFIX = "NO_PREFIX";

        public CommonPrefixes(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        public String apply(StorageMetadata metadata) {
            String working = metadata.getName();
            if (this.prefix != null) {
                String toMatch;
                String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
                if (working.startsWith(toMatch)) {
                    working = working.replaceFirst(Pattern.quote(toMatch), "");
                }
            }
            if (working.contains(this.delimiter)) {
                return working.substring(0, working.indexOf(this.delimiter));
            }
            return NO_PREFIX;
        }
    }

    private static class DelimiterFilter
    implements Predicate<StorageMetadata> {
        private final String prefix;
        private final String delimiter;

        public DelimiterFilter(String prefix, String delimiter) {
            this.prefix = prefix;
            this.delimiter = delimiter;
        }

        public boolean apply(StorageMetadata metadata) {
            String toMatch;
            if (this.prefix == null || this.prefix.isEmpty()) {
                return metadata.getName().indexOf(this.delimiter) == -1;
            }
            String string = toMatch = this.prefix.endsWith("/") ? this.prefix : this.prefix + this.delimiter;
            if (metadata.getName().startsWith(toMatch)) {
                String unprefixedName = metadata.getName().replaceFirst(Pattern.quote(toMatch), "");
                if (unprefixedName.equals("")) {
                    return false;
                }
                return unprefixedName.indexOf(this.delimiter) == -1;
            }
            return false;
        }
    }
}

