/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;

public class BulkDeleteResponse {
    private final int deleted;
    private final int notFound;
    private final Map<String, String> errors;

    public static BulkDeleteResponse create(int deleted, int notFound, Map<String, String> errors) {
        return new BulkDeleteResponse(deleted, notFound, errors);
    }

    private BulkDeleteResponse(int deleted, int notFound, Map<String, String> errors) {
        this.deleted = deleted;
        this.notFound = notFound;
        this.errors = (Map)Preconditions.checkNotNull(errors, (Object)"errors");
    }

    public int getDeleted() {
        return this.deleted;
    }

    public int getNotFound() {
        return this.notFound;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BulkDeleteResponse) {
            BulkDeleteResponse that = (BulkDeleteResponse)BulkDeleteResponse.class.cast(object);
            return Objects.equal((Object)this.getDeleted(), (Object)that.getDeleted()) && Objects.equal((Object)this.getNotFound(), (Object)that.getNotFound()) && Objects.equal(this.getErrors(), that.getErrors());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getDeleted(), this.getNotFound(), this.getErrors()});
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("deleted", this.getDeleted()).add("notFound", this.getNotFound()).add("errors", this.getErrors());
    }

    public String toString() {
        return this.string().toString();
    }
}

