/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.protocol.data;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;

public class DataUrlDecoder {
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private static final String DEFAULT_MEDIA_TYPE = "text/plain";
    private final String mediaType_;
    private final String charset_;
    private byte[] content_;

    protected DataUrlDecoder(byte[] data, String mediaType, String charset) {
        this.content_ = data;
        this.mediaType_ = mediaType;
        this.charset_ = charset;
    }

    public static DataUrlDecoder decode(URL url) throws UnsupportedEncodingException, DecoderException {
        return DataUrlDecoder.decodeDataURL(url.toExternalForm());
    }

    public static DataUrlDecoder decodeDataURL(String url) throws UnsupportedEncodingException, DecoderException {
        if (!url.startsWith("data")) {
            throw new IllegalArgumentException("Not a data url: " + url);
        }
        int comma = url.indexOf(44);
        String beforeData = url.substring("data:".length(), comma);
        String mediaType = DataUrlDecoder.extractMediaType(beforeData);
        String charset = DataUrlDecoder.extractCharset(beforeData);
        boolean base64 = beforeData.endsWith(";base64");
        byte[] data = url.substring(comma + 1).getBytes(charset);
        data = base64 ? Base64.decodeBase64((byte[])DataUrlDecoder.decodeUrl(data)) : URLCodec.decodeUrl((byte[])data);
        return new DataUrlDecoder(data, mediaType, charset);
    }

    private static String extractCharset(String beforeData) {
        return DEFAULT_CHARSET;
    }

    private static String extractMediaType(String beforeData) {
        if (beforeData.contains("/")) {
            if (beforeData.contains(";")) {
                return StringUtils.substringBefore((String)beforeData, (String)";");
            }
            return beforeData;
        }
        return DEFAULT_MEDIA_TYPE;
    }

    public String getMediaType() {
        return this.mediaType_;
    }

    public String getCharset() {
        return this.charset_;
    }

    public byte[] getBytes() {
        return this.content_;
    }

    public String getDataAsString() throws UnsupportedEncodingException {
        return new String(this.content_, this.charset_);
    }

    private static byte[] decodeUrl(byte[] bytes) throws DecoderException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                try {
                    int u = DataUrlDecoder.digit16(bytes[++i]);
                    int l = DataUrlDecoder.digit16(bytes[++i]);
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid URL encoding: ", (Throwable)e);
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static int digit16(byte b) throws DecoderException {
        int i = Character.digit((char)b, 16);
        if (i == -1) {
            throw new DecoderException("Invalid URL encoding: not a valid digit (radix 16): " + b);
        }
        return i;
    }
}

