/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.ldap.repository.support.LdapRepositoryFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class LdapRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String ATT_LDAP_TEMPLATE_REF = "ldap-template-ref";

    protected String getModulePrefix() {
        return "ldap";
    }

    public String getRepositoryFactoryClassName() {
        return LdapRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        String ldapTemplateRef = element.getAttribute(ATT_LDAP_TEMPLATE_REF);
        if (!StringUtils.hasText((String)ldapTemplateRef)) {
            ldapTemplateRef = "ldapTemplate";
        }
        builder.addPropertyReference("ldapOperations", ldapTemplateRef);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("ldapOperations", attributes.getString("ldapTemplateRef"));
    }
}

