/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSConfigurationException;
import com.thetransactioncompany.cors.CORSConfigurationLoader;
import com.thetransactioncompany.cors.CORSOriginDeniedException;
import com.thetransactioncompany.cors.CORSRequestHandler;
import com.thetransactioncompany.cors.CORSRequestType;
import com.thetransactioncompany.cors.HTTPMethod;
import com.thetransactioncompany.cors.HeaderFieldName;
import com.thetransactioncompany.cors.InvalidCORSRequestException;
import com.thetransactioncompany.cors.UnsupportedHTTPHeaderException;
import com.thetransactioncompany.cors.UnsupportedHTTPMethodException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSFilter
implements Filter {
    private CORSConfiguration config;
    private CORSRequestHandler handler;

    public CORSConfiguration getConfiguration() {
        return this.config;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        CORSConfigurationLoader configLoader = new CORSConfigurationLoader(filterConfig);
        try {
            this.config = configLoader.load();
        }
        catch (CORSConfigurationException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        this.handler = new CORSRequestHandler(this.config);
    }

    private void printMessage(HttpServletResponse response, int sc, String msg) throws IOException, ServletException {
        response.setStatus(sc);
        response.resetBuffer();
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        out.println("Cross-Origin Resource Sharing (CORS) Filter: " + msg);
    }

    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handler.tagRequest(request);
        CORSRequestType type = CORSRequestType.detect(request);
        try {
            if (type.equals((Object)CORSRequestType.ACTUAL)) {
                this.handler.handleActualRequest(request, response);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else if (type.equals((Object)CORSRequestType.PREFLIGHT)) {
                this.handler.handlePreflightRequest(request, response);
            } else if (this.config.allowGenericHttpRequests) {
                request.setAttribute("cors.isCorsRequest", (Object)false);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                request.setAttribute("cors.isCorsRequest", (Object)false);
                this.printMessage(response, 403, "Generic HTTP requests not allowed");
            }
        }
        catch (InvalidCORSRequestException e) {
            request.setAttribute("cors.isCorsRequest", (Object)false);
            this.printMessage(response, 400, e.getMessage());
        }
        catch (CORSOriginDeniedException e) {
            String msg = e.getMessage() + ": " + e.getRequestOrigin();
            this.printMessage(response, 403, msg);
        }
        catch (UnsupportedHTTPMethodException e) {
            String msg = e.getMessage();
            HTTPMethod method = e.getRequestedMethod();
            if (method != null) {
                msg = msg + ": " + method.toString();
            }
            this.printMessage(response, 405, msg);
        }
        catch (UnsupportedHTTPHeaderException e) {
            String msg = e.getMessage();
            HeaderFieldName header = e.getRequestHeader();
            if (header != null) {
                msg = msg + ": " + header.toString();
            }
            this.printMessage(response, 403, msg);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            throw new ServletException("Cannot filter non-HTTP requests/responses");
        }
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    public void destroy() {
    }
}

