<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<span ng-controller="SyncController" xmlns="http://www.w3.org/1999/html">
<div class="container">
    <?php if(WORKFLOW_IMAGE == true){ ?>
        <div class="row text-center" style="margin-top: 5%">
            <img src="<?=Url::templatePath()?>images/wiproFilesWorkfloChange.png" />
        </div>
    <?php } ?>
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>

        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main">
    <span class="hide shareType"><?php if(SHARE_WITHIN_ORG == true){echo 'shareWith';}else{echo 'share';}?></span>
    <span class="hide currentPage"><?='files'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide openFileRevision"><?php if(!empty($_SESSION['openFileRevision'])){echo htmlspecialchars($_SESSION['openFileRevision']);}else{echo 'none';}$_SESSION['openFileRevision'] = null;?></span>
    <span class="hide shareDefault7Days"><?php if(SHARE_DEFAULT_7_DAYS == true){echo 'true';}else{echo 'false';}?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav nav-breadcrumb" id="breadCrumb">
                        <li ng-repeat="value in crumb track by $index"><a href="javascript:;" ng-click="updateFileListFromBreadCrumb(value, $index)" class="toolTip" data-toggle="tooltip" data-placement="top" data-original-title="{{ value }}" ng-cloak>{{ value }}</a></li>
                    </ul>
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <li><a class="viewAction toolTip" ng-click="view()" data-toggle="tooltip" data-placement="top" title="View" style="display: none" href="javascript:;"><i class="fa fa-eye"></i></a></li>
                        <li><a class="versionsAction toolTip" ng-click="versions()" data-toggle="tooltip" data-placement="top" title="Versions" style="display: none" href="javascript:;"><i class="fa fa-clock-o"></i></a></li>
                        <?php if($data['policy']['shareEnabled'] == "1"){ ?>
                            <?php if(SHARE_WITHIN_ORG == false){?>
                                <li><a class="shareAction toolTip" ng-click="share()" data-toggle="tooltip" data-placement="top" title="Share" style="display: none" href="javascript:;"><i class="fa fa-share"></i></a></li>
                            <?php }else{ ?>
                                <li><a class="shareAction toolTip" ng-click="shareWith()" data-toggle="tooltip" data-placement="top" title="Share" style="display: none" href="javascript:;"><i class="fa fa-share"></i></a></li>
                            <?php } ?>
                        <?php } ?>
                        <li><a class="downloadAction toolTip" ng-click="download('')" data-toggle="tooltip" data-placement="top" title="Download" style="display: none" href="javascript:;"><i class="fa fa-download"></i></a></li>
                        <li><a class="deleteAction toolTip" ng-click="delete()" data-toggle="tooltip" data-placement="top" title="Delete" style="display: none" href="javascript:;"><i class="fa fa-trash"></i></a></li>
                        <li><a class="renameAction toolTip" ng-click="rename()" data-toggle="tooltip" data-placement="top" title="Rename" style="display: none" href="javascript:;"><i class="fa fa-edit"></i></a></li>
                        <li><a class="cutAction toolTip" ng-click="cut()" data-toggle="tooltip" data-placement="top" title="Cut" style="display: none" href="javascript:;"><i class="fa fa-cut"></i></a></li>
                        <li><a class="copyAction toolTip" ng-click="copy()" data-toggle="tooltip" data-placement="top" title="Copy" style="display: none" href="javascript:;"><i class="fa fa-copy"></i></a></li>
                        <li ng-if="selectedFilesForCopyCut.length > 0 && currentCrumb != selectedFilesForCopyCutFromPath"><a class="pasteAction toolTip" ng-click="paste()" data-toggle="tooltip" data-placement="top" title="Paste" href="javascript:;"><i class="fa fa-clipboard"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow" ng-if="items.length > 0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'fileName'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'modifiedTime'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'modifiedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'modifiedTime' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'rawSize'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'rawSize' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'rawSize' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'.selectable', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse" ng-class="{'selectable': value.selectable == 'yes'}">
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Mini Cloud'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Folder'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'File'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: #585f69;"><span ng-bind-html="value.fileName | charLimit"></span> <span class="text-warning" ng-if="value.storagePlace.length <= 0"><i class="fa fa-arrow-up faa-float animated"></i></span></a></td>
                            <td ng-cloak> {{ value.type }} </td>
                            <td ng-cloak> {{ value.modifiedTime | timeAgo: 'medium' }} </td>
                            <td ng-if="value.type == 'Mini Cloud'" ng-cloak> - </td>
                            <td ng-if="value.type == 'Folder'" ng-cloak> - </td>
                            <td ng-if="value.type == 'File'" ng-cloak>
                                {{ value.size }}
                                <!--                                    <span ng-if="value.storagePlace.length <= 0" class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span>-->
                            </td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Mini Cloud'" ng-cloak>-</td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Folder'" ng-cloak>-</td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'File'" ng-cloak>
                                <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="View"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForView(value.fileName)"><i class="fa fa-eye"></i></a>
                                &nbsp;&nbsp;
                                <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Download"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForDownload(value.fileName)"><i class="fa fa-download"></i></a>
                                &nbsp;&nbsp;
                                <?php if($data['policy']['shareEnabled'] == "1"){ ?>
                                    <?php if(SHARE_WITHIN_ORG == false){?>
                                        <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Share"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForShare(value.fileName, 'share')"><i class="fa fa-share"></i></a>
                                    <?php }else{ ?>
                                        <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Share With"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForShare(value.fileName, 'shareWith')"><i class="fa fa-share"></i></a>
                                    <?php } ?>
                                <?php } ?>
                                &nbsp;&nbsp;
                                <a class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Delete"  style="cursor: pointer; color: #585f69;" ng-click="selectFileForDelete(value.fileName)"><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <?php if(DISABLE_SHOW_PG_ICON){ ?>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p>
                </div>
                <?php } ?>
            </div>
            <div class="text-center status" style="display: none;">
                <h3>There are no files or folder</h3>
            </div>
            <div class="modal fade deleteConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFile()" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h5 class="modal-title">Loading ...</h5>
                        </div>
                        <br/><br/>
                        <div class="modal-body">
                            <div class="pageContainer" style="display: none;"></div>
                            <div class="pdfContainer" style="display: none;"></div>
                            <div class="excelContainer" style="display: none;"></div>
                            <div class="content" style="display: none;"></div>
                            <div class="imageViewer" style="display: none;"></div>
                            <div class="paraviewLoading" style="margin-top: 15%">
                                <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade whiteAndBigModal syncFileVersions">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">File Versions list - File Name: <span>{{ selectedFiles[0].fileName }}</span></h4>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive" style="margin-top: -20px;">
                                <hr/>
                                <div class="h4 loading text-center">Loading.....</div>
                                <table class="table table-striped fileVersionsTable" style="display: none;">
                                    <tbody>
                                    <tr ng-repeat="value in fileVersions track by $index">
                                        <td ng-if="$index != 0" ng-cloak>{{ value.version + (fileVersions.length-$index)}}</td>
                                        <td ng-if="$index == 0" ng-cloak>{{ value.version + (fileVersions.length-$index)}} (Current Version)</td>
                                        <td class="text-success" ng-if="value.status == 'ADDED'" ng-cloak>{{ value.status }}</td>
                                        <td class="text-info" ng-if="value.status == 'MODIFIED'" ng-cloak>{{ value.status}}</td>
                                        <td class="text-info" ng-if="value.status == 'RESTORED'" ng-cloak>{{ value.status}}</td>
                                        <td class="text-danger" ng-if="value.status == 'DELETED'" ng-cloak>{{ value.status}}</td>
                                        <td ng-cloak>by {{ value.fileUser }}</td>
                                        <td ng-if="value.fileDevice.length > 0" ng-cloak>from {{ value.fileDevice }}</td>
                                        <td ng-if="value.fileDevice.length <= 0" ng-cloak>from Portal</td>
                                        <td ng-cloak>on {{ value.modifiedTime }}</td>
                                        <td ng-cloak>{{ value.size }}</td>
                                        <td>
                                            <a class="btn btn-small btn-primary" ng-click="revisionCommentBox($index)"><i class="fa fa-comment"></i></a>
                                            <a ng-hide="value.status == 'DELETED'" class="btn btn-small btn-info" ng-click="download($index, true)"><i class="fa fa-download"></i></a>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="commentsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="saveComment(fileRevisionComments)">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Save File version comments</h4>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="fileRevisionComments">Comments</label>
                                    <textarea class="form-control" id="fileRevisionComments" required></textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveComments btn btn-success">Save Comments</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="rename" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="saveRename(changedName)">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Rename the selected file or folder</h4>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="changedName">Name</label>
                                    <input type="text" class="form-control" id="changedName" required />
                                </div>
                                <span class="renameError"></span>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="shareWith" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShareWith()">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div style="display: none;" class="modal-body shareWithBodyStatus">File has already been shared</div>
                            <div class="modal-body shareBody shareWithBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <div class="form-group <?php if(SHARE_DEFAULT_7_DAYS == true){echo 'hide';} ?>">
                                                <label for="till">Valid Till <span class="shareWithRemoveValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="shareWithValidTill form-control" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly>
                                            </div>
                                            <div class="form-group">
                                                <label for="listOfUsers">Email Address: </label>
                                                <input type="text" class="listOfUsers form-control" name="userNames" id="listOfUsers" placeholder="Enter Email address" />
                                            </div>
                                            <div class="form-group">
                                                <label for="shareWithSubject">Subject: </label>
                                                <input type="text" style="width:100%" class="shareWithSubject" name="shareWithSubject" id="shareWithMessage" placeholder="Enter your Subject" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="256" />
                                            </div>
                                            <div class="form-group">
                                                <label for="message">Message: </label>
                                                <textarea style="width:100%" class="shareWithMessage" name="shareWithMessage" id="shareWithMessage" placeholder="Enter your message" data-parsley-trigger="change" data-parsley-minlength="20" data-parsley-maxlength="512"></textarea>
                                            </div>
                                            <div class="granular hide">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" />
                                                    </div>
                                                <?php } else{ ?>
                                                    <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="shareWithEnableView">Allow View: </label>
                                                    <input type="checkbox" id="shareWithEnableView" class="shareWithEnableView" checked />
                                                </div>
                                                <span>Note:- Files will be shared with a default validity of 7 days.</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareWithDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShare()">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div class="modal-body shareBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <h4>Password Protected:
                                                <span><input type="checkbox" class="sharePasswordSwitch" /></span>
                                            </h4>
                                            <span class="sharePasswordBlock" style="display: none;">
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" class="form-control" id="sharePassword" placeholder="Enter a Password" data-parsley-minlength="6" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')"<?php } ?> data-parsley-trigger="change">
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" class="form-control" id="reSharePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-equalto="#sharePassword" data-parsley-trigger="change">
                                                </div>
                                            </span>
                                            <div class="form-group">
                                                <label for="till">Valid Till <span class="removeValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="form-control till" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly <?php if($data['policy']['expiredDate'] == "1"){ echo " required"; }?>>
                                            </div>
                                            <div class="granular">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="enableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="enableDownload" class="enableDownload" />
                                                    </div>
                                                <?php } else { ?>
                                                    <label for="enableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="enableDownload" class="enableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="enableView">Allow View: </label>
                                                    <input type="checkbox" id="enableView" class="enableView" checked />
                                                </div>
                                            </div>
                                            <div class="shareLinkBlock" style="display: none;">
                                                <h4>
                                                    Share the below link to share the file:
                                                    <a ng-click="sendEmailShareLink()" class="clickAble pull-right sendEmailShareLink"><i class="fa fa-envelope"></i></a>
                                                </h4>
                                                <h5 class="shareLink" style="word-wrap: break-word;"></h5>
                                            </div>
                                            <div class="form-group sendEmailShareForm hide">
                                                <label for="emails">Emails</label>
                                                <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                                <a ng-click="sendShareEmail(emails)" class="btn btn-small btn-default shareEmailLinkSendBtn"> Send</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="deleteConfirm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p class="deleteConfirmMessage"></p>
                            <br/><br/>
                            <a type="button" class="pull-right btn btn-default" style="margin-top: -30px" data-dismiss="modal">Cancel</a>
                            <a type="button" ng-click="deletedConfirmed()" style="margin-top: -30px; margin-right: 5px;" class="pull-right btn btn-danger">Delete</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
</span>
<?php View::renderTemplate('partials/scripts')?>
<script>
    <?php if(SHARE_WITHIN_ORG == false){?>
    $('.till').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.till').val() != ''){
            $('.removeValidUntil').show();
        }
    });

    $('.removeValidUntil').on('click', function(){
        $('.till').val('');
        $('.removeValidUntil').hide();
    });
    <?php }else{ ?>
    $('.shareWithValidTill').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.shareWithValidTill').val() != ''){
            $('.shareWithRemoveValidUntil').show();
        }
    });

    $('.shareWithRemoveValidUntil').on('click', function(){
        $('.shareWithValidTill').val('');
        $('.shareWithRemoveValidUntil').hide();
    });
    <?php } ?>
    jQuery(document).bind("keyup keydown", function(e){
        if(e.ctrlKey && e.keyCode == 80){
            return false;
        }
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    //    var assignUsers = $(".assignUsers").select2({
    //        ajax: {
    //            url: "<?//=DIR?>//"+"userGroups/getAllUnBlockedUsersWithGroups",
    //            dataType: 'json',
    //            delay: 250,
    //            data: function (params) {
    //                return {
    //                    q: params.term,
    //                    page: params.page
    //                };
    //            },
    //            processResults: function (data, params) {
    //                params.page = params.page || 1;
    //                if(data.users.length > 0){
    //                    $('.assignSaveBtn').removeAttr('disabled');
    //                }
    //                return {
    //                    results: $.map(data.users, function (o) {
    //                        return { id: o.userName, text: o.emailId, img: o.profilePic };
    //                    }),
    //                    pagination: {
    //                        more: (params.page * 30) < data.total_count
    //                    }
    //                };
    //            },
    //            cache: true
    //        },
    //        escapeMarkup: function (markup) { return markup; },
    //        templateResult: selectTemplateResult,
    //        templateSelection: selectTemplateSelection,
    //        placeholder: 'Select users'
    //    });
    //
    //    function selectTemplateResult(users){
    //        if(users.text != undefined){
    //            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
    //            if(users.img){
    //                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
    //            }
    //            template += users.text + "</div></div>";
    //            return template;
    //        }else{
    //            return "<div class='select2-user-result'>Fetching...</div>";
    //        }
    //    }
    //
    //    function selectTemplateSelection(users){
    //        return users.text;
    //    }
    //
    //    $('#assignUsers').on('hidden.bs.modal', function () {
    //        window.location.reload(true);
    //    })
</script>