<?php

use \Core\View;
use \Helpers\Url;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Proxy Configuration</h4>
                    </div>
                    <div class="panel-body">
                        <?php if($data['proxy']){?>
                            <div class="col-lg-4 ng-scope block-ui block-ui-anim-fade" aria-busy="false">
                                <div class="panel panel-default no-box-shadow widget-success">
                                    <div class="background">
                                        <i class="fa fa-language"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <span>
                                            <a>Proxy Host: </a><a class="pull-right"><?=$data['proxy']->{"host"}?></a>
                                            <br/>
                                        </span>
                                        <span>
                                            <a>Proxy Port: </a><a class="pull-right"><?=$data['proxy']->{"port"}?></a>
                                            <br/>
                                        </span>
                                        <span>
                                            <a>Proxy UserName: </a><a class="pull-right"><?=$data['proxy']->{"userName"}?></a>
                                            <br/>
                                        </span>
                                        <span>
                                            <a>Proxy Password: </a><a class="pull-right">********</a>
                                            <br/>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php }else{ ?>
                            <div>
                                <h2 align="center">NO Proxy details has been saved</h2>
                            </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Proxy Configuration</h4>
                    </div>
                    <div class="panel-body">
                        <form class="proxyConfiguration" ng-submit="saveProxyConfiguration()" data-parsley-validate>
                            <div class="form-group col-lg-6">
                                <label for="proxyURL">Proxy URL</label>
                                <input type="text" class="form-control" name="proxyURL" id="proxyURL" value="" placeholder="Enter your proxy Url" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Enter the complete proxy URL, example:- http://www.example.com</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="proxyPort">Proxy Port</label>
                                <input type="text" class="form-control" name="proxyPort" id="proxyPort" value="" placeholder="Enter your Port" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Enter the complete proxy Port</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="proxyUserName">Account Username</label>
                                <input type="text" class="form-control" name="proxyUserName" id="proxyUserName" value="" placeholder="Enter your Proxy Username" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Enter your username which is used to login to your proxy server</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="proxyPassword">Account password</label>
                                <input type="password" class="form-control" name="proxyPassword" id="proxyPassword" value="" placeholder="Enter your Proxy Password" required autocomplete="off">
                                <span class="help-line text-muted">Note:- Enter your Proxy server password which is used to login to you proxy server</span>
                                <br/><br/>
                                <button type="submit" class="btn btn-success pull-right proxySave">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
