<?php

use \Core\View;
use \Helpers\Url;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Local Storage Settings</h4>
                    </div>
                    <div class="panel-body">
                        <form class="encryptionConfiguration" ng-submit="saveEncryptionConfiguration()" data-parsley-validate>
                            <div class="form-group col-lg-6">
                                <label for="path">Server Path</label>
                                <input type="text" class="form-control" name="path" id="path" value="" placeholder="Enter your Server Path" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="userName">Server Username</label>
                                <input type="text" class="form-control" name="userName" id="userName" value="" placeholder="Enter your Server username" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-12">
                                <label for="password">Server Password</label>
                                <input type="password" class="form-control" name="password" id="password" value="" placeholder="Enter your Server Password" required autocomplete="off">
                                <br/>
                                <button type="submit" class="btn btn-success pull-right">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
