<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('dashboard')?>"><?="Dashboard"?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='noBackup'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading"><h3><?=$data['crumb1']?></div>
                    <div class="panel-body"><div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateNoBackup(0, search.noOfDays)" data-parsley-validate>
                                    <div class="form-group">
                                        <label for="noOfDays">Number of Days</label>
                                        <input type="number" class="form-control" id="noOfDays" ng-model="search.noOfDays" placeholder="Number Of Days" data-parsley-trigger="change">
                                    </div>
                                    <button type="submit" class="btn btn-default">View</button>
                                    <a ng-click="exportToExcel('#NoBackup', 'No Backup', noBackup)" class="btn btn-default">Download</a>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <br/>
                        <table id="NoBackup" class="table table-bordered noBackup" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                        <?=Language::show('Server', 'keywords')?>
                                    <?php }else{ ?>
                                        <?=Language::show('device', 'keywords')?>
                                    <?php } ?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('user', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'endTime'; sortReverse = !sortReverse">
                                    <?=Language::show('lastBackup', 'keywords')?>
                                    <span ng-show="sortType == 'endTime' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'endTime' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in noBackup | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.userName }}</td>
                                <td ng-if="value.endTime != null" ng-cloak>{{ value.endTime }}</td>
                                <td ng-if="value.endTime == null" ng-cloak>No Backup Yet</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 noBackupError text-center" style="display: none">There were no systems found</div>
                    </div>
                    <div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMore(skipValue, 'longBackup')">Load More ...</a>
                            <br /><br />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'dd/mm/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
    $('#from').datepicker('update', '01/01/2015');
    $('#to').datepicker({
        format: 'dd/mm/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>