/**
 * Created by parablu-dev on 8/5/15.
 */

app.controller('SupportController', ['$scope', 'toastr', '$http', '$ngBootbox', 'blockUI', 'BASE_FOLDER', function($scope, toastr, $http, $ngBootbox, blockUI,BASE_FOLDER) {

    $scope.BASE_FOLDER = BASE_FOLDER;
    $scope.currentPage = $('.currentPage').html();

    $scope.updatedSupportLogs = function(){
        $.ajax({
            url: $scope.BASE_FOLDER+'/support',
            data: {secret: '',csrf_token: $('.csrf_token').html()},
            type: 'POST'
        }).done(function(data){
            blockUI.stop();
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                if(jData.supportLogs.length > 0){
                    $('.loading').hide();
                    $('.supportLogTable').show();
                    $scope.supportLogs = jData.supportLogs;
                    $scope.$apply();
                }else{
                    $('.loading').show();
                    $('.loading').html('<h4>There was no support logs found</h4>');
                    $('.supportLogTable').hide();
                    $scope.$apply();
                }
            }else{
                toastr.error(jData.msg, 'Fail!!!', {allowHtml: true});
            }
        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.getSupportLogs = function(serverHostName){
        $.ajax({
            url: $scope.BASE_FOLDER+'/server/getSupportLogs',
            data: {csrf_token: $('.csrf_token').html(), serverHostName: serverHostName},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                toastr.success(jData.message, 'Successful!!!', {allowHtml: true});
                $scope.updatedSupportLogs();
            }else{
                toastr.error(jData.message, 'Fail!!!', {allowHtml: true});
            }

        }).error(function(data){
            toastr.error('Session has been expired, re-establising the connection..., or will be redirected to <b>"Login page"</b>', 'Fail!!!', {allowHtml: true});
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = $scope.BASE_FOLDER+'/serviceDown';
                }, 3000);
            }
        });
    };

    $scope.downloadLog = function(log){
        window.location.href = log;
    };

    angular.element(document).ready(function(){
        $('.loading').html('Loading ...');
        if($scope.currentPage == 'support'){
            blockUI.start();
            $scope.updatedSupportLogs();
        }
    });

}]);