<?php
namespace Models;

use Core\Model;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login Model
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class Login extends Model{

    function __construct(){
        parent::__construct();
        $this->log('Login Model was called', 'info');
    }

    public function isFirstCustomer(){
        $this->curl->get(PARA_URL.'api/check/firstlogin');
        if($this->curl->response_headers->container['first-login'] == 'true'){
            return 'true';
        }else{
            return $this->curl->response_headers->container['cloud-name'];
        }
    }

    public function getAllDetails(){
        $url = $this->api->getUrl('ping');
        $this->curl->get($url);
        $response = array(
            'statusCode' => $this->curl->http_status_code,
            'response' => $this->curl->response,
            'response_headers' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($response), 'info');
        return $response;
    }

    public function authenticate($opts){
        $url = $this->api->getUrl('authenticate');
        $this->curl->setHeaders($opts);
        $this->curl->get($url);
        $response = array(
            'status' => ($this->curl->http_status_code == 202) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log(json_encode($url), 'info');
        $this->log(json_encode($response), 'info');
        return $response;
    }

    public function authFromAgent($opts){
        $url = $this->api->getUrl('authFromAgent');
        $this->curl->setHeaders($opts);
        $this->curl->get($url);
        $response = array(
            'status' => ($this->curl->http_status_code == 202) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($response), 'info');
        return $response;
    }

    public function passwordRest($opts){
        $url = $this->api->getUrl('passwordRest');
        $this->curl->setHeaders($opts);
        $this->curl->get($url);
        $response = array(
            'status' => ($this->curl->http_status_code == 202) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response,
            'headers' => $this->curl->response_headers
        );
        $this->log('Result: '. json_encode($response), 'info');
        return $response;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $emailProps
     * @return array
     */
    public function sendMail($headers, $emailProps){
        $url = $this->api->getUrl('sendNoTokenMail');
        $this->curl->setHeaders($headers);
        $this->curl->post($url, $emailProps);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $url
     * @return array
     */
    public function verifyPasswordRest($headers, $url){
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            '$url' => $url,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @param $url
     * @return array
     */
    public function updatePassword($headers, $url){
        $this->curl->setHeaders($headers);
        $this->curl->put($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            '$url' => $url,
            'body' => $this->curl->raw_response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

    /**
     * Below info gets all the information
     * of a particular User
     *
     * @param $headers
     * @return array
     */
    public function getDeviceDetails($headers){
        $url = $this->api->getUrl('getDeviceDetails');
        $this->curl->setHeaders($headers);
        $this->curl->get($url);
        $result = array(
            'status' => ($this->curl->http_status_code == 201) ? 200 : $this->curl->http_status_code,
            'body' => $this->curl->response
        );
        $this->log('Result: '. json_encode($result), 'info');
        return $result;
    }

}