<?php
namespace Helpers;

use Helpers\Session;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* Api.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 8/4/15
* @time 11:50 AM
* 
*/

class Api{

    /**
     * @var
     */
    private $url;

    /**
     *
     * Below method will get the url according to the api
     * Request.
     *
     * @param $api
     * @param array $params
     * @return mixed|string
     */
    public function getUrl($api, $params = []){
        $data = file_get_contents ('app/ApiUrl.json');
        $jData = json_decode($data, true);
        $session = new Session();
        $userName = (!empty($params['userName'])) ? $params['userName'] : $session->get('userName');
        $cloudName = (!empty($_POST['cloudName'])) ? $_POST['cloudName'] : CLOUD_NAME;
        if($jData[$api]){
            $cleanUrl = str_replace(':', '', $jData[$api]);
            $dotUrl = str_replace('{cloudName}', $cloudName, $cleanUrl);
            foreach($params as $key => $value){
                $dotUrl = str_replace('{'.$key.'}', !empty($value) ? $value : $userName, $dotUrl);
            }
            $withOutDotUrl = str_replace('.', DS, $dotUrl);
            if(strpos($withOutDotUrl, '{paracloud}') !== false){
                $url = str_replace('{paracloud}', PARACLOUD_URL, $withOutDotUrl);
            }elseif(strpos($withOutDotUrl, '{support}') !== false){
                $url = str_replace('{support}', SUPPORT_URL, $withOutDotUrl);
            }else{
                $url = str_replace('{blukrypt}', BLUKRYPT_URL, $withOutDotUrl);
            }
        }else{
            $url = '';
        }
        return $url;
    }

    /**
     * Below method will get the a custom url and set it
     * to an api request.
     *
     * @param $url
     * @return bool
     */
    public function setUrl($url){
        if(!empty($url)){
            $this->url = $url;
            return true;
        }else{
            return false;
        }
    }

}