<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Auth;
use Helpers\Url;
use Models\Mechanic;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class MechanicController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->language->load('mechanic');
        $this->_model = new Mechanic();

    }

    public function download(){
        $data = array(
            'title' => $this->language->get('downloads'),
            'crumb1' => $this->language->get('download_applications'),
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('mechanic/download', $data);
        View::renderTemplate('footer', $data);
    }

    public function downloadAgent(){
        if(!empty($_GET['type'])){
            switch ($_GET['type']) {
                case ('EPAForWindows'):
                    $path 		= PATH_CLIENT_DOWNLOAD . DS .WINDOWS_CLIENT_FILENAME ;
                    $filename 	= WINDOWS_CLIENT_FILENAME;
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('EPAForMac'):
                    $path 		= PATH_CLIENT_DOWNLOAD . DS .MAC_CLIENT_FILENAME ;
                    $filename 	= MAC_CLIENT_FILENAME;
                    copy($path, getcwd().'/app/templates/'.TEMPLATE.'/'.$filename);
                    Url::redirect(Url::templatePath().'/'.$filename, true);
                    break;
                case ('AppForAndroid'):
                    Url::redirect('https://play.google.com/store/apps/details?id=com.parablu.app', true);
                    exit;
                case ('AppForWindows'):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Application for Windows is not yet supported'
                    );
                    echo json_encode($result);
                    break;
                case ('AppForMac'):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Application for Mac is not yet supported'
                    );
                    echo json_encode($result);
                    break;
                default:
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Selected app type is not yet supported'
                    );
                    echo json_encode($result);
                    exit();
            }
        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData')
                )
            );
        }
    }

    public function cloudInfo(){
        Auth::allowOnly('readOnlyAdmin');
        $headers = array(
            'Content-type' => 'application/xml',
            'Accept' => 'application/xml',
            'Accept-Charset' => 'utf-8',
            'token' => $this->session->get('token'),
            'cloudParams' => 'home,users,devices,myclouds,syncUsers,backupUsers,size'
        );
        $cloudDetails = $this->_model->getCloudInfo($headers);
        $this->log('Cloud Details: '. json_encode($cloudDetails), 'info');
        if($cloudDetails['status'] == 200){
            $cloudDetails['body']->{'license'}->{'max-storage'} = round(($cloudDetails['body']->{'license'}->{'max-storage'}) / 1024, 2);
            $cloudDetails['body']->{'space-used'} = round((((int)$cloudDetails['body']->{'space-used'})/1024)/1024, 2);
        }else{
            $cloudDetails['body'] = '';
        }
        $data = array(
            'title' => $this->language->get('cloud_information'),
            'crumb1' => $this->language->get('everythingAboutYourCloud'),
            'active' => 'home',
            'csrf_token' => $this->setCSRFToken(),
            'cloudDetails' => $cloudDetails['body'],
            'loggedInUser' => $this->session->all()
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('mechanic/cloudInfo', $data);
        View::renderTemplate('footer', $data);
    }

    public function readExcelFromUpload(){
        if (empty($_FILES)) {
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
        $targetPath = 'app/templates/default/documents';
        $nameMD5 = md5($this->session->get('userName'));
        $targetFile =  $targetPath.DS.$nameMD5;
        if(file_exists($targetFile)){
            unlink($targetFile);
        }
        if(move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)){
            header('HTTP/1.1 200 uploaded');
            header('Content-Type: application/json; charset=UTF-8');
            $paraView = new ParaViewController();
            $value = $paraView->readFileFromUpload($nameMD5);
            $sheets = json_decode($value);
            $someValue = '';
            if($sheets->result == 'success'){
                $userNames = [];
                foreach($sheets->{'data'} as $sheet){
                    unset($sheet->{'userNames'}[count($sheet->{'userNames'}) - 1]);
                    foreach($sheet->{'userNames'} as $userName){
                        $userNames = array_merge(array($userName), $userNames);
                    }
                }
                $result = array(
                    'result' => 'success',
                    'asdas' => $someValue,
                    'userNames' => array_values($userNames)
                );
                die(json_encode($result));
            }else{
                die(json_encode(array('msg' => $sheets->msg, 'code' => 500)));
            }
        }else{
            die(json_encode(array('msg' => 'ERROR while reading the selected file', 'code' => 500)));
        }
    }

    public function setSessionForRedirect(){
        if(!empty($_POST)){
            foreach($_POST as $key => $value){
                $this->session->put($key, $value);
            }
            echo json_encode(array('result' => 'success', 'msg' => 'Send him through'));
            exit;
        }else{
            echo json_encode(array('result' => 'success', 'msg' => 'Send him through'));
            exit;
        }
    }

    public function getBestBlukrypt(){
        if(empty($_POST['blukrypts'])){
            echo json_encode(array('result' => 'fail', 'msg' => 'Blukrypts has not been configured'));
            exit;
        }
        $result = [];
        $time = 0;
        foreach ($_POST['blukrypts'] as $value) {
            $startTime = microtime(true);
            $file = @fsockopen($value['gatewayName'], 80, $errno, $errstr, 10);
            $stopTime = microtime(true);

            if (!$file) {
                $result = array('result' => 'fail', 'msg' => 'Cloud not connect to blukrypt server');  // Site is down
            } else {
                fclose($file);
                $status = ($stopTime - $startTime) * 1000;
                $status = floor($status);
                if($time == 0){
                    $result = array('result' => 'success', 'bestBlukrypt' => $value['gatewayName']);
                    $time = $status;
                }else{
                    $result = array('result' => 'success', 'bestBlukrypt' => $value['gatewayName']);
                }
            }
        }

        echo json_encode($result);
        exit;
    }



}
