<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><a href="<?=Url::basePath('users')?>"><h3><?=$data['title']?></h3></a></li>
                <li><span>Block or Unblock or Delete users in bulk</span></li>
            </ol>
        </div>
        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11" block-ui="myBlockUI">
            <span class="hide csrf_token"><?=$data['csrf_token']?></span>
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('Block Multiple Users', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group hide">
                        <label for="userNames"><?=Language::show('userNames', 'keywords');?></label><br/>
                        <!--<select class="blockUserNames" name="blockUserNames[]" style="width: 100%;" id="userNames" multiple="multiple" required></select>-->
                        <input type="text" data-role="tagsinput" value="" class="form-control blockUserNames" name="blockUserNames[]" id="blockUserNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userId', 'keywords');?>" required autocomplete="off" style="display: none;">
                    </div>
                    <div class="form-group">
                        <a ng-click="blockUnBlockMultipleUsers(false)" class="block btn btn-danger" disabled><i class="fa fa-lock"></i> Block</a>
                        <!--<a ng-click="vusers()" class="block btn btn-danger"><i class="fa fa-save"></i> Block</a>-->
                        <!--<a ng-click="blockUnBlockMultipleUsers(true)" class="unblock btn btn-success"><i class="fa fa-save"></i> UnBlock</a>-->
                        <!--<a ng-click="deleteMultipleUsers()" class="delete btn btn-danger"><i class="fa fa-save"></i> Delete</a>-->
                        <a href="javascript:;" class="btn btn-default" ngf-select="readUserNamesFromExcel($files)"><i class="share-icon fa fa-upload"> Import User ID's from Excel</i></a>
                        <a class="btn btn-default" href="<?=Url::basePath('users')?>"><i class="fa fa-times"></i> Cancel</a>
                    </div>
                    <div class="row blockusers" style="display: none;">
                
                    <div class="panel-heading">
                        <h3>
                            Block Users -
                            <!--<span id="selected_users" style="color: #f55753;font-size: 0.9em;"></span>
                            <a ng-click="startMigrating()" class="btn btn-success btn-small pull-right">Start Migrating Users</a>
                            <button id="selected" class="btn button-default">GetSelected</button>-->
                        </h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th class="active">
                                        <input type="checkbox" class="select-all checkbox" name="select-all" checked/>
                                    <th><?=Language::show('username', 'keywords')?></th>
                                    <th><?=Language::show('email_address', 'keywords')?></th>
                                    <th><?=Language::show('Last Modified Time', 'keywords')?></th>
                                    <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in userList track by $index">
                                    <td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]">
                                        <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.userName }}" ng-checked="value.status == 'ACTIVE'" ng-disabled="value.status == 'BLOCKED' || value.status == 'DELETED'"/>
                                    </td>
                                    <td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{ value.userName }}</td>
                                    <td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{ value.emailId }}</td>
                                    <td ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>{{value.time}}</td>
                                    <td class="text-center" ng-class="{DELETED:'invalid', BLOCKED: 'invalid'}[value.status]" ng-cloak>
                                        <h5><label class="label label-success" ng-if="value.status == 'ACTIVE'"><?=Language::show('active', 'keywords')?></label></h5>
                                        <h5><label class="label label-danger" ng-if="value.status == 'BLOCKED'"><?=Language::show('blocked', 'keywords')?></label></h5>
                                        <h5><label class="label label-danger" ng-if="value.status == 'DELETED'"><?=Language::show('deleted', 'keywords')?></label></h5>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                
            </div>
                </div>
            </div>
            
            
            
            
            
            
            
            
            
            
            
            
            
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('Delete/Unblock Multiple Users', 'keywords')?></h4>
                </div>
                <div class="panel-body">
                    <div class="form-group hide">
                        <label for="userNames"><?=Language::show('userNames', 'keywords');?></label><br/>
                        <!--<select class="deleteUserNames" name="deleteUserNames[]" style="width: 100%;" id="userNames" multiple="multiple" required></select>-->
                        <input type="text" data-role="tagsinput" value="" class="form-control deleteUserNames" name="deleteUserNames[]" id="deleteUserNames" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('userId', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <a ng-click="blockUnBlockMultipleUsers(true)" class="unblock btn btn-success" disabled><i class="fa fa-unlock"></i> UnBlock</a>
                        <a ng-click="deleteMultipleUsers()" class="delete btn btn-danger" disabled><i class="fa fa-trash"></i> Delete</a>
                        <a href="javascript:;" class="btn btn-default" ngf-select="readUserNamesFromExcel1($files)"><i class="share-icon fa fa-upload"> Import User ID's from Excel</i></a>
                        <a class="btn btn-default" href="<?=Url::basePath('users')?>"><i class="fa fa-times"></i> Cancel</a>
                    </div>
                    <div class="row unblockdeleteusers" style="display: none;">
                
                    <div class="panel-heading">
                        <h3>
                            Unblock/Delete Users -
                            <!--<span id="selected_users" style="color: #f55753;font-size: 0.9em;"></span>
                            <a ng-click="startMigrating()" class="btn btn-success btn-small pull-right">Start Migrating Users</a>
                            <button id="selected" class="btn button-default">GetSelected</button>-->
                        </h3>
                    </div>
                    <div class="panel-body">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" class="select-all checkbox" name="select-all" checked/>
                                    </th>
                                    <th><?=Language::show('username', 'keywords')?></th>
                                    <th><?=Language::show('email_address', 'keywords')?></th>
                                    <th><?=Language::show('Last Modified Time', 'keywords')?></th>
                                    <th class="text-center"><?=Language::show('status', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in userUnblockList track by $index">
                                    <td ng-class="{ACTIVE:'invalid',DELETED:'invalid'}[value.status]">
                                        <input type="checkbox" class="select-item checkbox" name="select-item" value="{{ value.userName }}" ng-checked="value.status == 'BLOCKED'" ng-disabled="value.status == 'ACTIVE' || value.status == 'DELETED'"/>
                                    </td>
                                    <td ng-class="{ACTIVE:'invalid',DELETED:'invalid'}[value.status]" ng-cloak>{{ value.userName }}</td>
                                    <td ng-class="{ACTIVE:'invalid',DELETED:'invalid'}[value.status]" ng-cloak>{{ value.emailId }}</td>
                                    <td ng-class="{ACTIVE:'invalid',DELETED:'invalid'}[value.status]" ng-cloak>{{value.time}}</td>
                                    <td ng-class="{ACTIVE:'invalid',DELETED:'invalid'}[value.status]" class="text-center" ng-cloak>
                                        <h5><label class="label label-success" ng-if="value.status == 'ACTIVE'"><?=Language::show('active', 'keywords')?></label></h5>
                                        <h5><label class="label label-danger" ng-if="value.status == 'BLOCKED'"><?=Language::show('blocked', 'keywords')?></label></h5>
                                        <h5><label class="label label-danger" ng-if="value.status == 'DELETED'"><?=Language::show('deleted', 'keywords')?></label></h5>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    
                  </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
   /* $(".deleteUserNames").select2({
        ajax: {
            url: "<?=DIR?>"+"user/getAllBlockedUsers",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data.users);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    $(".blockUserNames").select2({
        ajax: {
            url: "<?=DIR?>"+"user/getAllUnBlockedUsers",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.assignSaveBtn').removeAttr('disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }*/
</script>
<script>
    $(function(){

        //button select all or cancel
        $("#select-all").click(function () {
            var all = $("input.select-all")[0];
            all.checked = !all.checked;
            var checked = all.checked;
            $("input.select-item").each(function (index,item) {
                item.checked = checked;
            });
        });

        //button select invert
        $("#select-invert").click(function () {
            $("input.select-item").each(function (index,item) {
                item.checked = !item.checked;
            });
            checkSelected();
        });

        //button get selected info
        $("#selected").click(function () {
            var items=[];
            $("input.select-item:checked:checked").each(function (index,item) {
                items[index] = item.value;
            });
            if (items.length < 1) {
                //document.getElementById("selected_users").innerHTML = "";
            }else {
                var values = items.join();
                console.log("items"+items);
                console.log(values);
                //var html = $("<div></div>");
                //document.getElementById("selected_users").innerHTML = arr;
                //html.html("selected:"+values);
                //html.appendTo("body");
            }
        });

        //column checkbox select all or cancel
        $("input.select-all").click(function () {
            var checked = this.checked;
            $("input.select-item").each(function (index,item) {
                if(!$(this).is('[disabled=disabled]')){
                item.checked = checked;
                }
            });
        });

        //check selected items
        $("input.select-item").click(function () {
            var checked = this.checked;
            console.log(checked);
            checkSelected();
        });

        //check is all selected
        function checkSelected() {
            var all = $("input.select-all")[0];
            var total = $("input.select-item").length;
            var len = $("input.select-item:checked:checked").length;
            console.log("total:"+total);
            console.log("len:"+len);
            all.checked = len===total;
        }
    });
</script>
<style>
    .invalid{
        background-color: gainsboro !important;
        cursor:not-allowed !important;
    }
</style>
