<?php
use \Core\View;
use Helpers\Form;
use Helpers\Url;
use Core\Language;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=Language::show('manageMiniClouds', 'keywords')?></h3></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SyncController">
    <span class="hide currentPage"><?='miniClouds'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10" block-ui="myBlockUI">
            <div class="panel">
                
                <div class="panel-heading">
                    <h4><?=Language::show('manageMiniClouds', 'keywords')?>
                    <?php if(Auth::checkUserPermission('admin')) {?>
                    <span class="pull-right">
                    <a class="btn btn-success btn-small" href="" class="share-button" data-toggle="modal" data-target="#createMiniCloud"><?=Language::show('createMiniCloud', 'keywords');?></a>
                    </span>
                      <?php } ?>
                    </h4>
                </div>
 <?php if(!empty($data['miniClouds'])){ ?>               
                <div class="panel-body">
                <div class="table-responsive">
                  <table class="table table-bordered table-striped supportLogTable" >
                            <colgroup>
                                <col class="col-xs-2">
                                <col class="col-xs-2">
                                <col class="col-xs-4">
                    
                            </colgroup>
                            <thead>
                            <tr>
                                <th><?=Language::show('miniCloudName', 'keywords')?></th>
                                <th><?=Language::show('owner', 'keywords')?></th>
                                <th><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                <?php foreach($data['miniClouds'] as $key => $value){ ?>
                <tr>
                             
                                 <td><?=$value->{'mini-cloud-name'}?></td>
                                 <td><?=$value->{'owner'}?></td>
                                
                                 <td ng-cloak class="text-left">
                                    <span>
                                            <?php if($data['loggedInUser']['admin'] == true){ ?>
                                                <a class="btn btn-default btn-small btn-danger deleteMiniCloudBtn<?=md5($value->{'mini-cloud-name'})?>"
                                                   ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Delete MiniCloud : <?=$value->{'mini-cloud-name'}?></h4><hr></div><?=Language::show('miniCloudDeleteConfirm', 'keywords')?>"
                                                   ng-bootbox-confirm-action="deleteMiniCloudByAdmin('<?=$value->{'mini-cloud-name'}?>', 'admin')"
                                                   ng-bootbox-confirm-action-cancel=""
                                                   href="javascript:;"><i class="fa fa-trash"></i> Delete</a>
                                                <a class="btn btn-default btn-small btn-success" onclick="addCurrentOwner('<?=md5($value->{'mini-cloud-name'})?>')" ng-click="loadChangeOwnerShipModal('<?=$value->{'mini-cloud-name'}?>')">Change Ownership</a>
                                            <?php } ?>
                                            <?php if($value->{'owner'} == $data['loggedInUser']['userName']){ ?>
                                                <a class="btn btn-small btn-success" onclick="addAssignUsers('<?=md5($value->{'mini-cloud-name'})?>')" ng-click="loadAssignUsersModal('<?=$value->{'mini-cloud-name'}?>')">Add Users</a>
                                            <?php } ?>
                                            <span class="hide ownerFor<?=md5($value->{'mini-cloud-name'})?>"><?=$value->{'owner'}?></span>
                                            <span class="hide attachedUsersFor<?=md5($value->{'mini-cloud-name'})?>"><?=$value->{'assigned-users'}?></span>
                                 </span>     
                                 </td>
                                 </tr>
<?php } ?>     
                            </tbody>
                        </table>
                    </div>
            </div>
<?php } else {?>
<h3 class="text-center">There are no MiniClouds</h3>
<?php }?>

          </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>

    <div class="modal fade" id="ownerShipChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'ownerShipForm',
                'autocomplete' => 'off',
                'ng-submit' => 'changeOwnerForMiniCloud()',
                'data-parsley-validate' => true
            ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Change MiniCloud Ownership</h4>
                </div>
                <div class="modal-body">
                    <p class="modal-title">Assign a new owner to manage the selected mini cloud</p>
                    <div class="form-group hide">
                        <label for="ownerShipMiniCloud"></label>
                        <input name="miniCloudName" id="ownerShipMiniCloud" type="text"/>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="form-control ownerShipChange" style="width: 100%;" name="owner" id="selectOwnerShip" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary changeOwnerSaveBtn" disabled>Save</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
    <div class="modal fade" id="assignUsers" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'assignUsersForMiniCloud',
                'autocomplete' => 'off',
                'ng-submit' => 'assignUsersForMiniCloud()',
                'data-parsley-validate' => true
            ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Add Users</h4>
                </div>
                <div class="modal-body">
                    <p class="modal-title">Assign users selected  for mini cloud</p>
                    <div class="form-group hide">
                        <label for="assignUsersMiniCloud"></label>
                        <input name="miniCloudName" id="assignUsersMiniCloud" type="text" value="" required/>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="assignUsers" name="userNames[]" style="width: 100%;" id="selectAssignUsers" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary assignSaveBtn">Save</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
</div><!-- /.container -->
<div id="createMiniCloud" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content mediumModal">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Create MiniCloud</h4>
            </div>
            <div class="modal-body">
                    <form class="row form-inline" ng-submit="createMiniCloud(miniCloudName)">
                        <div class="modal-title">
                            <label class="sr-only" for="miniCloudName">Enter MiniCloud Name</label>
                            <input type="text" style="width: 100%;" ng-model="miniCloudName" class="form-control" name="miniCloudName" id="miniCloudName" placeholder="Enter MiniCloud Name">
                        </div>
           
                        <div class="modal-footer ">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-default btn-primary" >Create</button>
                        </div>
                    </form>
                    </div>
                <span class="createMiniCloudError"></span>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    var owner = $(".ownerShipChange").select2({
        maximumSelectionLength: 1,
        ajax: {
            url: "<?=DIR?>"+"user/getAllUnBlockedUsersWithLoggedInUser",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.changeOwnerSaveBtn').removeAttr('disabled', 'disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select a Owner'
    });

    function addCurrentOwner(selectedMiniCloudName) {
        owner.val(null).trigger("change");
        var miniClouds = $('.ownerFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectOwnerShip').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#ownerShipChange').modal('show');
       // owner.val(miniClouds).trigger("change");
    }

    var assignUsers = $(".assignUsers").select2({
        ajax: {
            url: "<?=DIR?>"+"userGroups/getAllUnBlockedUsersWithGroups",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term,
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; },
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select users'
    });

    function addAssignUsers(selectedMiniCloudName) {
        assignUsers.val(null).trigger("change");
        var miniClouds = $('.attachedUsersFor' + selectedMiniCloudName).html().split(',');
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                $('#selectAssignUsers').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="miniCloudName"]').val(selectedMiniCloudName);
        $('#assignUsers').modal('show');
        assignUsers.val(miniClouds).trigger("change");
    }

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }

    $('#ownerShipChange').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });

    $('#assignUsers').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });

</script>
<style>
    .select2-results__option[aria-selected=true] {
    display: none;
}
</style>
