<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?=$data['crumb1']?></span>
            <div class="row">
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#ssl" aria-controls="ssl" role="tab" data-toggle="tab">SSL Configuration</a></li>
                    <li role="presentation"><a href="#encryption" aria-controls="encryption" role="tab" data-toggle="tab">Encryption Configuration</a></li>
                </ul>
                <!-- Tab panes -->
                <div class="tab-content">
                    <div role="tabpanel" class="tab-pane active" id="ssl">
                        <div class="panel">
                            <div class="panel-heading">
                                <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('sSLConfiguration', 'keywords')?></h4>
                            </div>
                            <div class="panel-body">
                                <form class="SSLConfiguration" data-parsley-validate enctype="multipart/form-data">
                                    <ul class="list-group col-lg-12">
					<li class="list-group-item" style="height: 60px;"><?=Language::show('serverName', 'settings')?> <a href="#" data-toggle="tooltip" data-placement="right" title="<?=Language::show('serverNameExample', 'settings')?>"><i class="fa fa-question-circle star" aria-hidden="true"></i></a><input type="text" class="pull-right" name="serverName" id="serverName" style="width:25%;" value="" placeholder="Enter Server Name" required autocomplete="off"></li>
                                        <li class="list-group-item"><?=Language::show('sSLCertificateFile', 'settings')?> <a href="#" data-toggle="tooltip" data-placement="right" title="<?=Language::show('certificateFile', 'settings')?>"><i class="fa fa-question-circle star" aria-hidden="true"></i></a><input type="file" class="pull-right" name="mainCRTFile" id="mainCRTFile" required autocomplete="off"></li>
                                        <li class="list-group-item"><?=Language::show('sSLCertificateChainFile', 'settings')?> <a href="#" data-toggle="tooltip" data-placement="right" title="<?=Language::show('chainFile', 'settings')?>"><i class="fa fa-question-circle star" aria-hidden="true"></i></a><input type="file" class="pull-right" name="mainCRTFile" id="mainCRTFile" required autocomplete="off"></li>
                                        <li class="list-group-item"><?=Language::show('sSLCertificateKeyFile', 'settings')?> <a href="#" data-toggle="tooltip" data-placement="right" title="<?=Language::show('keyFile', 'settings')?>"><i class="fa fa-question-circle star" aria-hidden="true"></i></a><input type="file" class="pull-right" name="keyFile" id="keyFile" required autocomplete="off"></li>
                                    </ul>
                                    <div class="form-group col-lg-12 hide">
                                        <label for="mainCRTFile">Main Crt File</label>
                                        <input type="file" class="form-control" name="mainCRTFile" id="mainCRTFile" accept=".crt" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- files with an extension of .crt can only be uploaded.</span>
                                    </div>
                                    <div class="form-group col-lg-12 hide">
                                        <label for="chainCRTFile">Chain CRT File</label>
                                        <input type="file" class="form-control" name="chainCRTFile" id="chainCRTFile" accept=".crt" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- files with an extension of .crt can only be uploaded.</span>
                                    </div>
                                    <div class="form-group col-lg-12 hide">
                                        <label for="keyFile">Key File</label>
                                        <input type="file" class="form-control" name="keyFile" id="keyFile" accept=".key" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- files with an extension of .key can only be uploaded.</span>
                                    </div>
                                    <div class="form-group col-lg-12 hide">
                                        <label for="serverName">Server Name</label>
                                        <input type="text" class="form-control" name="serverName" id="serverName" value="" placeholder="Enter Server Name" required autocomplete="off">
                                        <span class="help-line text-muted">Example:- www.parablu.com</span>
                                        <br/>
                                        <button type="submit" class="btn btn-success pull-right">Save</button>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <button type="submit" class="btn btn-success pull-right">Save</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div role="tabpanel" class="tab-pane" id="encryption">
                        <div class="panel">
                            <div class="panel-heading">
                                <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('encryptionConfiguration', 'keywords')?><span class="pull-right"><a class="btn btn-success btn-small" href="" data-toggle="modal" data-target="#addEncryptionConfig"><?=Language::show('addEncryption', 'keywords');?></a></span></h4>
                            </div>
                            <div class="panel-body">
                                <div class="row nokeys">
                                    <div class="col-lg-12">
                                        <h2 align="center">No Encryption Configuration found</h2>
                                    </div>
                                </div>
                                <!-- table start-->
                                <div class="table-responsive keychart hide">
                                    <div class="h4 loading text-center hide">Loading.....</div>
                                    <table class="table table-bordered table-striped deviceListTable">
                                        <thead>
                                        <tr>
                                            <th class="text-center">Product Type</th>
                                            <th class="text-center">Salt key</th>
                                            <th class="text-center">Modified by</th>
                                            <th class="text-center">Modified time</th>
                                            
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr class=ng-scope" ng-repeat="value in keys track by $index" ng-if="value.endTimestamp == 0">
                                            <td class="text-center" ng-if="value.productType == 'backup'">BluVault For End Point</td>
                                            <td class="text-center" ng-if="value.productType == 'serverBackup'">BluVault For Servers</td>
                                            <td class="text-center" ng-if="value.productType == 'sync'">BluSync - EFSS</td>
                                            <td class="text-center">##############</td>
                                            <td class="text-center">{{value.userName}}</td>
                                            <td class="text-center">{{value.startTime}}</td>
                                            
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <!-- table ends-->
                                <div class="modal fade" id="addEncryptionConfig" tabindex="-1" role="dialog">
                                    <div class="modal-dialog">
                                        <div class="modal-content mediumModal">
                                            <form class="encryptionConfiguration" ng-submit="saveEncryptionConfiguration()" data-parsley-validate>
                                                <div class="modal-header">
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                                    <h4 class="modal-title"><?=Language::show('addYourEncryptionConfiguration', 'settings')?></h4>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="form-group col-lg-12">
                                                            <label for="productType">Select a Product Type</label>
                                                            <select class="form-control" name="productType" id="productType" required>
                                                                <option value="backup"><?=Language::show('bluVaultForEndPoint', 'settings')?></option>
                                                                <option value="serverBackup"><?=Language::show('bluVaultForServers', 'settings')?></option>
                                                                <option value="sync"><?=Language::show('bluSyncEFSS', 'settings')?></option>
                                                            </select>
                                                        </div>
                                                        <div class="form-group col-lg-12">
                                                            <label for="saltKey"><?=Language::show('saltkey', 'settings')?></label>
                                                            <a href="#" data-toggle="tooltip" data-placement="right" title="<?=Language::show('partEncryptionkey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                            <input type="text" class="form-control" name="saltKey" id="saltKey" value="" placeholder="Enter your Salt key" required autocomplete="off">
                                                        </div>
                                                        </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="saveEncSetting btn btn-success"><?=Language::show('save', 'keywords')?></button>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>

