<?php

use \Core\View;
use \Helpers\Url;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?></h4>
                    </div>
                    <div class="panel-body">
                        <form class="smtpConfiguration" ng-submit="saveSmtpConfiguration()" data-parsley-validate>
                            <div class="form-group col-lg-6">
                                <label for="smtpHost">SMTP Host</label>
                                <input type="text" class="form-control" name="smtpHost" id="smtpHost" value="<?=$data['smtpHost']?>" placeholder="Enter SMTP Host" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="sslPort">SSL Port</label>
                                <input type="number" class="form-control" name="sslPort" id="sslPort" value="<?=$data['sslPort']?>" placeholder="Enter SSL Port" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="factoryClass">SSL Factory Class</label>
                                <input type="text" class="form-control" name="factoryClass" id="factoryClass" value="<?=$data['sslFactoryClass']?>" placeholder="Enter SSL Factory Class" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpPort">SMTP Port</label>
                                <input type="number" class="form-control" name="smtpPort" id="smtpPort" value="<?=$data['smtpPort']?>" placeholder="Enter SMTP Port" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label class="col-lg-4" for="smtpAuth">SMTPP Auth</label>
                                         <input class="col-lg-2 form-control" type="checkbox" name="smtpAuth" id="smtpAuth" value="true" <?php if($data["smtpAuth"] == 'true'){echo "checked";}?> data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </div>
    
                            <div class="form-group col-lg-6">
                                <label class="col-lg-4" for="smtpStarttlsEnable">SMTP Start TLS Enable</label>
                                         <input class="col-lg-2 form-control" type="checkbox" name="smtpStarttlsEnable" id="smtpStarttlsEnable" value="true" <?php if($data["smtpStarttlsEnable"] == true){echo "checked";}?> data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </div>
                            <div class="form-group col-lg-6">
                                <label class="col-lg-4" for="smtpSSLEnable">SMTP SSL Enable</label>
                                         <input class="col-lg-2 form-control" type="checkbox" name="smtpSSLEnable" id="smtpSSLEnable" value="true" <?php if($data["smtpSSLEnable"] == true){echo "checked";}?> data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </div>
                            <div class="form-group col-lg-6">
                                <label class="col-lg-4" for="enableEmail">Enable Email</label>
                                         <input class="col-lg-2 form-control" type="checkbox" name="enableEmail" id="enableEmail" value="true" <?php if($data["enableEmail"] == true){echo "checked";}?> data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpUname">SMTP Username</label>
                                <input type="text" class="form-control" name="smtpUname" id="smtpUname" value="<?=$data['smtpUserName']?>" placeholder="Enter SMTP Username" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="smtpPwd">SMTP Password</label>
                                <input type="password" class="form-control" name="smtpPwd" id="smtpPwd" value="<?=$data['smtpPwd']?>" placeholder="Enter SMTP Password" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="email">Email ID</label>
                                <input type="email" class="form-control" name="email" id="email" value="<?=$data['fromEmail']?>" placeholder="Enter your Email ID" required autocomplete="off">
                            </div>
                            
                            <div class="form-group col-lg-6">
                                <button type="submit" class="btn saveSMTP btn-success pull-right">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
