<?php

use \Core\View;
use \Helpers\Url;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Encryption Settings</h4>
                    </div>
                    <div class="panel-body">
                        <form class="encryptionConfiguration" ng-submit="saveEncryptionConfiguration()" data-parsley-validate>
                            <div class="form-group col-lg-12">
                                <label for="productType">Select a Product Type</label>
                                <select class="form-control" name="productType" id="productType" required>
                                    <option value="backup">BluVault For End Point</option>
                                    <option value="serverBackup">BluVault For Servers</option>
                                    <option value="sync">BluSync - EFSS</option>
                                </select>
                            </div>
                            <div class="form-group col-lg-12">
                                <label for="saltKey">Salt key</label>
                                <input type="text" class="form-control" name="saltKey" id="saltKey" value="" placeholder="Enter your Salt key" required autocomplete="off">
                                <span class="help-line text-muted">Note:- This will be a part of the Encryption key</span>
                            </div>
                            <br/>
                            <button type="submit" class="saveEncSetting btn btn-success pull-right">Save Settings</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
