<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=Language::show('cloudSettings', 'keywords');?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">Cloud Settings Tools</h4>
                    </div>
                    <div class="panel-body">
                        <div class="col-lg-4 hide">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('manageCloud', 'keywords');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/cloudCredentials')">
                                <div class="background">
                                    <i class="fa fa-cloud"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                  <i class="fa fa-cloud"> Cloud Credentials</i>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-4">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('manageParacloudBlukrypt', 'keywords');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/paracloudblukrypt')">
                                <div class="background">
                                    <i class="fa fa-cubes"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-cubes"> Paracloud, Blukrypt</i><br/>
                                </div>
                            </div>
                            </a>
                        </div>
                        <?php if(BLUKRYPT_PAGE == true){ ?>
                            <div class="col-lg-4 hide">
                                <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/blukrypt')">
                                    <div class="background">
                                        <i class="fa fa-key"></i>
                                    </div>
                                    <div class="panel-body widget widget-body">
                                        <i class="fa fa-key"> Blukrypt</i><br/>
                                        <a>Blukrypt Settings</a>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/networkThrottling')">
                                <div class="background">
                                    <i class="fa fa-crop"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-crop"> Network Throttling</i><br/>
                                    <a>Network Throttling Settings</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('manageActiveDirectory', 'keywords');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/adCredentials')">
                                <div class="background">
                                    <i class="fa fa-language"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-language"> Active Directory Credentials</i><br>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/email')">
                                <div class="background">
                                    <i class="fa fa-envelope"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-envelope"> Email Configuration</i><br>
                                    <a>Change, Edit default Email Configuration</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('manageProxy', 'keywords');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/proxy')">
                                <div class="background">
                                    <i class="fa fa-sign-in"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-sign-in"> Proxy Settings</i>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/connector')">
                                <div class="background">
                                    <i class="fa fa-code-fork"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-code-fork"> Connector Settings</i><br>
                                    <a>External Storage Configuration</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/domain')">
                                <div class="background">
                                    <i class="fa fa-globe"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-globe"> Domain / Host Name</i><br>
                                    <a>Change your default Domain or Host Name</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('manageSSLEncryption', 'keywords');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/sslAndEncryption')">
                                <div class="background">
                                    <i class="fa fa-cloud-upload"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-cloud-upload"> SSL and Encryption Settings</i>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/encryption')">
                                <div class="background">
                                    <i class="fa fa-key"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-key"> Encryption Settings</i><br>
                                    <a>Change your Encryption Key</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/local')">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"> Local Storage Settings</i><br>
                                    <a>Change your Local File Server Settings</a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('manageSmtp', 'keywords');?>">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/smtp')">
                                <div class="background">
                                    <i class="fa fa-envelope"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-envelope"> SMTP Settings</i><br>
                                </div>
                            </div>
                            </a>
                        </div>
                        <div class="col-lg-4 hide">
                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('settings/cloudProperties')">
                                <div class="background">
                                    <i class="fa fa-hdd-o"></i>
                                </div>
                                <div class="panel-body widget widget-body">
                                    <i class="fa fa-hdd-o"> PI Settings</i><br>
                                    <a>Change your Parablu Installation Settings</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>