<?php

use \Core\View;
use \Helpers\Url;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date 7/10/15
 * @time 11:55 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='dashboard'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=$data['crumb1']?></h4>
                    </div>

                    <div class="panel-body">
                        <form class="cloudConfiguration" ng-submit="saveCloudConfiguration()" data-parsley-validate>
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs" role="tablist">
                                <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                                <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                            </ul>

                            <!-- Tab panes -->
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane active" id="general">
                                    </br>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="blusyncDownloadPath">BluSync Download Path</label>
                                        <input type="text" class="form-control" name="blusyncDownloadPath" id="blusyncDownloadPath" value="<?=$data['blusyncDownloadPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="mntParacloudPath">Mnt Paracloud Path</label>
                                        <input type="text" class="form-control" name="mntParacloudPath" id="mntParacloudPath" value="<?=$data['mntParacloudPath']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudScriptsFolder">Parablu Installation Script Folder</label>
                                        <input type="text" class="form-control" name="cloudScriptsFolder" id="cloudScriptsFolder" value="<?=$data['cloudScriptsFolder']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsBinDir">Scripts Bin Directory</label>
                                        <input type="text" class="form-control" name="scriptsBinDir" id="scriptsBinDir" value="<?=$data['scriptsBinDir']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsVideoThumbnail">Scripts Video Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsVideoThumbnail" id="scriptsVideoThumbnail" value="<?=$data['scriptsVideoThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="scriptsGeneralThumbnail">Scripts General Thumbnail</label>
                                        <input type="text" class="form-control" name="scriptsGeneralThumbnail" id="scriptsGeneralThumbnail" value="<?=$data['scriptsGeneralThumbnail']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudFileName">Parablu Installation File Name</label>
                                        <input type="text" class="form-control" name="cloudFileName" id="cloudFileName" value="<?=$data['cloudFileName']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="cloudType">Parablu Installation Type</label>
                                        <input type="text" class="form-control" name="cloudType" id="cloudType" value="<?=$data['cloudType']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="solrUrl">Solr URL</label>
                                        <input type="text" class="form-control" name="solrUrl" id="solrUrl" value="<?=$data['solrUrl']?>" placeholder="Enter Solr URL" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="supportMail">Support Mail</label>
                                        <input type="email" class="form-control" name="supportMail" id="supportMail" value="<?=$data['supportMail']?>" placeholder="Enter Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="emailToAdminOnly">Emails To Admin Only</label>
                                        <select class="form-control emailToAdminOnly selectpicker" name="emailToAdminOnly" id="emailToAdminOnly" >
                                            <option value="true" <?php if($data["emailToAdminOnly"] == true){echo "selected";}?>>True</option>
                                            <option value="false" <?php if($data["emailToAdminOnly"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="canAdminRestoreAll">Can Admin Restore All</label>
                                        <select class="form-control canAdminRestoreAll selectpicker" name="canAdminRestoreAll" id="canAdminRestoreAll" >
                                             <option value="true" <?php if($data["canAdminRestoreAll"] == true){echo "selected";}?>>True</option>
                                             <option value="false" <?php if($data["canAdminRestoreAll"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <div class="form-group col-lg-6">
                                            <label for="defaultBkpPolicyName">Default Backup Policy Name</label>
                                            <input type="text" class="form-control" name="defaultBkpPolicyName" id="defaultBkpPolicyName" value="<?=$data['defaultBkpPolicyName']?>" placeholder="" required autocomplete="off">
                                        </div>
                                    <?php } ?>
                                    <?php if(\Helpers\Auth::checkCloudPermission('sync')){ ?>
                                        <div class="form-group col-lg-6">
                                            <label for="defaultSyncPolicyName">Default Sync Policy Name</label>
                                            <input type="text" class="form-control" name="defaultSyncPolicyName" id="defaultSyncPolicyName" value="<?=$data['defaultSyncPolicyName']?>" placeholder="" required autocomplete="off">
                                        </div>
                                    <?php } ?>
                                </div>
                                <div role="tabpanel" class="tab-pane" id="advanced">
                                    </br>
                                    <div class="form-group col-lg-6">
                                        <label for="azureVM">Azure VM</label>
                                        <select class="form-control azureVM selectpicker" name="azureVM" id="azureVM" >
                                            <option value="false" <?php if($data["azureVM"] == false){echo "selected";}?>>False</option>
                                            <option value="true" <?php if($data["azureVM"] == true){echo "selected";}?>>True</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="localAD">Local AD</label>
                                        <select class="form-control localAD selectpicker" name="localAD" id="localAD" >
                                            <option value="true" <?php if($data["localAD"] == true){echo "selected";}?>>True</option>
                                            <option value="false" <?php if($data["localAD"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="sslAuthEnabled">SSl Auth Enabled</label>
                                        <select class="form-control sslAuthEnabled selectpicker" name="sslAuthEnabled" id="sslAuthEnabled" >
                                            <option value="false" <?php if($data["sslAuthEnabled"] == false){echo "selected";}?>>False</option>
                                            <option value="true" <?php if($data["sslAuthEnabled"] == true){echo "selected";}?>>True</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="reportRows">Report Rows</label>
                                        <input type="number" class="form-control" name="reportRows" id="reportRows" value="<?=$data['reportRows']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="isCrawlEnabled">Is Crawl Enabled</label>
                                        <select class="form-control isCrawlEnabled selectpicker" name="isCrawlEnabled" id="isCrawlEnabled" >
                                            <option value="false" <?php if($data["isCrawlEnabled"] == false){echo "selected";}?>>False</option>
                                            <option value="true" <?php if($data["isCrawlEnabled"] == true){echo "selected";}?>>True</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="isShareFileNameEnabled">Is Share File Name Enabled</label>
                                        <select class="form-control isShareFileNameEnabled selectpicker" name="isShareFileNameEnabled" id="isShareFileNameEnabled" >
                                            <option value="true" <?php if($data["canAdminRestoreAll"] == true){echo "selected";}?>>True</option>
                                            <option value="false" <?php if($data["canAdminRestoreAll"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="maxCrawlHit">Maximum Crawl Hit</label>
                                        <input type="number" class="form-control" name="maxCrawlHit" id="maxCrawlHit" value="<?=$data['maxCrawlHit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="noOfMultiADConfig">No. Of Multi AD Configuration</label>
                                        <input type="number" class="form-control" name="noOfMultiADConfig" id="noOfMultiADConfig" value="<?=$data['noOfMultiADConfig']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="mongoReadPreference">Mongo Read Preference</label>
                                        <select class="form-control mongoReadPreference selectpicker" name="mongoReadPreference" id="mongoReadPreference" >
                                            <option value="false" <?php if($data["mongoReadPreference"] == false){echo "selected";}?>>False</option>
                                            <option value="true" <?php if($data["mongoReadPreference"] == true){echo "selected";}?>>True</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="writeConcernLimit">Write Concern Limit</label>
                                        <input type="number" class="form-control" name="writeConcernLimit" id="writeConcernLimit" value="<?=$data['writeConcernLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 hide">
                                        <label for="ebmsWriteDelayLimit">EBMS Write Delay Limit</label>
                                        <input type="number" class="form-control" name="ebmsWriteDelayLimit" id="ebmsWriteDelayLimit" value="<?=$data['ebmsWriteDelayLimit']?>" placeholder="" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="emailBkpGroupName">Email Backup Group Name</label>
                                        <input type="text" class="form-control" name="emailBkpGroupName" id="emailBkpGroupName" value="<?=$data['emailBkpGroupName']?>" placeholder="Enter Email Backup Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="emailSyncGroupName">Email Sync Group Name</label>
                                        <input type="text" class="form-control" name="emailSyncGroupName" id="emailSyncGroupName" value="<?=$data['emailSyncGroupName']?>" placeholder="Enter Email Sync Group Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="bkpGroupEmail">Backup Group Email</label>
                                        <input type="email" class="form-control" name="bkpGroupEmail" id="bkpGroupEmail" value="<?=$data['bkpGroupEmail']?>" placeholder="Enter Backup group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="syncGroupEmail">Sync Group Email</label>
                                        <input type="email" class="form-control" name="syncGroupEmail" id="syncGroupEmail" value="<?=$data['syncGroupEmail']?>" placeholder="Enter Sync group Email ID" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="chunkUpdateMaxRetry">Maximum Retry for Chunk Update</label>
                                        <input type="number" class="form-control" name="chunkUpdateMaxRetry" id="chunkUpdateMaxRetry" value="<?=$data['chunkUpdateMaxRetry']?>" placeholder="Enter value" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientMailName">Client Mail Name</label>
                                        <input type="text" class="form-control" name="clientMailName" id="clientMailName" value="<?=$data['clientMailName']?>" placeholder="Enter client Mail Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientSupportMailName">Client Support Mail Name</label>
                                        <input type="email" class="form-control" name="clientSupportMailName" id="clientSupportMailName" value="<?=$data['clientSupportMailName']?>" placeholder="Enter client Support Mail Name" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="adGroupName">Enter AD Group Name</label>
                                        <input type="text" class="form-control" name="adGroupName" id="adGroupName" value="<?=$data['adGroupName']?>" placeholder="Enter AD Group Name" autocomplete="off">
                                    </div>

                                    <div class="form-group col-lg-6">
                                        <label for="adfsUrl">ADFS URL</label>
                                        <input type="text" class="form-control" name="adfsUrl" id="adfsUrl" value="<?=$data['adfsUrl']?>" placeholder="Enter ADFS URL" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="isDomainCheckEnabled">Is Domain Check Enabled</label>
                                        <select class="form-control isDomainCheckEnabled selectpicker" name="isDomainCheckEnabled" id="isDomainCheckEnabled" >
                                            <option value="true" <?php if($data["isDomainCheckEnabled"] == true){echo "selected";}?>>True</option>
                                            <option value="false" <?php if($data["isDomainCheckEnabled"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>
				    <div class="form-group col-lg-6">
                                        <label for="bulkEmailDelay">Bulk Email Delay (In Seconds)</label>
                                        <input type="text" class="form-control" name="bulkEmailDelay" id="bulkEmailDelay" value="<?=$data['bulkEmailDelay']?>" placeholder="Enter Bulk Email Delay" required autocomplete="off">
                                    </div>
		                    <div class="form-group col-lg-6">
                                        <label for="notifyForRestores">Notify Through Email For Restores</label>
                                        <select class="form-control notifyForRestores selectpicker" name="notifyForRestores" id="notifyForRestores" >
                                            <option value="true" <?php if($data["notifyForRestores"] == true){echo "selected";}?>>True</option>
                                            <option value="false" <?php if($data["notifyForRestores"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="notifyForBackup">Notify Through Email For First Backup Completion</label>
                                        <select class="form-control notifyForBackup selectpicker" name="notifyForBackup" id="notifyForBackup" >
                                            <option value="true" <?php if($data["notifyForBackup"] == true){echo "selected";}?>>True</option>
                                            <option value="false" <?php if($data["notifyForBackup"] == false){echo "selected";}?>>False</option>
                                        </select>
                                    </div>

                                </div>
                            </div>


                            <br/>
                            <div class="form-group col-lg-12">
                                <button type="submit" class="btn btn-success pull-left saveCloudProperties">Save</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>

