<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><li><?=Language::show('policyManagement', 'pms')?></a></h3></li>
                <li><?=Language::show('listOfClouds', 'keywords')?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='ccS'?></span>

            <div class="row">
                <?php //if(STORAGE_TYPE != "GOOGLE_DRIVE" && STORAGE_TYPE != "ONE_DRIVE"){ ?>
                <div class="modal fade createNewContainer" id="addCloudCredentials" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <?=
                            Form::open(array(
                                'ng-submit' => 'saveCloudCredentials(true)',
                                'class' => 'cloudCredentials',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            ));
                            ?>
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Add your Cloud Credentials</h4>
                            </div>
                            <div class="modal-body">
								<div class="form-group col-lg-12">
                                    <label class="col-lg-3" for="defaultCloudCredentials" style="margin-left: -30px;margin-top: 10px;"><?=Language::show('makeCloudDefault', 'keywords');?></label>
                                        <div>
                                            <label class="switch col-lg-9">
                                            <input id="switch" name="defaultCloudCredentials" type="checkbox">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <label for="cloudType">Cloud Type</label>
                                        <select class="form-control" name="cloudType" id="cloudType">
                                            <option value="azureBlob"><?=Language::show('azureBlob', 'settings')?></option>
                                            <option value="ibmCloud"><?=Language::show('ibmSoftlayer', 'settings')?></option>
                                            <option value="amazon"><?=Language::show('amazonS3', 'settings')?></option>
                                            <option value="localStorage"><?=Language::show('localStorage', 'settings')?></option>
                                            <option value="oneDrive"><?=Language::show('microsoft', 'settings')?></option>
                                            <option value="googleDrive"><?=Language::show('googleDrive', 'settings')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 cloudCredentialName">
                                        <label for="cloudCredentialName"><?=Language::show('cloudName', 'settings')?></label>
                                        <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('cloudNameInfo', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                        <input type="text" class="form-control" name="cloudCredentialName" id="cloudCredentialName" value="" placeholder="<?=Language::show('cloudNamePH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 identity">
                                        <label for="identity">Identity</label>
                                        <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="<?=Language::show('cloudIdentityPH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 accessKey">
                                        <label for="accessKey">Access key</label>
                                        <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="<?=Language::show('accessKeyPH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 epaUrl" style="display: none;">
                                        <label for="epaUrl">End Point URL</label>
                                        <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="<?=Language::show('endPointURLPH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 containerName" style="display: none;">
                                        <label for="containerName">Amazon Container Name</label>
                                        <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="<?=Language::show('amazonContainerNamePH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 localStorage" style="display: none;">
                                        <label for="localStorage">Local Storage Folder Name</label>
                                        <input type="text" class="form-control" name="localStorage" id="localStorage" value="" placeholder="<?=Language::show('folderNamePH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <!--Google starts-->
                                    <div class="forGD hide" >
                                        <div class="panel-body">
                                            <input type="text" class="hide" hidden value="<?=$ccS["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6">
                                                <label for="clientId">Client ID</label>
                                                 <a class="odbclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('oneDriveClintID', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                 <a class="gclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('googleDriveClintID', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="<?=Language::show('clientIDPH', 'settings')?>" autocomplete="off">
                                                </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret"><?=Language::show('secretKey', 'keywords')?></label>
                                                <a class="gclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('googleDriveSecreteKey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <a class="odbclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('oneDriveSecreteKey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="{{value.credential}}" placeholder="<?=Language::show('secretKeyPH', 'settings')?>" autocomplete="off">
                                                
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientRedirectURI">Client Redirect URI</label>
                                                <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('clientRedirectURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="{{value.clientRedirectUri}}" placeholder="<?=Language::show('redirectURIPH', 'settings')?>" autocomplete="off">
                                           </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientResourceURL">Client Resource URL</label>
                                                <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('resourceURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="{{value.clientResourceUrl}}" placeholder="<?=Language::show('clientResourceURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientTokenURL">Client Token URL</label>
                                                 <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('resourceURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="{{value.clientTokenUrl}}" placeholder="<?=Language::show('clientTokenURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="portalURL">Portal URL</label>
                                                 <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('portalURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="{{value.endPointUrl}}" placeholder="<?=Language::show('portalURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                <!--Google ends -->
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button type="button" class="btn btn-danger" ng-click="closeModal()" data-dismiss="modal">Cancel</button>
                            </div>
                            <?=
                            Form::close();
                            ?>
                        </div>
                    </div>
                </div>
                <div class="panel ccSPanel" style="display: none;">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('listOfClouds', 'keywords')?>
                            <a class="pull-right btn btn-small btn-success" data-toggle="modal" data-target=".createNewContainer">Create Cloud</a>
                        </h4>

                    </div>

                    <div class="panel-body">
                        <!-- table start-->
                        <div ng-if="ccS.length > 0" class="table-responsive">
                            <div class="h4 loading text-center hide">Loading.....</div>
                            <table class="table table-bordered table-striped deviceListTable">
                                <thead>
                                <tr>
                                    <th class="text-left">Cloud Name</th>
                                    <th class="text-left">Cloud Type</th>
                                    <th class="text-left">Action</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr class=ng-scope" ng-repeat="value in ccS track by $index">
                                    <td>{{value.cloudCredentialName}}</td>
                                    <td>{{value.cloudNameInCaps}}</td>
                                    <td>
                                        <!--<a class="btn btn-small btn-success" data-toggle="modal" data-target="editAdCredentialsModal"><i class="fa fa-plus-circle"></i> Edit</a>-->
                                        <button type="button" class="btn btn-small btn-success" data-toggle="modal" data-target="editCloudCredentialsModal" ng-click="getCloudCredentials($index)"><i class="fa fa-plus-circle"></i> Edit Cloud</button>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- table ends-->

                        <!--modal starts-->
                        <div class="modal fade" id="editCloudCredentialsModal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <?=
                                    Form::open(array(
                                        'ng-submit' => 'editCloudCredentials(true)',
                                        'class' => 'editCloudCredentials',
                                        'csrf' => $data['csrf_token'],
                                        'autocomplete' => 'off',
                                        'data-parsley-validate' => true
                                    ));
                                    ?>
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4 class="modal-title">Edit Cloud Credentials</h4>
                                    </div>
                                    <div class="modal-body">
										<div class="form-group col-lg-12">
                                            <label class="col-lg-3" for="defaultCloudCredentials1" style="margin-left: -30px;margin-top: 10px;"><?=Language::show('makeCloudDefault', 'keywords');?></label>
                                                <div>
                                                    <label class="switch col-lg-9">
                                                    <input id="switchedit" name="defaultCloudCredentials1" type="checkbox">
                                                    <div class="slider round"></div>
                                                    </label>
                                                </div>
                                        </div>
                                        <div class="row">
                                            <input type="text" class="hide" hidden value="<?=$ccS["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6 cloudCredentialName">
                                                <label for="cloudCredentialName1">Cloud Name</label>
                                                <input type="text" class="form-control" name="cloudCredentialName1" id="cloud_credential_name" value="" placeholder="Enter your Cloud Name" required autocomplete="off" readonly>
                                            </div>
                        <div class="form-group col-lg-6">
                                                <label for="cloud_type">Cloud Type</label>
                                                <input type="text" class="form-control" name="cloudType1" id="cloud_type" required autocomplete="off" readonly>
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label class="for_godb">Client Id</label>
                                                <label class="for_azure">Identity</label>
                                                <input type="text" class="form-control" name="clientId1" id="client_id" required autocomplete="off" readonly>
                                            </div>
                                            <div class="form-group col-lg-6 access_key">
                                                <label for="access_key">Access key</label>
                                                <input type="password" class="form-control" name="access_key" id="access_key" required autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6 local_storage">
                                                <label for="local_storage">Local Storage Folder Name</label>
                                                <input type="text" class="form-control" name="localStorage1" id="local_storage" required autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6 epa_Url">
                                                <label for="epaUrl1">End Point Url</label>
                                                <input type="text" class="form-control" name="epaUrl1" id="epa_Url" required autocomplete="off" readonly>
                                            </div>
                                            <div class="form-group col-lg-6 client_secret">
                                                <label for="client_secret">Client Secret</label>
                                                <input type="password" class="form-control" name="clientSecret1" id="client_secret" required autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6 client_secret">
                                                <label for="client_secret">Client redirect uri</label>
                                                <input type="text" class="form-control" name="clientRedirectURI1" id="client_redirect" required autocomplete="off" readonly>
                                            </div>
                                            <div class="form-group col-lg-6 client_secret">
                                                <label for="client_secret">Client resource url</label>
                                                <input type="text" class="form-control" name="clientResourceURL1" id="client_resource_url" required autocomplete="off" readonly>
                                            </div>
                                            <div class="form-group col-lg-6 client_secret">
                                                <label for="client_secret">Client token</label>
                                                <input type="text" class="form-control" name="clientTokenURL1" id="client_token" required autocomplete="off" readonly>
                                            </div>
                                            <div class="form-group col-lg-6 client_secret">
                                                <label for="client_secret">portal url</label>
                                                <input type="text" class="form-control" name="portalURL1" id="portal_url" required autocomplete="off" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-default button_cancel" data-dismiss="modal"><?=Language::show('cancel', 'keywords')?></button>
                                        <button type="submit" class="btn btn-success button_save"><?=Language::show('save', 'keywords')?></button>
                                    </div>
                                    <?= Form::close(); ?>
                                </div>
                            </div>
                        </div>
                        <!--modal ends-->
                        <!--<div ng-if="ccS.length > 0">
                            <div ng-repeat="value in ccS track by $index" class="col-lg-4 ng-scope block-ui block-ui-anim-fade" block-ui="myBlockUI" aria-busy="false">
                                <div class="panel panel-default no-box-shadow widget-success">
                                    <div class="background">
                                        <i class="fa fa-language"></i>
                                    </div>
                                    <div class="panel-heading widget-header">
                                        <span ng-if="value.cloudNameInCaps.length > 0">
                                            <a>CloudName: </a><a class="pull-right">{{ value.cloudNameInCaps }}</a>
                                            <br/>
                                        </span>

                                        <span ng-if="value.identity.length > 0">
                                            <a>Identity: </a><a class="pull-right">{{ value.identity }}</a>
                                            <br/>
                                        </span>
                                    </div>
                                    <div class="panel-footer">
                                        <a style="margin-top: 5px;" class="btn btn-primary btn-small removeCredentialsBtn{{$index}}" ng-click="removeCloudCredentials($index)">Edit</a>
                                    </div>
                                </div>
                            </div>
                        </div>-->
                        <div ng-if="ccS.length <= 0">
                            <h4 align="center">There are no Cloud Credentials Saved</h4>
                        </div>
                    </div>
                    <div class="panel-footer hide">
                        <p class="help help-block">Note:- Only one Cloud Credential details can be added</p>
                    </div>
                </div>
                <!--                <div class="panel createCCSPanel" style="display: none;">-->

                <?php// } ?>
                <?php //if(STORAGE_TYPE == "GOOGLE_DRIVE"){ ?>
                <!--<div class="forGD">
                    <div class="panel">
                        <div class="panel-heading"><h4>Google Drive Connection Settings</h4></div>
                        <div class="panel-body">
                            <form class="googleConfiguration" ng-submit="saveGoogleConfiguration()" data-parsley-validate>
                                <input type="text" class="hide" hidden value="<?=$data["configId"]?>" name="configId" />
                                <div class="form-group col-lg-6">
                                    <label for="clientId">Client ID</label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter your Client Id" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created a google app.</span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="clientSecret">Client Secret</label>
                                    <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter your Secret Key" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created a google app.</span>
                                </div>
                                <button type="submit" class="btn btn-success pull-right">Save Settings</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>-->
            <?php //} ?>

            <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                <!--<div class="forODB">-->
                    <!--<div class="panel">
                        <div class="panel-heading"><h4>One Drive For Business Connection Settings</h4></div>
                        <div class="panel-body">
                            <form class="odbConfiguration" ng-submit="saveOdbConfiguration()" data-parsley-validate>
                                <input type="text" class="hide" hidden value="<?=$data["configId"]?>" name="configId" />
                                <div class="form-group col-lg-6">
                                    <label for="ClientId">Client ID</label>
                                    <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter your Client Id" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created a One Drive Business app.</span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="clientSecret">Client Secret</label>
                                    <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter your Secret Key" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created a One Drive Business app.</span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="clientRedirectURI">Client Redirect URI</label>
                                    <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter your Redirect Uri" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="clientResourceURL">Client Resource URL</label>
                                    <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter your client Resource URL" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your share point app URL)</span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="clientTokenURL">Client Token URL</label>
                                    <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="<?=$data["clientTokenURL"]?>" placeholder="Enter your client Resource URL" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com</span>
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="portalURL">Portal URL</label>
                                    <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=$data["portalURL"]?>" placeholder="Enter your Portal URL" required autocomplete="off">
                                    <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                    <br/><br/>
                                    <button type="submit" class="btn btn-success pull-right">Save Settings</button>
                                </div>
                            </form>
                        </div>
                    </div>-->
                    <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                        <?php if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                            <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                <div class="panel">
                                    <div class="panel-heading"><h4>Select Storage Space</h4></div>
                                    <div class="panel-body">
                                        <div class="form-group col-lg-12">
                                            <div class="well well-lg">
                                                <p class="hide">
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                    - Your cloud does not support this feature
                                                </p>
                                                <p class="hide">
                                                    <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                    - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                </p>
                                                <?php
                                                $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                ?>
                                                <p class="hide">
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                    - Google Drive Storage space
                                                </p>
                                                <?php
                                                $MODCUrl = ODFC_REDIRECT_URI."?client_id=".ODFC_CLIENT_ID."&response_type=code&redirect_uri=".\Helpers\Url::basePath(ODFC_RESOURCE_URI.'/')."&state=".$data['loggedInUser']['userName'];
                                                ?>
                                                <p class="hide">
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODCUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive</a>
                                                    - Microsoft OneDrive Consumer Storage Space
                                                </p>
                                                <?php
                                                $params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$data["clientRedirectURI"]."&state=".$data['loggedInUser']['userName'];
                                                $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                ?>
                                                <p>
                                                    <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                    - Microsoft OneDrive for business Storage Space
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        <?php } ?>
                    <?php } ?>
                <!--</div>-->
            <?php } ?>
        </div>
    </div>
</div>

<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker('render');
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.localStorage').hide();
            $('.containerName').show();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="containerName"').attr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.localStorage').hide();
            $('.containerName').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 'localStorage'){
            $('.localStorage').show();
            $('[name="localStorage"').attr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
        }else if(type == 'googleDrive'){
            $('.localStorage').hide();
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('.forGD').removeClass('hide');
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
            $('.gclientId').removeClass('hide');
            $('.gclientSecret').removeClass('hide');
            $('.gclientRedirectURI').removeClass('hide');
            $('.gclientResourceURL').removeClass('hide');
            $('.gclientTokenURL').removeClass('hide');
            $('.gportalURL').removeClass('hide'); 
            $('.odbclientId').addClass('hide');
            $('.odbclientSecret').addClass('hide');
            $('.odbclientRedirectURI').addClass('hide');
            $('.odbclientResourceURL').addClass('hide');
            $('.odbclientTokenURL').addClass('hide');
            $('.odbportalURL').addClass('hide');
        }else if(type == 'oneDrive'){
            $('.localStorage').hide();
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('.forGD').removeClass('hide');
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
            $('.odbclientId').removeClass('hide');
            $('.odbclientSecret').removeClass('hide');
            $('.odbclientRedirectURI').removeClass('hide');
            $('.odbclientResourceURL').removeClass('hide');
            $('.odbclientTokenURL').removeClass('hide');
            $('.odbportalURL').removeClass('hide');
            $('.gclientId').addClass('hide');
            $('.gclientSecret').addClass('hide');
            $('.gclientRedirectURI').addClass('hide');
            $('.gclientResourceURL').addClass('hide');
            $('.gclientTokenURL').addClass('hide');
            $('.gportalURL').addClass('hide');
        }else{
            $('.localStorage').hide();
            $('.epaUrl').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
            $('.access_key').addClass("hide");
            $('#access_key').removeAttr('required', 'required');
            $('.client_secret').addClass("hide");
            $('#client_secret').removeAttr('required', 'required');
            $('#client_redirect').removeAttr('required', 'required');
            $('#client_resource_url').removeAttr('required', 'required');
            $('#client_token').removeAttr('required', 'required');
            $('#portal_url').removeAttr('required', 'required');
        }
    });
</script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>