<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="row">
                <span class="currentPage hide"><?='blobTrend'?></span>
                <span class="csrf_token hide"><?=$data['csrf_token'];?></span>
                <div class="panel">
                    <div class="panel-heading"><h3>Blob Storage Trend (PG to Cloud in GB)</div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateBlobTrend(search.from, search.to)" data-parsley-validate>
                                    <div class="form-group">
                                        <label for="from">From Date</label>
                                        <input type="text" class="form-control" id="from" ng-model="search.from" placeholder="From Date" data-parsley-trigger="change" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="to">To Date</label>
                                        <input type="text" class="form-control" value="" id="to" ng-model="search.to" placeholder="To Date" data-parsley-trigger="change" required>
                                    </div>
                                    <button type="submit" class="btn btn-default">Generate Trend</button>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <div class="col-lg-12">
                            <div style="width:100%">
                                <div class="col-lg-12 blobTrend"><canvas id="myChart" width="600px" height= "200px"></canvas></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
    var currentDate = new Date();
    currentDate.setDate(currentDate.getDate() - 31);
    $('#from').datepicker('update', currentDate);
    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>