<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){?>
                    <li>Failed Backup details for a Server</li>
                <?php }else{ ?>
                    <li>Failed Backup details for a Device</li>
                <?php }?>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='failedBackupByUserOrDevice'?></span>
            <div class="row">
                <div class="panel">
                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){?>
                        <div class="panel-heading"><h3>Failed Backup details for a Server</div>
                    <?php }else{ ?>
                        <div class="panel-heading"><h3>Failed Backup details for a Device</div>
                    <?php }?>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateFailedBackupByUserOrDevice('', search.deviceName, 0)" data-parsley-validate>
                                    <div class="">
                                        <select class="searchDeviceName" style="width: 25%;" id="deviceName" ng-model="search.deviceName" data-parsley-trigger="change" required></select>
                                        <button type="submit" class="btn btn-default">Generate Report</button>
                                        <a ng-click="updateFailedBackupByUserOrDevice('', '', 0)" type="submit" class="btn btn-default">Show All</a>
                                        <a ng-click="exportToExcel('#FailedBackup', 'Failed Backup', failedBackupByUserOrDevice)" class="btn btn-default">Export To excel</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table id="FailedBackup" class="table table-bordered failedBackupByUserOrDevice" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                                        <?=Language::show('Server', 'keywords')?>
                                    <?php }else{ ?>
                                        <?=Language::show('device', 'keywords')?>
                                    <?php } ?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('user', 'keywords')?>
                                        <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                <?php } ?>
                                <th class="text-center clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                    <?=Language::show('startTime', 'keywords')?>
                                    <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'whenFailed'; sortReverse = !sortReverse">
                                    <?=Language::show('endTime', 'keywords')?>
                                    <span ng-show="sortType == 'whenFailed' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'whenFailed' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'failedReason'; sortReverse = !sortReverse">
                                    <?=Language::show('reason', 'keywords')?>
                                    <span ng-show="sortType == 'failedReason' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'failedReason' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in failedBackupByUserOrDevice | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                <?php } ?>
                                <td class="text-center" ng-cloak>{{ value.startTime }}</td>
                                <td class="text-center" ng-cloak>{{ value.whenFailed }}</td>
                                <td class="text-center" ng-cloak>{{ value.failedReason }}</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 failedBackupByUserOrDeviceError text-center" style="display: none">There was not details found for Failed Backup</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
    $('#from').datepicker('update', '01/01/2015');
    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"device/searchDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){?>
        placeholder: 'Select Server'
        <?php }else{ ?>
        placeholder: 'Select Device'
        <?php }?>
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>