<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <?php if(!empty($_SESSION['OverReportResult'])){ ?>
            <?php if($_SESSION['OverReportResult'] == 404){ ?>
                <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 404</span>
            <?php }elseif($_SESSION['OverReportResult'] == 500){ ?>
                <span class="resultError" style="display: none">Due to some technical issues could not download the file error code : 500</span>
            <?php } ?>
            <?php $_SESSION['OverReportResult'] = ''; ?>
        <?php } ?>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak reportDashboard">
            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                <div class="row">
                    <div class="col-lg-6">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3 class="panel-title"> Overview </h3>
                            </div>
                            <div class="panel-body">
                                <p><a href="<?=Url::basePath('report/statistics')?>"> System overview </a></p>
                                <p><a href="<?=Url::basePath('report/overview')?>"> User overview </a></p>
                                <p><a href="<?=Url::basePath('report/download/overviewReport?from=dashboard')?>">Download User Overview in excel format</a></p>
                                <p><a href="<?=Url::basePath('report/userDeviceHistory')?>">User wise Overview of device and storage</a></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h3 class="panel-title"> Restore History </h3>
                            </div>
                            <div class="panel-body">
                                <p><a href="<?=Url::basePath('report/restoreByDate')?>"> Restore History by Date Range </a></p>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <p><a href="<?=Url::basePath('report/restoreByUser')?>"> Restore History by User</a></p>
                                <?php } ?>
                                <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                    <p><a href="<?=Url::basePath('report/restoreByDevice')?>"> Restore History by Device</a></p>
                                <?php }else{ ?>
                                    <p><a href="<?=Url::basePath('report/restoreByDevice')?>"> Restore History by Server</a></p>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Backup History </h3>
                        </div>
                        <div class="panel-body">
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/userBackupHistory')?>"> Backup history </a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/longBackup')?>"> Long running backup </a></p>
                            <p><a href="<?=Url::basePath('report/currentBackup')?>"> Currently Running Backup </a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Systems without backups (7 Days)</a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/noBackup')?>"> Servers without backups (7 Days)</a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/lastBackupByUser')?>">Last Backup Status by User</a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/lastBackupByDevice')?>"> Last Backup Status by Device</a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/lastBackupByDevice')?>"> Last Backup Status by Server</a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/failedBackup')?>"> Failed Backup by date range</a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/failedBackupByUser')?>">Failed Backup by User </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/failedBackupByDevice')?>"> Failed Backup by Device </a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/failedBackupByDevice')?>"> Failed Backup by Server </a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/alertByDate')?>"> Attempt History by Date Range </a></p>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/alertByUser')?>"> Attempt History by User </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/alertByDevice')?>"> Attempt History by Device</a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/alertByDevice')?>"> Attempt History by Server</a></p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Storage Utilization </h3>
                        </div>
                        <div class="panel-body">
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/storageUtilizedByUser')?>"> Storage Utilized by User </a></p>
                            <?php } ?>
                            <?php if(\Helpers\Auth::checkCloudPermission('serverBackup') == false){ ?>
                                <p><a href="<?=Url::basePath('report/storageUtilizedByDevice')?>"> Storage Utilized by Device </a></p>
                            <?php }else{ ?>
                                <p><a href="<?=Url::basePath('report/storageUtilizedByDevice')?>"> Storage Utilized by Server</a></p>
                            <?php } ?>
                            <p><a href="<?=Url::basePath('report/storageUtilizedByPG')?>"> Storage Utilization per BluKrypt </a></p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title"> Trend Reports </h3>
                        </div>
                        <div class="panel-body">
                            <p><a href="<?=Url::basePath('report/storageTrend')?>"> Blukrypt storage usage trend </a></p>
                            <?php if(STORAGE_TYPE == 'ONE_DRIVE'){ ?>
                                <p><a href="<?=Url::basePath('report/backupTrend')?>"> Cloud storage usage trend </a></p>
                            <?php } ?>
                            <?php if(STORAGE_TYPE == 'AZURE'){ ?>
                                <p><a href="<?=Url::basePath('report/blobTrend')?>"> Cloud storage usage trend </a></p>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">


            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>