<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
                <li><?=$data['crumb2']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='alertHistory'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading"><h3><?=$data['crumb2']?></h3></div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateAlertHistory('', '', search.from, search.to)" data-parsley-validate>
                                    <div class="form-group">
                                        <label for="from">From Date</label>
                                        <input type="text" class="form-control" id="from" ng-model="search.from" placeholder="From Date" data-parsley-trigger="change" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="to">To Date</label>
                                        <input type="text" class="form-control" value="" id="to" ng-model="search.to" placeholder="To Date" data-parsley-trigger="change" required>
                                    </div>
                                    <button type="submit" class="btn btn-default">Generate Report</button>
                                    <a ng-click="exportToExcel('#alertHistoryDate', 'Alert History by Date', alertHistory)" class="btn btn-default">Export To excel</a>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table id="alertHistoryDate" class="table table-bordered alertHistory" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('device', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('user', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center clickAble" ng-click="sortType = 'action'; sortReverse = !sortReverse">
                                    <?=Language::show('details', 'keywords')?>
                                    <span ng-show="sortType == 'action' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'action' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in alertHistory | orderBy:sortType:sortReverse" class="text-center">
                                <td class="text-center" ng-cloak>{{ value.deviceName }}</td>
                                <td ng-cloak>{{ value.userName }}</td>
                                <td ng-cloak>{{ value.action }}</td>
                            </tr>
                            </tbody>
                        </table>
                        <div class="h4 alertHistoryError text-center" style="display: none">There was not details found for the selected date range</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        endDate: '+0d',
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>