<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><a href="<?=Url::basePath('pms')?>"><h3><?=$data['title']?></h3></a></li>
                    <li><a href="<?=Url::basePath('pms')?>"><span><?=Language::show('bluSyncPolicy', 'pms')?></span></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="SyncPmsController">
        <div class="row profile">
            <div class="col-lg-2 col-md-2 col-sm-2">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10" block-ui="myBlockUI">
                <span class="hide currentPage"><?='singlePolicyMapping'?></span>
                <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=$data['crumb2']?></h4>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <form ng-submit="updatePolicyMappingList('0', search.userName)">
                                <div class="col-lg-12">
                                    <input name="searchUsername"
                                           type="text"
                                           class="pull-right form-control"
                                           ng-model="search.userName"
                                           placeholder="Enter a list of comma separated User ID's or just type 'all (for all users)' and hit enter to search"
                                           data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                           data-content="Entered User ID was not found!!! "
                                        />
                                </div>
                            </form>
                        </div>
                        <br/>
                        <div class="h4 noupolicy text-center" style="display: none;"><?=Language::show('no_user_found', 'user')?></div>
                        <table class="table table-bordered table-striped userPolicyMappingListTable" style="display: none;">
                            <colgroup>
                                <col class="col-xs-3">
                                <col class="col-xs-5">
                                <col class="col-xs-3">
                            </colgroup>
                            <thead>
                                <tr>
                                    <th><?=Language::show('userId', 'keywords')?></th>
                                    <th><?=Language::show('policyName', 'keywords')?></th>
                                    <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                                </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in userPolicyMappingUsers track by $index" class="mappingRow{{$index}}">
                                <td class="userName" ng-cloak>{{ value.userName }}</td>
                                <td class="policyName" ng-cloak>
                                    <span>{{ value.syncPolicyName }}</span>
                                    <form style="display: none;">
                                        <select class="form-control" name="userPolicyMappingPolicyName{{$index}}" id="userPolicyMappingPolicyName" required="">
                                            <option ng-repeat="policy in userPolicyMappingPolicies" value="{{ policy }}">{{ policy }}</option>
                                        </select>
                                    </form>
                                </td>
                                <td class="action" ng-cloak>
                                    <a class="edit btn btn-default btn-small btn-success" ng-click="showMappingList($index)"><i class="fa fa-edit"></i> <?=Language::show('change_policy', 'keywords');?></a>
                                    <a style="display: none;" class="save btn btn-success btn-small" ng-click="changePolicy($index)"><i class="fa fa-save"></i> <?=Language::show('save_policy', 'keywords');?></a>
                                    <a style="display: none;" class="save btn btn-danger btn-small" ng-click="cancelChangePolicy($index)"><i class="fa fa-times"></i> <?=Language::show('cancel', 'keywords');?></a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        <div ng-if="searchForUserName == 'all'" class="row loadMore" style="display: none;">
                            <div class="col-lg-12 text-center">
                                <a class="loadMoreBtn btn btn-primary" ng-click="updatePolicyMappingList(skipValue, 'all')">Load More ...</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncPmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>