<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('pms/schedules')?>"><?=Language::show('list_of_schedules', 'keywords');?></a></li>
                    <li><span><?=Language::show('create_schedule', 'keywords')?></span></li>
                </ol>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="PmsController">
        <div class="row profile">
            <div class="col-lg-2 col-md-2 col-sm-2">
                <?php View::renderTemplate('partials/sideBar', $data); ?>
            </div>
            <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('create_schedule', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                        <?=
                        Form::open(array(
                            'csrf' => $data['csrf_token'],
                            'class' => 'scheduleForm',
                            'autocomplete' => 'off',
                            'ng-submit' => 'scheduleCreate(false)',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="form-group col-lg-12">
                            <label class="col-lg-3" for="defaultSchedules" style="margin-left: -30px;margin-top: 10px;"><?=Language::show('makeScheduleDefault', 'keywords');?></label>
                                <div>
                                    <label class="switch col-lg-9">
                                    <input id="switch" name="defaultSchedule" type="checkbox">
                                    <div class="slider round"></div>
                                    </label>
                                </div>
                        </div>
                        <div class="form-group">
                            <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                            <input type="text" class="form-control" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                        </div>
                        <div class="form-group hide">
                            <label for="scheduleTimeZone"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                            <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                        </div>
                        <div class="form-group">
                            <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                            <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime">
                        </div>
                        <?php if(\Helpers\Auth::checkCloudPermission('serverBackup')){ ?>
                            <div class="form-group backupTypeForm">
                                <label for="backupType"><?=Language::show('Backup Type', 'keywords');?></label>
                                <select class="form-control backupType" name="backupType" id="backupType" required>
                                    <option value="f">Full</option>
                                    <option value="i">Incremental</option>
                                </select>
                            </div>
                        <?php } ?>
                        <div class="form-group">
                            <label for="days"><?=Language::show('schedule_days', 'keywords');?></label> -
                            <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                            <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                                <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                                <option value="2"><?=Language::show('monday', 'keywords')?></option>
                                <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                                <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                                <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                                <option value="6"><?=Language::show('friday', 'keywords')?></option>
                                <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                            </select>
                        </div>
                        
                        <div>
                            <p>Note:- The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating.</p>
                        </div>
                        <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        <?=
                            Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.backupType').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>