<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><?=Language::show('bluvaultPolicies', 'pms')?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?='policy'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('bluvaultPolicies', 'pms')?><span class="pull-right"><a class="btn btn-success btn-small" href="<?=Url::basePath('pms/policy/create')?>"><?=Language::show('create_policy', 'keywords');?></a></span></h4>
                </div>
                <div class="panel-body">
                    <div class="bs-example policyTable" style="display: none;" data-example-id="simple-responsive-table">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <colgroup>
                                    <col class="col-xs-3">
                                    <col class="col-xs-2">
                                    <col class="col-xs-2">
                                    <col class="col-xs-4">
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th class="text-left"><?=Language::show('policyName', 'keywords')?></th>
                                        <th class="text-left"><?=Language::show('maxVersions', 'keywords')?></th>
                                        <th class="text-left"><?=Language::show('scheduleNames', 'keywords')?></th>
                                        <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr ng-repeat="value in policies track by $index">
                                        <td ng-cloak>{{ value.policygroupName }}</td>
                                        <td ng-cloak ng-if="value.maxVersions > 0">{{ value.maxVersions }}</td>
                                        <td ng-cloak ng-if="value.maxVersions < 0">UNLIMITED</td>
                                        <td ng-cloak>{{ value.scheduleNames.join(', ') }}</td>
                                        <td>
										<a href="" class="btn btn-default btn-small btn-success" ng-click="viewPolicy(value.policygroupName)"><i class="fa fa-eye"></i> <?=Language::show('view', 'keywords')?></a>
										<a href="<?=Url::basePath('pms/policy/edit/{{value.policygroupName}}')?>" class="btn btn-default btn-small btn-success"><i class="fa fa-edit"></i> <?=Language::show('edit', 'keywords')?></a>
										<a href="<?=Url::basePath('pms/policy/clone/{{value.policygroupName}}')?>" class="btn btn-default btn-small btn-success"><i class="fa fa-copy"></i> <?=Language::show('clone', 'keywords')?></a>
										<a ng-class="{false:'disabled'}[value.policyDeletable]" class="btn btn-danger btn-small policyremove{{$index}}"
										ng-bootbox-confirm="<div><h4 class='modal-title' id='myModalLabel'>Confirm Delete Policy</h4><hr></div><?=Language::show('confirmDelete', 'keywords')?> {{value.policygroupName}} <?=Language::show('policy', 'keywords')?> ?"
										ng-bootbox-confirm-action="removePolicy(value.policygroupName,$index)"
										ng-bootbox-confirm-action-cancel=""
										href="javascript:;"><i class="fa fa-trash"></i> <?=Language::show('delete', 'keywords')?></a>
										</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div><!-- /.table-responsive -->
                    </div>
                    <div class="policyTableEmpty" style="display: none;">
                        <h2 class="-align-center"><?=Language::show('noPolicy', 'pms')?></h2>
                    </div>
                </div>
            </div>
        </div>
	
	<div class="modal fade viewPolicy">
            <div class="modal-dialog">
                <div class="modal-content mediumModal">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">View Policy</h4>
                    </div>
                    <div class="modal-body">
                        <!-- start -->
						<div class="panel-body" style="padding: 0px 30px 30px 30px;">
                    <span class="hide currentPage"><?='viewPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <div class="row">
                        <div class="col-lg-7">
                            
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policygroupName" id="policygroupName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off" readonly>
                            </div>
                        </div>
                    </div>
                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab">General</a></li>
                        <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab">Advanced</a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?></label>
                                        <input type="text" class="form-control" name="schedules" id="schedules" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                       <input type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionMPS();" disabled/>
                                       <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <input type="text" class="form-control" name="osType" id="osType" readonly/>
                                    </div>
                                    
                                    <div class="form-group hide">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.memoryUtilization }}" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>

                                    <div class="form-group hide">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> (In Percentage)</label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.cpuUtilization }}" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row" ng-if="osType != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> Default Folders</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div ng-if="osType == 'windows' || osType == 'Windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                    <div ng-if="osType == 'mac' || osType == 'Mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} </li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0">There are no default folders to backup</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filters" id="filters" readonly/>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="row allFilters" ng-if="defaultFilter != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:65px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> Inclusion Filters</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <?=Language::show('filterName', 'keywords');?>: {{ defaultFilter.filterName }}
                                                    <br/>
                                                    <?=Language::show('Filter Type', 'keywords');?>: {{ defaultFilter.filterType }}
                                                    <br/>
                                                    <?=Language::show('filters', 'keywords');?>: <b style="word">{{ defaultFilter.filters }}</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
			    
                                <div class="row">
                                   <div class="col-lg-7">
                                       <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('cloudCredentials', 'keywords');?></legend>
                                           <div class="form-group">
                                               <label for="ccS"><?=Language::show('cloudCredentials', 'keywords');?></label>
                                               <input type="text" class="form-control" name="ccS" id="ccS" readonly/>
                                           </div>
                                   </div>
                                    <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultCloud != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-cloud"></i> Clouds</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <h5><?=Language::show('cloudName', 'settings');?>: {{ defaultCloud.cloudCredentialName }}</h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'azureBlob'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('azureBlob', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'ibmCloud'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('ibmSoftlayer', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'oneDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('microsoft', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'googleDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('googleDrive', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'amazon'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('amazonS3', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'localStorage'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('localStorage', 'settings');?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                               </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">

                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group partial">
                                        <label class="col-lg-4" for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="incrementalFileTransfer" id="incrementalFileTransfer" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                        <div class="col-lg-3">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromClientToPG }}" onfocusout="myFunction();" disabled/>
                                        <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>

                                    <div class="form-group hide">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.nwFromPGToCloud }}" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="{{ selectedPolicy.crawlLimit }}" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" data-parsley-type="integer" data-parsley-min="1" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" readonly/>
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group">
                                        <div>
                                            <input id="legalHold" name="legalHold" type="checkbox" value="enabled" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled" disabled>
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>&nbsp;&nbsp;
                                            <span class="systemFolders" style="display: none;">
                                                    <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled" data-style="ios" data-toggle="toggle" data-on="Yes" data-off="No">
                                                    <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                                </span>
                                        </div>
                                    </div>
                                   
                                        <div class="form-group">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <input type="text" class="form-control" name="dedup" id="dedup" readonly/>
                                        </div>
                                                         
                                    <div class="form-group">
                                        <label class="col-lg-4" for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="compEnabled" id="compEnabled" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled" disabled>  
                                    </div>
                                    <div class="form-group vssContainer" style="display: none;">
                                        <label class="col-lg-4" for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="vssEnabled" id="vssEnabled" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">  
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group searchAlgoForPg">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <input type="text" class="form-control" name="searchAlgoForPg" id="searchAlgoForPg" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                        <input type="text" class="form-control" name="Blukryptipaddress" id="Blukryptipaddress" readonly/>
                                    </div>
                                    <div class="form-group">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" min="0" max="23" required="" readonly>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="col-lg-6" for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="shareEnabled" id="shareEnabled" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                    </div>
                                    <div class="form-group highSecureShareEnabled">
                                        <label class="col-lg-6" for="highSecureShareEnabled"><?=Language::show('highSecureShareEnabled', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="highSecureShareEnabled" id="highSecureShareEnabled" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                    </div>
                                    <div class="row highSecuredShareOptions">
                                        
                                        <div class="col-lg-12">
                                            <div class="form-group complexPasswordRequired"><div class="col-lg-6"><i class="fa fa-dot-circle-o"></i>&nbsp;&nbsp;
                                                <label for="complexPasswordRequired"><?=Language::show('complexPasswordRequired', 'keywords');?></label>
                                                </div><input class="col-lg-2 form-control" type="checkbox" name="complexPasswordRequired" id="complexPasswordRequired" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            </div>
                                        </div>
                                       
                                        <div class="col-lg-12">
                                            <div class="form-group preventDownloadEnabled"><div class="col-lg-6"><i class="fa fa-dot-circle-o"></i>&nbsp;&nbsp;
                                                <label for="preventDownloadEnabled"><?=Language::show('preventDownloadEnabled', 'keywords');?></label>
                                                </div><input class="col-lg-2 form-control" type="checkbox" name="preventDownloadEnabled" id="preventDownloadEnabled" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-12">
                                            <div class="form-group expiredDate"><div class="col-lg-6"><i class="fa fa-dot-circle-o"></i>&nbsp;&nbsp;
                                                <label for="expiredDate"><?=Language::show('expiredDate', 'keywords');?></label>
                                                </div><input class="col-lg-2 form-control" type="checkbox" name="expiredDate" id="expiredDate" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
						    <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('uISettingsForAgent', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="col-lg-4" for="exitt"><?=Language::show('EXIT', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="exitt" id="exitt" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="decouple"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="decouple" id="decouple" checked value="Yes"  data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="support"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="support" id="support" checked value="Yes"  data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="initiatebackup"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="initiatebackup" id="initiatebackup" checked value="Yes"  data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="restore"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="restore" id="restore" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="col-lg-4" for="stopbackup"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="stopbackup" id="stopbackup" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="bkpsettings"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="bkpsettings" id="bkpsettings" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="bkpfiles"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="bkpfiles" id="bkpfiles" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="refbkppolicy"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="refbkppolicy" id="refbkppolicy" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                     
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
						<!-- end -->
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('close', 'keywords')?></button>
                    </div>
                </div>
            </div>
        </div>
	
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>