<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header("Cache-Control: no-cache, must-revalidate"); //HTTP 1.1
header("Pragma: no-cache"); //HTTP 1.0
header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Date in the past
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('pms')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('pms/policies')?>"><?=Language::show('bPolicy', 'pms')?></a></li>
                <li><span><?=Language::show('create_policy', 'keywords')?></span></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <div class="row profile">
        <div class="col-lg-2 col-md-2 col-sm-2">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-10 col-md-10 col-sm-10 ng-cloak">
            <div class="panel">
                <div class="panel-heading">
                    <h4><?=Language::show('create_policy', 'keywords')?></h4>
                </div>
                <div class="panel-body" style="padding: 0px 30px 30px 30px;" block-ui="myBlockUI">
                    <span class="hide currentPage"><?='createPolicy'?></span>
                    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
                    <?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'policyForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'policyCreate()',
                        'data-parsley-validate' => true
                    ));
                    ?>

                    <div class="row">
                        <div class="col-lg-7">
                            <div class="form-group">
                                <label for="policyName"><?=Language::show('policyName', 'keywords');?></label>
                                <input type="text" class="form-control" name="policyName" id="policyName" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('policyName', 'keywords');?>" required autocomplete="off">
                            </div>
                        </div>
                    </div>

                    <!-- Nav tabs -->
                    <ul class="nav nav-tabs" role="tablist">
                        <li role="presentation" class="active"><a href="#general" aria-controls="general" role="tab" data-toggle="tab"><?=Language::show('general', 'keywords')?></a></li>
                        <li role="presentation"><a href="#advanced" aria-controls="advanced" role="tab" data-toggle="tab"><?=Language::show('advanced', 'keywords')?></a></li>
                    </ul>

                    <!-- Tab panes -->
                    <div class="tab-content">
                        <div role="tabpanel" class="tab-pane active" id="general">
                            <div class="row">
                                <div class="col-lg-7">
                                    <br/>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('backup_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="schedules"><?=Language::show('schedules', 'keywords');?> - <a class="clickAble" ng-click="addNewSchedule()"><?=Language::show('createShedule', 'keywords')?></a></label>
                                        <select class="form-control selectSchedulePicker" ng-model="schedules"  name="schedules[]" id="schedules" required="" multiple title='Select Schedules'>
                                            <?php if(!empty($data['schedules'])){ ?>
                                                <?php foreach($data['schedules'] as $key => $value){ ?>
                                                    <!--<option value="<?=$value['scheduleName']?>"><?=$value['scheduleName']?></option>-->
                                                    <option value="<?=$value['scheduleName']?>"<?php if($value['defaultSchedule'] == 'true'){ echo 'selected';}?>><?=$value['scheduleName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                    <?php foreach($data['schedules'] as $key => $value){
                                    if($value['defaultSchedule'] == 'true'){ ?>
                                    <input id="currentschedule" type="text" value="<?=$value['scheduleName']?>" style="display: none;">
                                    <?php }} ?>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxVersions"><?=Language::show('maxVersions', 'keywords');?></label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchver" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="maxVersions" id="maxVersions" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxVersions', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionVer();" disabled/>
                                            <span id="vererror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="maxPermissibleFileSize"><?=Language::show('maxPermissibleFileSize', 'keywords');?> (In MB)</label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchsize" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="maxPermissibleFileSize" id="maxPermissibleFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('maxPermissibleFileSize', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionMPS();" disabled/>
                                        <span id="sizeerror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    </div>
                                    <div class="form-group <?php if($_SESSION['serverBackupEnabled'] == 'true'){ ?>hide<?php } ?>">
                                        <label class="col-lg-12" style="margin-left: -14px;" for="perUserBackupStorageLimit"><?=Language::show('perUserBackupStorageLimit', 'keywords');?> (In GB)</label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switchlimit" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                        <input type="text" class="form-control" name="perUserBackupStorageLimit" id="perUserBackupStorageLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('perUserBackupStorageLimit', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunctionUBS();" disabled/>
                                        <span id="limiterror" style="color: #f55753;font-size: 0.9em;"></span>
                                    </div>
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="defaultSchedules.length >= 1">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default" style="margin-top:45px;">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-clock-o"></i> Schedule Details</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <table class="table table-bordered table-responsive">
                                                        <tbody>
                                                        <tr ng-repeat="value in defaultSchedules">
                                                            <td>{{ value.scheduleName }}</td>
                                                            <td>{{ value.time }} hrs</td>
                                                        </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('device_information', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="osType"><?=Language::show('osType', 'keywords');?></label>
                                        <select class="form-control selectOsTypePicker" ng-model="osType" name="osType" id="osType" required="" title='Select OS Type'>
                                            <option value="windows"><?=Language::show('windows', 'keywords');?></option>
                                            <option value="mac"><?=Language::show('mac', 'keywords');?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="defaultFoldersBackup"><?=Language::show('defaultFoldersBackup', 'keywords');?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" ng-model="defaultFoldersBackup" name="defaultFoldersBackup" id="defaultFoldersBackup" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('defaultFoldersBackup', 'keywords');?>" autocomplete="off"
                                                   data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                   data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                            />
                                            <span class="input-group-btn">
                                        <button ng-click="addDefaultFolder(defaultFoldersBackup)" class="btn btn-default defaultFoldersBackupBtn" style="padding-bottom: 10px;" type="button"><?=Language::show('add', 'keywords');?></button>
                                    </span>
                                        </div>
                                    </div>
                                    <div class="form-group hide">
                                        <label for="memoryUtilization"><?=Language::show('memoryUtilization', 'keywords');?> <?=Language::show('inMB', 'keywords');?></label>
                                        <input type="text" class="form-control" name="memoryUtilization" id="memoryUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('memoryUtilization', 'keywords');?>" required autocomplete="off" value="128" data-parsley-min="128" data-parsley-max="1024" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="cpuUtilization"><?=Language::show('cpuUtilization', 'keywords');?> <?=Language::show('inPercentage', 'keywords');?></label>
                                        <input type="text" class="form-control" name="cpuUtilization" id="cpuUtilization" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('cpuUtilization', 'keywords');?>" required autocomplete="off" value="80" data-parsley-min="20" data-parsley-max="100" data-parsley-type="integer" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="dcmEnabled"><?=Language::show('dcmEnabled', 'keywords');?></label>
                                        <select class="form-control dcmEnabled" name="dcmEnabled" id="dcmEnabled" required="" title='Select <?=Language::show('dcmEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>

                                </div>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row" ng-if="osType != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-folder-open"></i> <?=Language::show('defaultFolders', 'keywords')?></h5>
                                                </div>
                                                <div class="panel-body">
                                                    <div  ng-if="osType == 'windows'">
                                                        <ul class="list-group" ng-if="defaultWinFolders.length >= 1">
                                                            <li ng-repeat="value in defaultWinFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultWinFolders.length <= 0"><?=Language::show('noFolders', 'pms')?></span>
                                                    </div>
                                                    <div  ng-if="osType == 'mac'">
                                                        <ul class="list-group" ng-if="defaultMacFolders.length >= 1">
                                                            <li ng-repeat="value in defaultMacFolders track by $index" class="list-group-item">{{ value }} <a class="pull-right clickAble" ng-click="removeDefaultFolder($index)"><i class="fa fa-times-circle-o"></i></a></li>
                                                        </ul>
                                                        <span ng-if="defaultMacFolders.length <= 0"><?=Language::show('noFolders', 'pms')?></span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('filters', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label for="filters"><?=Language::show('filters', 'keywords');?> - <a class="clickAble" ng-click="addNewFilter()"><?=Language::show('create_filter', 'keywords')?></a></label>
                                        <select class="form-control selectFilterPicker" ng-model="filter" name="filters" id="filters" required title='Select Filters'>
                                            <?php if(!empty($data['filters'])){ ?>
                                                <?php foreach($data['filters'] as $key => $value){ ?>
                                                    <option value="<?=$value['filterName']?>"<?php if($value['defaultInclusionFilter'] == 'true'){ echo 'selected';}?>><?=$value['filterName']?></option>
                                                <?php } ?>
                                            <?php } ?>
                                        </select>
                                    </div>
                                </div>
                                <?php foreach($data['filters'] as $key => $value){
                                    if($value['defaultInclusionFilter'] == 'true'){ ?>
                                    <input id="currentfilter" type="text" value="<?=$value['filterName']?>" style="display: none;">
                                    <?php }} ?>
                                <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allFilters" ng-if="defaultFilter != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-filter"></i> <?=Language::show('filter', 'keywords');?></h5>
                                                </div>
                                                <div class="panel-body">
                                                    <?=Language::show('filterName', 'keywords');?>: {{ defaultFilter.filterName }}
                                                    <br/>
                                                    <?=Language::show('Filter Type', 'keywords');?>: {{ defaultFilter.filterType }}
                                                    <br/>
                                                    <?=Language::show('filters', 'keywords');?>: <b style="word-wrap: break-word">{{ defaultFilter.filters }}</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('cloudCredentials', 'keywords');?></legend>
                                        <div class="form-group">
                                            <label for="ccS"><?=Language::show('cloudCredentials', 'keywords');?> - <a class="clickAble" ng-click="addNewCcS()">Create New <?=Language::show('cloudCredentials', 'keywords');?></a></label>
                                            <select class="form-control selectCcSPicker" ng-model="ccS"  name="ccS" id="ccS" required title='Select <?=Language::show('ccS', 'keywords')?>'>
                                                <?php if(!empty($data['ccS'])){ ?>
                                                    <?php foreach($data['ccS'] as $key => $value){ ?>
                                                        <option value="<?=$value->{'cloudCredentialName'}?>"<?php if($value->{'defaultCloudCredentials'} == 'true'){ echo 'selected';}?>><?=$value->{'cloudCredentialName'}?></option>
                                                    <?php } ?>
                                                <?php }else{ ?>
                                                    <option selected disabled>Please Add A Cloud Credential</option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                </div>
                                <?php foreach($data['ccS'] as $key => $value){
                                    if($value->{'defaultCloudCredentials'} == 'true'){ ?>
                                    <input id="currentcloud" type="text" value="<?=$value->{'cloudCredentialName'}?>" style="display: none;">
                                    <?php }}    ?>
                                    <div class="col-lg-5">
                                    <br/><br/>
                                    <div class="row allClouds" ng-if="defaultCloud != undefined">
                                        <div class="col-lg-12">
                                            <div class="panel panel-default">
                                                <div class="panel-heading">
                                                    <h5> <i class="fa fa-cloud"></i> Clouds</h5>
                                                </div>
                                                <div class="panel-body">
                                                    <h5><?=Language::show('cloudName', 'settings');?>: {{ defaultCloud.cloudCredentialName }}</h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'azureBlob'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('azureBlob', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'ibmCloud'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('ibmSoftlayer', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'oneDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('microsoft', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'googleDrive'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('googleDrive', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'amazon'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('amazonS3', 'settings');?></h5>
                                                    <h5 class="cloudt" ng-show="defaultCloud.cloudName == 'localStorage'"><?=Language::show('cloudType', 'settings');?>: <?= Language::show('localStorage', 'settings');?></h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div role="tabpanel" class="tab-pane" id="advanced">
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('partialFileAttributes', 'keywords')?></legend>
                                    <div class="form-group partial">
                                        <label class="col-lg-4" for="incrementalFileTransfer"><?=Language::show('incrementalFileTransfer', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="incrementalFileTransfer" id="incrementalFileTransfer" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                    </div>
                                    </br>
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('networkThrottlingAttributes', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="col-lg-12" for="nwFromClientToPG"><?=Language::show('nwFromClientToPG', 'keywords');?> (In MBPS)</label>
                                        <div class="col-lg-2">
                                        <label class="switch">
                                            <input id="switch" type="checkbox">
                                            <div class="slider round"></div>
                                        </label></div>
                                        <div class="col-lg-8">
                                            <input type="text" class="form-control" name="nwFromClientToPG" id="nwFromClientToPG" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromClientToPG', 'keywords');?>" required autocomplete="off" value="UNLIMITED" onfocusout="myFunction();" disabled/>
                                            <span id="switcherror" style="color: #f55753;font-size: 0.9em;"></span>
                                        </div>
                                    </div>

                                    <div class="form-group hide">
                                        <label for="nwFromPGToCloud"><?=Language::show('nwFromPGToCloud', 'keywords');?> (In MBPS)</label>
                                        <input type="text" class="form-control" name="nwFromPGToCloud" id="nwFromPGToCloud" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('nwFromPGToCloud', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="filesCrawlLimit"><?=Language::show('filesCrawlLimit', 'keywords');?></label>
                                        <input type="text" class="form-control" name="filesCrawlLimit" id="filesCrawlLimit" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filesCrawlLimit', 'keywords');?>" required autocomplete="off" value="500" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group hide">
                                        <label for="networkThrottling"><?=Language::show('networkThrottling', 'keywords');?></label>
                                        <select class="form-control networkThrottling" name="networkThrottling" id="networkThrottling" required="" title='Select <?=Language::show('networkThrottling', 'keywords')?>'>
                                            <option value="true" selected><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                        </select>
                                    </div>
                                
                                </div>
                                <div class="col-lg-5">
                                    </br></br>
                                    <div class="row partialfileattributerow">
                                        <div class="col-lg-12">
                                             <div class="panel panel-default">
                                                
                                                <div class="panel-body">
                                            <div class="form-group">
                                        <label for="partialFileSize"><?=Language::show('partialFileSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="partialFileSize" id="partialFileSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('partialFileSize', 'keywords');?>" required autocomplete="off" value="5" data-parsley-type="integer" data-parsley-min="1" />
                                    </div>
                                    <div class="form-group">
                                        <label for="fileChunkableSize"><?=Language::show('fileChunkableSize', 'keywords');?> (In MB)</label>
                                        <input type="text" class="form-control" name="fileChunkableSize" id="fileChunkableSize" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('fileChunkableSize', 'keywords');?>" required autocomplete="off" value="4" data-parsley-type="integer" data-parsley-min="1" data-parsley-max="10" />
                                    </div>
                                        </div>
                                             </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row">
                                
                                
                            </div>
                            
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('options', 'keywords')?></legend>
                                    <div class="form-group">
                                        <div>
                                            <input id="legalHold" name="legalHold" type="checkbox" value="enabled" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            <label for="legalHold"><?=Language::show('legalHold', 'keywords');?></label>&nbsp;&nbsp;
                                            <span class="systemFolders" style="display: none;">
                                                <input id="systemFolders" name="systemFolders" type="checkbox" value="enabled" data-style="ios" data-toggle="toggle" data-on="Yes" data-off="No">
                                                <label for="systemFolders"><?=Language::show('systemFolders', 'keywords');?></label>
                                            </span>
                                        </div>
                                    </div>
                                    
                                        <div class="form-group dedup_god" style="display: none;">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup_god" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled"><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User" selected><?=Language::show('user', 'keywords')?></option>
                                            </select>
                                        </div>
                                    
                                        <div class="form-group dedup_oth" style="display: none;">
                                            <label for="dedup"><?=Language::show('dedup', 'keywords');?></label>
                                            <select class="form-control dedup" name="dedup" id="dedup_oth" required="" title='Select <?=Language::show('dedup', 'keywords')?>'>
                                                <option value="Disabled" ><?=Language::show('disabled', 'keywords')?></option>
                                                <option value="User"><?=Language::show('user', 'keywords')?></option>
                                                <option value="Global" selected><?=Language::show('global', 'keywords')?></option>
                                            </select>
                                        </div>
                                   
                                    <div class="form-group">
                                        <label class="col-lg-4" for="compEnabled"><?=Language::show('compEnabled', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="compEnabled" id="compEnabled" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                    </div>
                                    <div class="form-group vssContainer" style="display: none;">
                                        <label class="col-lg-4" for="vssEnabled"><?=Language::show('vss', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="vssEnabled" id="vssEnabled" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">  
                                    </div>
                                    <div class="form-group searchAlgoForPg">
                                        <label for="searchAlgoForPg"><?=Language::show('Blukrypt Search Algorithm', 'keywords');?></label>
                                        <select class="form-control searchAlgoForPg" name="searchAlgoForPg" id="sortAlgoForPg" required="" title='Select <?=Language::show('preventDownloadEnabled', 'keywords')?>'>
                                            <option value="NEAREST"><?=Language::show('nearest', 'keywords')?></option>
                                            <option value="PRIORITY"><?=Language::show('priority', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="Blukryptipaddress"><?=Language::show('privacyGateWayHostNames', 'keywords');?></label>
                                            <?php if(!empty($data['pgs'])){ ?>
                                                    <select class="blukryptIPAdress" multiple name="Blukryptipaddress[]" id="Blukryptipaddress" style="width: 100%">
                                                        <?php foreach($data['pgs'] as $key => $value){ ?>
                                                            <option  value="<?=$value['gatewayName']?>"><?=$value['gatewayName']?></option>
                                                        <?php } ?>
                                                    </select>
                                                    
                                            <?php } ?>
                                    </div>
                                                       
                                    <div class="form-group">
                                        <label for="policyRefresh"><?=Language::show('policyRefresh', 'keywords');?></label>
                                        <input type="number" class="form-control input-small" id="policyRefresh" name="policyRefresh" value="4" min="0" max="23" required="">
                                    </div>
                                    <div class="form-group hide">
                                        <label for="fullBackupEnabled"><?=Language::show('fullBackupEnabled', 'keywords');?></label>
                                        <select class="form-control fullBackupEnabled" name="fullBackupEnabled" id="fullBackupEnabled" required="" title='Select <?=Language::show('fullBackupEnabled', 'keywords')?>'>
                                            <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('disabled', 'keywords')?></option>

                                        </select>
                                    </div>
                                    <div class="form-group backupDate" style="display: none;">
                                        <label for="fullBackupStartDate"><?=Language::show('fullBackupStartDate', 'keywords');?></label>
                                        <input type="text" class="form-control backupDatePicker input-small" id="fullBackupStartDate" name="fullBackupStartDate" placeholder="Select date for full backup" autocomplete="off">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-7">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('Share Details', 'keywords')?></legend>
                                    <div class="form-group">
                                        <label class="col-lg-6" for="shareEnabled"><?=Language::show('share', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="shareEnabled" id="shareEnabled" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                    </div>
                                    <div class="form-group highSecureShareEnabled">
                                        <label class="col-lg-6" for="highSecureShareEnabled"><?=Language::show('highSecureShareEnabled', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="highSecureShareEnabled" id="highSecureShareEnabled" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                    </div>
                                    <div class="row highSecuredShareOptions">
                                        
                                        <div class="col-lg-12">
                                            <div class="form-group complexPasswordRequired"><div class="col-lg-6"><i class="fa fa-dot-circle-o"></i>&nbsp;&nbsp;
                                                <label for="complexPasswordRequired"><?=Language::show('complexPasswordRequired', 'keywords');?></label>
                                                </div><input class="col-lg-2 form-control" type="checkbox" name="complexPasswordRequired" id="complexPasswordRequired" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            </div>
                                        </div>
                                       
                                        <div class="col-lg-12">
                                            <div class="form-group preventDownloadEnabled"><div class="col-lg-6"><i class="fa fa-dot-circle-o"></i>&nbsp;&nbsp;
                                                <label for="preventDownloadEnabled"><?=Language::show('preventDownloadEnabled', 'keywords');?></label>
                                                </div><input class="col-lg-2 form-control" type="checkbox" name="preventDownloadEnabled" id="preventDownloadEnabled" value="true" checked data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-12">
                                            <div class="form-group expiredDate"><div class="col-lg-6"><i class="fa fa-dot-circle-o"></i>&nbsp;&nbsp;
                                                <label for="expiredDate"><?=Language::show('expiredDate', 'keywords');?></label>
                                                </div><input class="col-lg-2 form-control" type="checkbox" name="expiredDate" id="expiredDate" value="true" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-12">
                                    <legend class="h4" style="color: #585f69; margin-left: -17px;"><?=Language::show('uISettingsForAgent', 'keywords')?></legend>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="col-lg-4" for="exitt"><?=Language::show('EXIT', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="exitt" id="exitt" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="decouple"><?=Language::show('DECOUPLE', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="decouple" id="decouple" checked value="Yes"  data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="support"><?=Language::show('SUPPORT', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="support" id="support" checked value="Yes"  data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="initiatebackup"><?=Language::show('INTIATE_BACKUP', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="initiatebackup" id="initiatebackup" checked value="Yes"  data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="restore"><?=Language::show('RESTORE', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="restore" id="restore" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="col-lg-4" for="stopbackup"><?=Language::show('STOP_BACKUP', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="stopbackup" id="stopbackup" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                        
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="bkpsettings"><?=Language::show('BACKUP_SETTINGS', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="bkpsettings" id="bkpsettings" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="bkpfiles"><?=Language::show('BACKUP_FILES', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="bkpfiles" id="bkpfiles" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                       
                                    </div>
                                    <div class="form-group">
                                        <label class="col-lg-4" for="refbkppolicy"><?=Language::show('REFRESH_BACKUP_POLICY', 'keywords');?></label>
                                        <input class="col-lg-2 form-control" type="checkbox" name="refbkppolicy" id="refbkppolicy" checked value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">                                     
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br/>
                    <div class="row">
                        <div class="col-lg-7">
                            <button type="submit" class="submit btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                    </div>
                    <?=
                    Form::close();
                    ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade createSchedule">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'scheduleForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'scheduleCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create Schedule</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group col-lg-12">
                            <label class="col-lg-3" for="defaultSchedules" style="margin-left: -30px;"><?=Language::show('makeScheduleDefault', 'keywords');?></label>
                                <div>
                                    <label class="switch col-lg-9">
                                    <input id="switch" name="defaultSchedule" type="checkbox">
                                    <div class="slider round"></div>
                                    </label>
                                </div>
                    </div>
                    <div class="form-group">
                        <label for="scheduleName"><?=Language::show('scheduleName', 'keywords');?></label>
                        <input type="text" class="form-control" value="" name="scheduleName" id="scheduleName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="scheduleTimeZone hide"><?=Language::show('scheduleTimeZone', 'keywords');?></label>
                        <input type="text" class="form-control" name="scheduleTimeZone" id="scheduleTimeZone" value="IST" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('scheduleTimeZone', 'keywords');?>" required autocomplete="off" readonly>
                    </div>
                    <div class="form-group">
                        <label for="scheduleStartTime"><?=Language::show('scheduleStartTime', 'keywords');?></label>
                        <input type="text" class="form-control timePicker input-small" id="scheduleStartTime" name="scheduleStartTime">
                    </div>
                    <div class="form-group">
                        <label for="days"><?=Language::show('days', 'keywords');?></label>
                        <a href="javascript:;" class="scheduleDaily" ng-click="toggleSelectPickerAll()">Daily</a>
                        <select class="form-control selectPicker" name="days[]" id="days" required="" multiple title='Select days'>
                            <option value="1"><?=Language::show('sunday', 'keywords')?></option>
                            <option value="2"><?=Language::show('monday', 'keywords')?></option>
                            <option value="3"><?=Language::show('tuesday', 'keywords')?></option>
                            <option value="4"><?=Language::show('wednesday', 'keywords')?></option>
                            <option value="5"><?=Language::show('thursday', 'keywords')?></option>
                            <option value="6"><?=Language::show('friday', 'keywords')?></option>
                            <option value="7"><?=Language::show('saturday', 'keywords')?></option>
                        </select>
                    </div>
		        <div>
                            <p>Note:- The above schedule will be honored in the time zone under which the Parablu endpoint agent is operating.</p>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
    <div class="modal fade createCcS" id="addCloudCredentials" tabindex="-1" role="dialog">
                    <div class="modal-dialog modal-lg">
                        <div class="modal-content">
                            <?=
                            Form::open(array(
                                'ng-submit' => 'saveCloudCredentials(true)',
                                'class' => 'cloudCredentials',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                'data-parsley-validate' => true
                            ));
                            ?>
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title">Add your Cloud Credentials</h4>
                            </div>
                            <div class="modal-body">
				<div class="form-group col-lg-12">
                                            <label class="col-lg-3" for="defaultCloudCredentials" style="margin-left: -30px;"><?=Language::show('makeCloudDefault', 'keywords');?></label>
                                                <div>
                                                    <label class="switch col-lg-9">
                                                    <input id="switchedit" name="defaultCloudCredentials" type="checkbox">
                                                    <div class="slider round"></div>
                                                    </label>
                                                </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-lg-6">
                                        <label for="cloudType">Cloud Type</label>
                                        <select class="form-control" name="cloudType" id="cloudType">
                                            <option value="azureBlob"><?=Language::show('azureBlob', 'settings')?></option>
                                            <option value="ibmCloud"><?=Language::show('ibmSoftlayer', 'settings')?></option>
                                            <option value="amazon"><?=Language::show('amazonS3', 'settings')?></option>
                                            <option value="localStorage"><?=Language::show('localStorage', 'settings')?></option>
                                            <option value="oneDrive"><?=Language::show('microsoft', 'settings')?></option>
                                            <option value="googleDrive"><?=Language::show('googleDrive', 'settings')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-6 cloudCredentialName">
                                        <label for="cloudCredentialName"><?=Language::show('cloudName', 'settings')?></label>
                                        <a href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('cloudNameInfo', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                        <input type="text" class="form-control" name="cloudCredentialName" id="cloudCredentialName" value="" placeholder="<?=Language::show('cloudNamePH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 identity">
                                        <label for="identity">Identity</label>
                                        <input type="text" class="form-control" name="identity" id="identity" value="" placeholder="<?=Language::show('cloudIdentityPH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-6 accessKey">
                                        <label for="accessKey">Access key</label>
                                        <input type="text" class="form-control" name="accessKey" id="accessKey" value="" placeholder="<?=Language::show('accessKeyPH', 'settings')?>" required autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 epaUrl" style="display: none;">
                                        <label for="epaUrl">End Point URL</label>
                                        <input type="text" class="form-control" name="epaUrl" id="epaUrl" value="" placeholder="<?=Language::show('endPointURLPH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 containerName" style="display: none;">
                                        <label for="containerName">Amazon Container Name</label>
                                        <input type="text" class="form-control" name="containerName" id="containerName" value="" placeholder="<?=Language::show('amazonContainerNamePH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <div class="form-group col-lg-12 localStorage" style="display: none;">
                                        <label for="localStorage">Local Storage Folder Name</label>
                                        <input type="text" class="form-control" name="localStorage" id="localStorage" value="" placeholder="<?=Language::show('folderNamePH', 'settings')?>" autocomplete="off">
                                    </div>
                                    <!--Google starts-->
                                    <div class="forGD hide" >
                                        <div class="panel-body">
                                            <input type="text" class="hide" hidden value="<?=$ccS["configId"]?>" name="configId" />
                                            <div class="form-group col-lg-6">
                                                <label for="clientId">Client ID</label>
                                                 <a class="odbclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('oneDriveClintID', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                 <a class="gclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('googleDriveClintID', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientId" id="clientId" value="" placeholder="<?=Language::show('clientIDPH', 'settings')?>" autocomplete="off">
                                                </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientSecret"><?=Language::show('clintIDH', 'settings')?></label>
                                                <a class="gclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('googleDriveSecreteKey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <a class="odbclientSecret" href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('oneDriveSecreteKey', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="{{value.credential}}" placeholder="<?=Language::show('secretKeyPH', 'settings')?>" autocomplete="off">
                                                
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientRedirectURI">Client Redirect URI</label>
                                                <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('clientRedirectURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="{{value.clientRedirectUri}}" placeholder="<?=Language::show('redirectURIPH', 'settings')?>" autocomplete="off">
                                           </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientResourceURL">Client Resource URL</label>
                                                <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('resourceURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="{{value.clientResourceUrl}}" placeholder="<?=Language::show('clientResourceURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="clientTokenURL">Client Token URL</label>
                                                 <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('resourceURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="{{value.clientTokenUrl}}" placeholder="<?=Language::show('clientTokenURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                            <div class="form-group col-lg-6">
                                                <label for="portalURL">Portal URL</label>
                                                 <a  href="#" data-toggle="tooltip" data-placement="top" title="<?=Language::show('portalURL', 'settings')?>"><i class="fa fa-question-circle" aria-hidden="true"></i></a>
                                                <input type="text" class="form-control" name="portalURL" id="portalURL" value="{{value.endPointUrl}}" placeholder="<?=Language::show('portalURLPH', 'settings')?>" autocomplete="off">
                                            </div>
                                        </div>
                                    </div>
                                <!--Google ends -->
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-success">Save</button>
                                <button type="button" class="btn btn-danger" ng-click="closeModal()" data-dismiss="modal">Cancel</button>
                            </div>
                            <?=
                            Form::close();
                            ?>
                        </div>
                    </div>
    </div>   <div class="modal fade createFilter">
        <div class="modal-dialog">
            <div class="modal-content mediumModal">
                <?=
                Form::open(array(
                    'csrf' => $data['csrf_token'],
                    'class' => 'filterForm',
                    'autocomplete' => 'off',
                    'ng-submit' => 'filterCreate(true)',
                    'data-parsley-validate' => true
                ));
                ?>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Create Filter</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group col-lg-12">
                            <label class="col-lg-2" for="defaultFilter" style="margin-left: -30px;"><?=Language::show('makeFilterDefault', 'keywords');?></label>
                                <div>
                                    <label class="switch col-lg-10">
                                    <input id="switchfilter" name="defaultInclusionFilter" type="checkbox">
                                    <div class="slider round"></div>
                                    </label>
                                </div>
                    </div>
                    <div class="form-group">
                        <label for="filterName"><?=Language::show('filterName', 'keywords');?></label>
                        <input type="text" class="form-control" name="filterName" id="filterName" value="" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filterName', 'keywords');?>" required autocomplete="off">
                    </div>
                    <div class="form-group">
                        <label for="filterType"><?=Language::show('filterType', 'keywords')?></label>
                        <select class="form-control filterType" name="filterType" id="filterType" required>
                            <option value="inclusion">Inclusion Filter</option>
                            <option value="exclusion">Exclusion Filter</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filters"><?=Language::show('filters', 'keywords');?></label><br/>
                        <input type="text" data-role="tagsinput" value="doc,docx,ppt,pptx,txt,pdf,jpg,png" class="form-control editFilters" name="filters[]" id="editFilters" placeholder="<?=Language::show('enter', 'keywords');?> <?=Language::show('filters', 'keywords');?>" required autocomplete="off">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
                <?= Form::close(); ?>
            </div>
        </div>
    </div>
</div>
<?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#fullBackupStartDate').prop("readonly", true);
    $('.filterType').selectpicker('render');
    $('.compEnabled').selectpicker('render');
    $('.selectCcSPicker').selectpicker('render');
    $('.selectSchedulePicker').selectpicker('render');
    $('.vssEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render').on('change', function(){
        if($('.selectOsTypePicker').val() == 'windows'){
            $('.vssContainer').show();
        }else{
            $('.vssContainer').hide();
        }
    });
    $('.dedup').selectpicker('render');
    $('.fullBackupEnabled').selectpicker('render');
    $('.selectOsTypePicker').selectpicker('render');
    $( "#incrementalFileTransfer" ).change(function() {
    if($('#incrementalFileTransfer').is(":checked"))
    {
                $('.partialfileattributerow').removeClass('hide');
                $('#partialFileSize').removeAttr('disabled', 'disabled');
                $('#fileChunkableSize').removeAttr('disabled', 'disabled');
    }
    else{
                $('.partialfileattributerow').addClass('hide');
                $('#partialFileSize').attr('disabled', 'disabled');
                $('#fileChunkableSize').attr('disabled', 'disabled');
    }
   });
    $('.networkThrottling').selectpicker('render');
    $('.selectFilterPicker').selectpicker('render');
    $('.dcmEnabled').selectpicker('render');
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
    $('.backupDatePicker').datepicker({
        format: 'dd-mm-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+0d',
        todayHighlight: true
    });
    $('#fullBackupEnabled').on('change', function(){
        var option = $('#fullBackupEnabled').val();
        if(option == 'true'){
            $('.backupDate').show();
            $('[name="fullBackupStartDate"').attr('required', 'required');
        }else{
            $('.backupDate').hide();
        }
    });
    $('#sortAlgoForPg').on('change', function(){
        var option = $('#sortAlgoForPg').val();
        if(option == 'PRIORITY'){
            $('#Blukryptipaddress').attr('required', 'required');
        }else{
            $('#Blukryptipaddress').removeAttr('required', 'required');
        }
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#cloudType').selectpicker('render');
    $('#cloudType').on('change', function(){
        var type = $('#cloudType').val();
        if(type == 'amazon'){
            $('.localStorage').hide();
            $('.containerName').show();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="containerName"').attr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 'ibmCloud'){
            $('.localStorage').hide();
            $('.containerName').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('.epaUrl').show();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="epaUrl"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');
        }else if(type == 'localStorage'){
            $('.localStorage').show();
            $('[name="localStorage"').attr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
        }else if(type == 'googleDrive'){
            $('.localStorage').hide();
            // $('[name="localStorage"').attr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('.forGD').removeClass('hide');
            //$('.forODB').addClass('hide');
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
            $('.gdhead').removeClass('hide');
            $('.gclientId').removeClass('hide');
            $('.gclientSecret').removeClass('hide');
            $('.gclientRedirectURI').removeClass('hide');
            $('.gclientResourceURL').removeClass('hide');
            $('.gclientTokenURL').removeClass('hide');
            $('.gportalURL').removeClass('hide');
            $('.odhead').addClass('hide');
            $('.odbclientId').addClass('hide');
            $('.odbclientSecret').addClass('hide');
            $('.odbclientRedirectURI').addClass('hide');
            $('.odbclientResourceURL').addClass('hide');
            $('.odbclientTokenURL').addClass('hide');
            $('.odbportalURL').addClass('hide');
        }else if(type == 'oneDrive'){
            $('.localStorage').hide();
            // $('[name="localStorage"').attr('required', 'required');
            $('.accessKey').hide();
            $('.identity').hide();
            $('.epaUrl').hide();
            $('.containerName').hide();
            $('.forGD').removeClass('hide');
            //$('.forODB').removeClass('hide');
            $('[name="accessKey"').removeAttr('required', 'required');
            $('[name="identity"').removeAttr('required', 'required');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('[name="containerName"').removeAttr('required', 'required');
            $('.odhead').removeClass('hide');
            $('.odbclientId').removeClass('hide');
            $('.odbclientSecret').removeClass('hide');
            $('.odbclientRedirectURI').removeClass('hide');
            $('.odbclientResourceURL').removeClass('hide');
            $('.odbclientTokenURL').removeClass('hide');
            $('.odbportalURL').removeClass('hide');
            $('.gdhead').addClass('hide');
            $('.gclientId').addClass('hide');
            $('.gclientSecret').addClass('hide');
            $('.gclientRedirectURI').addClass('hide');
            $('.gclientResourceURL').addClass('hide');
            $('.gclientTokenURL').addClass('hide');
            $('.gportalURL').addClass('hide');
        }else{
            $('.localStorage').hide();
            $('.epaUrl').hide();
            $('.accessKey').show();
            $('.identity').show();
            $('.forGD').addClass('hide');
            $('.forODB').addClass('hide');
            $('[name="epaUrl"').removeAttr('required', 'required');
            $('.containerName').hide();
            $('[name="containerName"').removeAttr('required', 'required');
            $('[name="accessKey"').attr('required', 'required');
            $('[name="identity"').attr('required', 'required');
            $('[name="localStorage"').removeAttr('required', 'required');

            $('.access_key').addClass("hide");
            $('#access_key').removeAttr('required', 'required');
            $('.client_secret').addClass("hide");
            $('#client_secret').removeAttr('required', 'required');
            $('#client_redirect').removeAttr('required', 'required');
            $('#client_resource_url').removeAttr('required', 'required');
            $('#client_token').removeAttr('required', 'required');
            $('#portal_url').removeAttr('required', 'required');
        }
    });
</script>
<script>
    $( "#shareEnabled" ).change(function() {
    if($('#shareEnabled').is(":checked"))
    {
            $('.highSecuredShareOptions').show();
            $('.highSecureShareEnabled').show();
        }else{
            $('.highSecuredShareOptions').hide();
            $('.highSecureShareEnabled').hide();
        }
    });
    
    $( "#highSecureShareEnabled" ).change(function() {
    if($('#highSecureShareEnabled').is(":checked"))
    {
        $('#expiredDate').bootstrapToggle('on');
        $('#complexPasswordRequired').bootstrapToggle('on');
        $('#preventDownloadEnabled').bootstrapToggle('off');
            
        $('#complexPasswordRequired').attr("disabled", true);
        $('#preventDownloadEnabled').attr("disabled", true);
        $('#expiredDate').attr("disabled", true);

    }else{
            
        $('#expiredDate').bootstrapToggle('off');
        $('#complexPasswordRequired').bootstrapToggle('off');
        $('#preventDownloadEnabled').bootstrapToggle('on');
            
        $('#complexPasswordRequired').attr("disabled", false);
        $('#preventDownloadEnabled').attr("disabled", false);
        $('#expiredDate').attr("disabled", false);

        }
    });

    $('.complexPasswordRequired').selectpicker('render').on('change', function(){
        if($('#complexPasswordRequired').val() == "true" && $('#preventDownloadEnabled').val() == "true" && $('#expiredDate').val() == "true"){
            $('#highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }else{
            $('#highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }
    });

    $('.preventDownloadEnabled').selectpicker('render').on('change', function(){
        if($('#complexPasswordRequired').val() == "true" && $('#preventDownloadEnabled').val() == "true" && $('#expiredDate').val() == "true"){
            $('#highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }else{
            $('#highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }
    });
    $('.expiredDate').selectpicker('render').on('change', function(){
        if($('#complexPasswordRequired').val() == "true" && $('#preventDownloadEnabled').val() == "true" && $('#expiredDate').val() == "true"){
            $('#highSecureShareEnabled').find('option[value="true"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }else{
            $('#highSecureShareEnabled').find('option[value="false"]').prop("selected",true);
            $('#highSecureShareEnabled').selectpicker('refresh');
        }
    });
</script>

<script type="text/javascript">
    $(".blukryptIPAdress").select2();

    $(".blukryptIPAdress").on("select2:select", function (evt) {
        var element = evt.params.data.element;
        var $element = $(element);

        $element.detach();
        $(this).append($element);
        $(this).trigger("change");
        //$('#sortAlgoForPg').find('option[value="PRIORITY"]').prop("selected",true);
    });
</script>
<script>
    $('.timePicker').timepicker({
        showMeridian: false
    });
</script>
<script>
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();   
});
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 60px;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(26px);
  -ms-transform: translateX(26px);
  transform: translateX(26px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
    $("#switch").click(function(){
        document.getElementById("switcherror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#nwFromClientToPG').removeAttr('disabled'); //enable input
        $('#nwFromClientToPG').val('');
        
    } else {
        
        $('#nwFromClientToPG').attr('disabled', true); //disable input
        $('#nwFromClientToPG').val('UNLIMITED');
    }
        });

    $("#switchsize").click(function(){
        document.getElementById("sizeerror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxPermissibleFileSize').removeAttr('disabled'); //enable input
        $('#maxPermissibleFileSize').val('');
        
    } else {
        
        $('#maxPermissibleFileSize').attr('disabled', true); //disable input
        $('#maxPermissibleFileSize').val('UNLIMITED');
    }
        });
    
    $("#switchlimit").click(function(){
        document.getElementById("limiterror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#perUserBackupStorageLimit').removeAttr('disabled'); //enable input
        $('#perUserBackupStorageLimit').val('');
        
    } else {
        
        $('#perUserBackupStorageLimit').attr('disabled', true); //disable input
        $('#perUserBackupStorageLimit').val('UNLIMITED');
    }
        });

    $("#switchver").click(function(){
        document.getElementById("vererror").innerHTML = "";
        if ($(this).is(':checked')) {
        
        $('#maxVersions').removeAttr('disabled'); //enable input
        $('#maxVersions').val('3');
        
    } else {
        
        $('#maxVersions').attr('disabled', true); //disable input
        $('#maxVersions').val('UNLIMITED');
    }
        });
</script>

<script>
    function myFunction(){
        document.getElementById("switcherror").innerHTML = "";
        if(isNaN($('#nwFromClientToPG').val()))
        {
        if (  $('#nwFromClientToPG').val() !='UNLIMITED')  {
            document.getElementById("switcherror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        }
        else if(!isNaN($('#nwFromClientToPG').val()) && $('#nwFromClientToPG').val() > 9999){
            document.getElementById("switcherror").innerHTML = "Network Throttle Setting from Client to BluKrypt Allowed is 9999";
        }
        else if($('#nwFromClientToPG').val().indexOf(".")!=-1){
             document.getElementById("switcherror").innerHTML = "Please enter a integral value";
         }
        else{
        document.getElementById("switcherror").innerHTML = "";
        }
    }
    
    function myFunctionMPS(){
        document.getElementById("sizeerror").innerHTML = "";
        if(isNaN($('#maxPermissibleFileSize').val()))
        {
        if (  $('#maxPermissibleFileSize').val() !='UNLIMITED')  {
            document.getElementById("sizeerror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
        }
        
        }
        else if(!isNaN($('#maxPermissibleFileSize').val()) && $('#maxPermissibleFileSize').val() > 999999){
            document.getElementById("sizeerror").innerHTML = "Maximum Permissible File Size Allowed is 999999";
        }
        else if($('#maxPermissibleFileSize').val().indexOf(".")!=-1){
             document.getElementById("sizeerror").innerHTML = "Please enter a integral value";
         }
        else{
        document.getElementById("sizeerror").innerHTML = "";
        }
    }
    
    function myFunctionUBS(){
        document.getElementById("limiterror").innerHTML = "";
        if(isNaN($('#perUserBackupStorageLimit').val()))
        {
        if (  $('#perUserBackupStorageLimit').val() !='UNLIMITED')  {
            document.getElementById("limiterror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
            //alert('Invalid Input');
           }
        }
        else if(!isNaN($('#perUserBackupStorageLimit').val()) && $('#perUserBackupStorageLimit').val() > 99999){
            document.getElementById("limiterror").innerHTML = "Maximum Per User Backup Storage Limit Allowed is 99999";
        }
        else if($('#perUserBackupStorageLimit').val().indexOf(".")!=-1){
             document.getElementById("limiterror").innerHTML = "Please enter a integral value";
         }
        else{
        document.getElementById("limiterror").innerHTML = "";
        }
    }

    function myFunctionVer(){
        document.getElementById("vererror").innerHTML = "";
        if(isNaN($('#maxVersions').val()))
        {
            if (  $('#maxVersions').val() !='UNLIMITED')  {
                document.getElementById("vererror").innerHTML = "Input can be either 'UNLIMITED' or any integer";
                //alert('Invalid Input');
            }
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() < 1){
            document.getElementById("vererror").innerHTML = "Minimum number of Versions Allowed is 1";
        }
        else if(!isNaN($('#maxVersions').val()) && $('#maxVersions').val() > 10000000){
            document.getElementById("vererror").innerHTML = "Maximum number of Versions Allowed is 1 Crore";
        }
        else{
            document.getElementById("vererror").innerHTML = "";
        }
    }
</script>